/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodBodyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeMethodSignatureFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeParameterClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeStringLiteralToCharInMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConstructorParametersFixer;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateAbstractMethodFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromSuperFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromThisFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreatePropertyFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteMethodBodyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InsertNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InsertSuperFix;
import com.intellij.codeInsight.daemon.impl.quickfix.PermuteArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceAddAllArrayToCollectionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SuperMethodReturnFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithArrayFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightMethodUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    public static String createClashMethodMessage(PsiMethod method1, PsiMethod method2, boolean showContainingClasses) {
        String pattern = showContainingClasses ? "clash.methods.message.show.classes" : "clash.methods.message";
        return JavaErrorMessages.message(pattern, HighlightUtil.formatMethod(method1), HighlightUtil.formatMethod(method2), HighlightUtil.formatClass(method1.getContainingClass()), HighlightUtil.formatClass(method2.getContainingClass()));
    }

    public static HighlightInfo checkMethodWeakerPrivileges(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo) {
        if (methodSignature == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil.checkMethodWeakerPrivileges must not be null");
        }
        if (superMethodSignatures == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil.checkMethodWeakerPrivileges must not be null");
        }
        PsiMethod method = methodSignature.getMethod();
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList.hasModifierProperty("public")) {
            return null;
        }
        int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
        String accessModifier = PsiUtil.getAccessModifier((int)accessLevel);
        for (HierarchicalMethodSignature superMethodSignature : superMethodSignatures) {
            HighlightInfo info;
            PsiMethod superMethod = superMethodSignature.getMethod();
            if (!PsiUtil.isAccessible((PsiMember)superMethod, (PsiElement)method, null) || (info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, includeRealPositionInfo)) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo isWeaker(PsiMethod method, PsiModifierList modifierList, String accessModifier, int accessLevel, PsiMethod superMethod, boolean includeRealPositionInfo) {
        int superAccessLevel = PsiUtil.getAccessLevel((PsiModifierList)superMethod.getModifierList());
        if (accessLevel < superAccessLevel) {
            TextRange textRange;
            String message = JavaErrorMessages.message("weaker.privileges", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), accessModifier, PsiUtil.getAccessModifier((int)superAccessLevel));
            if (includeRealPositionInfo) {
                if (modifierList.hasModifierProperty("packageLocal")) {
                    textRange = method.getNameIdentifier().getTextRange();
                } else {
                    PsiElement keyword = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)accessModifier);
                    textRange = keyword.getTextRange();
                }
            } else {
                textRange = new TextRange(0, 0);
            }
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, message);
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, PsiUtil.getAccessModifier((int)superAccessLevel), true, false);
            QuickFixAction.registerQuickFixAction(highlightInfo, fix);
            return highlightInfo;
        }
        return null;
    }

    public static HighlightInfo checkMethodIncompatibleReturnType(MethodSignatureBackedByPsiMethod methodSignature, List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo) {
        PsiMethod method = methodSignature.getMethod();
        PsiType returnType = methodSignature.getSubstitutor().substitute(method.getReturnType());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        for (HierarchicalMethodSignature superMethodSignature : superMethodSignatures) {
            HighlightInfo highlightInfo;
            PsiClass superClass;
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiType declaredReturnType = superMethod.getReturnType();
            PsiType superReturnType = superMethodSignature.getSubstitutor().substitute(declaredReturnType);
            if (superMethodSignature.isRaw()) {
                superReturnType = TypeConversionUtil.erasure((PsiType)declaredReturnType);
            }
            if (returnType == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null || (highlightInfo = HighlightMethodUtil.checkSuperMethodSignature(superMethod, (MethodSignatureBackedByPsiMethod)superMethodSignature, superReturnType, method, methodSignature, returnType, includeRealPositionInfo, JavaErrorMessages.message("incompatible.return.type", new Object[0]), method)) == null) continue;
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodSignature(PsiMethod superMethod, MethodSignatureBackedByPsiMethod superMethodSignature, PsiType superReturnType, PsiMethod method, MethodSignatureBackedByPsiMethod methodSignature, PsiType returnType, boolean includeRealPositionInfo, String detailMessage, PsiMethod methodToHighlight) {
        PsiSubstitutor unifyingSubstitutor;
        if (superReturnType == null) {
            return null;
        }
        boolean isJdk15 = PsiUtil.isLanguageLevel5OrHigher((PsiElement)method);
        PsiType substitutedSuperReturnType = isJdk15 && !superMethodSignature.isRaw() && superMethodSignature.equals((Object)methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superMethodSignature.getSubstitutor().substitute(superReturnType))) : TypeConversionUtil.erasure((PsiType)superReturnType);
        if (returnType.equals(substitutedSuperReturnType)) {
            return null;
        }
        if (!(returnType instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && isJdk15 && TypeConversionUtil.isAssignable((PsiType)substitutedSuperReturnType, (PsiType)returnType)) {
            return null;
        }
        return HighlightMethodUtil.createIncompatibleReturnTypeMessage(methodToHighlight, method, superMethod, includeRealPositionInfo, substitutedSuperReturnType, returnType, detailMessage);
    }

    private static HighlightInfo createIncompatibleReturnTypeMessage(PsiMethod methodToHighlight, PsiMethod method, PsiMethod superMethod, boolean includeRealPositionInfo, PsiType substitutedSuperReturnType, PsiType returnType, String detailMessage) {
        String message = MessageFormat.format("{0}; {1}", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), detailMessage);
        TextRange textRange = includeRealPositionInfo ? methodToHighlight.getReturnTypeElement().getTextRange() : new TextRange(0, 0);
        HighlightInfo errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, message);
        IntentionAction fix = QUICK_FIX_FACTORY.createMethodReturnFix(method, substitutedSuperReturnType, false);
        QuickFixAction.registerQuickFixAction(errorResult, fix);
        QuickFixAction.registerQuickFixAction(errorResult, new SuperMethodReturnFix(superMethod, returnType));
        return errorResult;
    }

    static HighlightInfo checkMethodOverridesFinal(MethodSignatureBackedByPsiMethod methodSignature, List<HierarchicalMethodSignature> superMethodSignatures) {
        PsiMethod method = methodSignature.getMethod();
        for (HierarchicalMethodSignature superMethodSignature : superMethodSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            HighlightInfo info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodIsFinal(PsiMethod method, PsiMethod superMethod) {
        if (superMethod.hasModifierProperty("final")) {
            String message = JavaErrorMessages.message("final.method.override", HighlightUtil.formatMethod(method), HighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superMethod.getContainingClass()));
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            HighlightInfo errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, message);
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)superMethod, "final", false, true);
            QuickFixAction.registerQuickFixAction(errorResult, fix);
            return errorResult;
        }
        return null;
    }

    public static HighlightInfo checkMethodIncompatibleThrows(MethodSignatureBackedByPsiMethod methodSignature, List<HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, PsiClass analyzedClass) {
        PsiJavaCodeReferenceElement[] referenceElements;
        ArrayList<PsiJavaCodeReferenceElement> exceptionContexts;
        PsiMethod method = methodSignature.getMethod();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)analyzedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiClassType[] exceptions = method.getThrowsList().getReferencedTypes();
        if (includeRealPositionInfo) {
            exceptionContexts = new ArrayList<PsiJavaCodeReferenceElement>();
            referenceElements = method.getThrowsList().getReferenceElements();
        } else {
            exceptionContexts = null;
            referenceElements = null;
        }
        ArrayList<PsiClassType> checkedExceptions = new ArrayList<PsiClassType>();
        for (int i = 0; i < exceptions.length; ++i) {
            PsiClassType exception = exceptions[i];
            if (ExceptionUtil.isUncheckedException(exception)) continue;
            checkedExceptions.add(exception);
            if (!includeRealPositionInfo || i >= referenceElements.length) continue;
            PsiJavaCodeReferenceElement exceptionRef = referenceElements[i];
            exceptionContexts.add(exceptionRef);
        }
        for (HierarchicalMethodSignature superMethodSignature : superMethodSignatures) {
            TextRange textRange;
            PsiMethod superMethod = superMethodSignature.getMethod();
            int index = HighlightMethodUtil.getExtraExceptionNum((MethodSignature)methodSignature, (MethodSignatureBackedByPsiMethod)superMethodSignature, checkedExceptions, superSubstitutor);
            if (index == -1) continue;
            PsiClassType exception = (PsiClassType)checkedExceptions.get(index);
            String message = JavaErrorMessages.message("overridden.method.does.not.throw", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), HighlightUtil.formatType((PsiType)exception));
            if (includeRealPositionInfo) {
                PsiElement exceptionContext = (PsiElement)exceptionContexts.get(index);
                textRange = exceptionContext.getTextRange();
            } else {
                textRange = new TextRange(0, 0);
            }
            HighlightInfo errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, message);
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, false, false));
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMethodThrowsFix(superMethod, exception, true, true));
            return errorResult;
        }
        return null;
    }

    private static int getExtraExceptionNum(MethodSignature methodSignature, MethodSignatureBackedByPsiMethod superSignature, List<PsiClassType> checkedExceptions, PsiSubstitutor substitutorForDerivedClass) {
        PsiMethod superMethod = superSignature.getMethod();
        PsiSubstitutor substitutorForMethod = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superSignature);
        if (substitutorForMethod == null) {
            return -1;
        }
        for (int i = 0; i < checkedExceptions.size(); ++i) {
            PsiType exception = substitutorForDerivedClass.substitute(substitutorForMethod.substitute((PsiType)checkedExceptions.get(i)));
            if (HighlightMethodUtil.isMethodThrows(superMethod, substitutorForMethod, exception, substitutorForDerivedClass)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isMethodThrows(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiType exception, PsiSubstitutor substitutorForDerivedClass) {
        PsiClassType[] thrownExceptions;
        for (PsiClassType thrownException1 : thrownExceptions = method.getThrowsList().getReferencedTypes()) {
            PsiType thrownException = substitutorForMethod.substitute((PsiType)thrownException1);
            if (!TypeConversionUtil.isAssignable((PsiType)(thrownException = substitutorForDerivedClass.substitute(thrownException)), (PsiType)exception)) continue;
            return true;
        }
        return false;
    }

    public static HighlightInfo checkMethodCall(PsiMethodCallExpression methodCall, PsiResolveHelper resolveHelper) {
        HighlightInfo highlightInfo;
        CandidateInfo[] candidates;
        PsiExpressionList list = methodCall.getArgumentList();
        PsiReferenceExpression referenceToMethod = methodCall.getMethodExpression();
        JavaResolveResult resolveResult = referenceToMethod.advancedResolve(true);
        PsiElement element = resolveResult.getElement();
        boolean isDummy = false;
        boolean isThisOrSuper = referenceToMethod.getReferenceNameElement() instanceof PsiKeyword;
        if (isThisOrSuper && list.getExpressions().length == 0 && (candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true)).length == 1 && !candidates[0].getElement().isPhysical()) {
            isDummy = true;
        }
        if (isDummy) {
            return null;
        }
        if (element instanceof PsiMethod && resolveResult.isValidResult()) {
            TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
            highlightInfo = HighlightUtil.checkUnhandledExceptions((PsiElement)methodCall, fixRange);
            if (highlightInfo == null) {
                highlightInfo = GenericsHighlightUtil.checkUncheckedCall(resolveResult, (PsiCall)methodCall);
            }
            if (highlightInfo == null) {
                highlightInfo = GenericsHighlightUtil.checkGenericCallWithRawArguments(resolveResult, (PsiCallExpression)methodCall);
            }
        } else {
            PsiMethod resolvedMethod = null;
            MethodCandidateInfo candidateInfo = null;
            if (resolveResult instanceof MethodCandidateInfo) {
                candidateInfo = (MethodCandidateInfo)resolveResult;
                resolvedMethod = candidateInfo.getElement();
            }
            if (!resolveResult.isAccessible() || !resolveResult.isStaticsScopeCorrect()) {
                highlightInfo = HighlightMethodUtil.checkAmbiguousMethodCall(referenceToMethod, list, element, resolveResult, methodCall, resolveHelper);
            } else if (candidateInfo != null && !candidateInfo.isApplicable()) {
                if (candidateInfo.isTypeArgumentsApplicable()) {
                    String methodName = HighlightMessageUtil.getSymbolName(element, resolveResult.getSubstitutor());
                    PsiElement parent = element.getParent();
                    String containerName = parent == null ? "" : HighlightMessageUtil.getSymbolName(parent, resolveResult.getSubstitutor());
                    String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                    String description = JavaErrorMessages.message("wrong.method.arguments", methodName, containerName, argTypes);
                    String toolTip = parent instanceof PsiClass && !ApplicationManager.getApplication().isUnitTestMode() ? HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list) : description;
                    highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)list, description, toolTip);
                    HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list, resolveHelper);
                    highlightInfo.navigationShift = 1;
                } else {
                    PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
                    PsiReferenceParameterList typeArgumentList = methodCall.getTypeArgumentList();
                    highlightInfo = typeArgumentList.getTypeArguments().length == 0 && resolvedMethod.hasTypeParameters() ? GenericsHighlightUtil.checkInferredTypeArguments(resolvedMethod, methodCall, resolveResult.getSubstitutor()) : GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(element, (PsiJavaCodeReferenceElement)methodExpression, resolveResult.getSubstitutor());
                }
            } else {
                highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)methodCall, JavaErrorMessages.message("method.call.expected", new Object[0]));
                if (element instanceof PsiClass) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, new InsertNewFix(methodCall, (PsiClass)element));
                } else {
                    TextRange range = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, (IntentionAction)new CreateMethodFromUsageFix(methodCall), null);
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, (IntentionAction)new CreateAbstractMethodFromUsageFix(methodCall), null);
                    QuickFixAction.registerQuickFixAction(highlightInfo, range, (IntentionAction)new CreatePropertyFromUsageFix(methodCall), null);
                }
            }
        }
        if (highlightInfo == null) {
            highlightInfo = GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(element, (PsiJavaCodeReferenceElement)referenceToMethod, resolveResult.getSubstitutor());
        }
        return highlightInfo;
    }

    private static HighlightInfo checkAmbiguousMethodCall(PsiReferenceExpression referenceToMethod, PsiExpressionList list, PsiElement element, JavaResolveResult resolveResult, PsiMethodCallExpression methodCall, PsiResolveHelper resolveHelper) {
        PsiElement elementToHighlight;
        String toolTip;
        String description;
        JavaResolveResult[] resolveResults = referenceToMethod.multiResolve(true);
        MethodCandidateInfo methodCandidate1 = null;
        MethodCandidateInfo methodCandidate2 = null;
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isApplicable() || candidate.getElement().isConstructor()) continue;
            if (methodCandidate1 == null) {
                methodCandidate1 = candidate;
                continue;
            }
            methodCandidate2 = candidate;
            break;
        }
        MethodCandidateInfo[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        if (methodCandidate2 != null) {
            String m1 = PsiFormatUtil.formatMethod((PsiMethod)methodCandidate1.getElement(), (PsiSubstitutor)methodCandidate1.getSubstitutor(), (int)4353, (int)2);
            String m2 = PsiFormatUtil.formatMethod((PsiMethod)methodCandidate2.getElement(), (PsiSubstitutor)methodCandidate2.getSubstitutor(), (int)4353, (int)2);
            description = JavaErrorMessages.message("ambiguous.method.call", m1, m2);
            toolTip = HighlightMethodUtil.createAmbiguousMethodHtmlTooltip(new MethodCandidateInfo[]{methodCandidate1, methodCandidate2});
            elementToHighlight = list;
        } else {
            if (element != null && !resolveResult.isAccessible()) {
                description = HighlightUtil.buildProblemWithAccessDescription((PsiJavaCodeReferenceElement)referenceToMethod, resolveResult);
                elementToHighlight = referenceToMethod.getReferenceNameElement();
            } else if (element != null && !resolveResult.isStaticsScopeCorrect()) {
                description = HighlightUtil.buildProblemWithStaticDescription(element);
                elementToHighlight = referenceToMethod.getReferenceNameElement();
            } else {
                String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list);
                description = JavaErrorMessages.message("cannot.resolve.method", methodName);
                if (candidates.length == 0) {
                    elementToHighlight = referenceToMethod.getReferenceNameElement();
                    highlightInfoType = HighlightInfoType.WRONG_REF;
                } else {
                    elementToHighlight = list;
                }
            }
            toolTip = description;
        }
        HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(highlightInfoType, elementToHighlight, description, toolTip);
        if (methodCandidate2 == null) {
            HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list, resolveHelper);
        }
        if (!resolveResult.isAccessible() && resolveResult.isStaticsScopeCorrect() && methodCandidate2 != null) {
            HighlightUtil.registerAccessQuickFixAction((PsiMember)element, (PsiJavaCodeReferenceElement)referenceToMethod, highlightInfo, resolveResult.getCurrentFileResolveScope());
        }
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightUtil.registerStaticProblemQuickFixAction(element, highlightInfo, (PsiJavaCodeReferenceElement)referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, highlightInfo, fixRange);
        PermuteArgumentsFix.registerFix(highlightInfo, (PsiCall)methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])candidates, list.getExpressions(), highlightInfo);
        ChangeParameterClassFix.registerQuickFixActions(methodCall, list, highlightInfo);
        return highlightInfo;
    }

    private static MethodCandidateInfo[] toMethodCandidates(JavaResolveResult[] resolveResults) {
        ArrayList<MethodCandidateInfo> candidateList = new ArrayList<MethodCandidateInfo>();
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isAccessible()) continue;
            candidateList.add(candidate);
        }
        return candidateList.toArray(new MethodCandidateInfo[candidateList.size()]);
    }

    private static void registerMethodCallIntentions(HighlightInfo highlightInfo, PsiMethodCallExpression methodCall, PsiExpressionList list, PsiResolveHelper resolveHelper) {
        TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, (IntentionAction)new CreateMethodFromUsageFix(methodCall), null);
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, (IntentionAction)new CreateAbstractMethodFromUsageFix(methodCall), null);
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, (IntentionAction)new CreateConstructorFromSuperFix(methodCall), null);
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, (IntentionAction)new CreateConstructorFromThisFix(methodCall), null);
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, (IntentionAction)new CreatePropertyFromUsageFix(methodCall), null);
        CandidateInfo[] methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false);
        CastMethodArgumentFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        PermuteArgumentsFix.registerFix(highlightInfo, (PsiCall)methodCall, methodCandidates, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        HighlightMethodUtil.registerMethodAccessLevelIntentions(methodCandidates, methodCall, list, highlightInfo);
        ChangeMethodSignatureFromUsageFix.registerIntentions((JavaResolveResult[])methodCandidates, list, highlightInfo, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])methodCandidates, list.getExpressions(), highlightInfo);
        ChangeParameterClassFix.registerQuickFixActions(methodCall, list, highlightInfo);
        if (methodCandidates.length == 0) {
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, new StaticImportMethodFix(methodCall), null);
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, new ReplaceAddAllArrayToCollectionFix(methodCall), null);
        QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, (IntentionAction)new SurroundWithArrayFix((PsiCall)methodCall), null);
        CandidateInfo[] candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true);
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(candidates, methodCall, highlightInfo);
    }

    private static void registerMethodAccessLevelIntentions(CandidateInfo[] methodCandidates, PsiMethodCallExpression methodCall, PsiExpressionList exprList, HighlightInfo highlightInfo) {
        for (CandidateInfo methodCandidate : methodCandidates) {
            PsiMethod method = (PsiMethod)methodCandidate.getElement();
            if (methodCandidate.isAccessible() || !PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)methodCandidate.getSubstitutor(), (PsiExpressionList)exprList)) continue;
            HighlightUtil.registerAccessQuickFixAction((PsiMember)method, (PsiJavaCodeReferenceElement)methodCall.getMethodExpression(), highlightInfo, methodCandidate.getCurrentFileResolveScope());
        }
    }

    private static String createAmbiguousMethodHtmlTooltip(MethodCandidateInfo[] methodCandidates) {
        return JavaErrorMessages.message("ambiguous.method.html.tooltip", methodCandidates[0].getElement().getParameterList().getParametersCount() + 2, HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[0]), HighlightMethodUtil.getContainingClassName(methodCandidates[0]), HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[1]), HighlightMethodUtil.getContainingClassName(methodCandidates[1]));
    }

    private static String getContainingClassName(MethodCandidateInfo methodCandidate) {
        PsiMethod method = methodCandidate.getElement();
        PsiClass containingClass = method.getContainingClass();
        return containingClass == null ? method.getContainingFile().getName() : HighlightUtil.formatClass(containingClass, false);
    }

    @Language(value="HTML")
    private static String createAmbiguousMethodHtmlTooltipMethodRow(MethodCandidateInfo methodCandidate) {
        PsiMethod method = methodCandidate.getElement();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        String ms = "<td><b>" + method.getName() + "</b></td>";
        for (int j = 0; j < parameters.length; ++j) {
            PsiParameter parameter = parameters[j];
            PsiType type = substitutor.substitute(parameter.getType());
            ms = ms + "<td><b>" + (j == 0 ? "(" : "") + XmlStringUtil.escapeString((String)type.getPresentableText()) + (j == parameters.length - 1 ? ")" : ",") + "</b></td>";
        }
        if (parameters.length == 0) {
            ms = ms + "<td><b>()</b></td>";
        }
        return ms;
    }

    private static String createMismatchedArgumentsHtmlTooltip(MethodCandidateInfo info, PsiExpressionList list) {
        PsiMethod method = info.getElement();
        PsiSubstitutor substitutor = info.getSubstitutor();
        PsiClass aClass = method.getContainingClass();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        String methodName = method.getName();
        return HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list, parameters, methodName, substitutor, aClass);
    }

    private static String createShortMismatchedArgumentsHtmlTooltip(PsiExpressionList list, PsiParameter[] parameters, String methodName, PsiSubstitutor substitutor, PsiClass aClass) {
        PsiExpression[] expressions = list.getExpressions();
        int cols = Math.max(parameters.length, expressions.length);
        String parensizedName = methodName + (parameters.length == 0 ? "(&nbsp;)&nbsp;" : "");
        return JavaErrorMessages.message("argument.mismatch.html.tooltip", cols - parameters.length + 1, parensizedName, HighlightUtil.formatClass(aClass, false), HighlightMethodUtil.createMismatchedArgsHtmlTooltipParamsRow(parameters, substitutor, expressions), HighlightMethodUtil.createMismatchedArgsHtmlTooltipArgumentsRow(expressions, parameters, substitutor, cols));
    }

    private static String esctrim(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil.esctrim must not be null");
        }
        return XmlStringUtil.escapeString((String)StringUtil.first((String)s, (int)40, (boolean)true));
    }

    private static String createMismatchedArgumentsHtmlTooltip(PsiExpressionList list, PsiParameter[] parameters, String methodName, PsiSubstitutor substitutor, PsiClass aClass) {
        if (Math.max(parameters.length, list.getExpressions().length) <= 2) {
            return HighlightMethodUtil.createShortMismatchedArgumentsHtmlTooltip(list, parameters, methodName, substitutor, aClass);
        }
        return HighlightMethodUtil.createLongMismatchedArgumentsHtmlTooltip(list, parameters, methodName, substitutor, aClass);
    }

    @Language(value="HTML")
    private static String createLongMismatchedArgumentsHtmlTooltip(PsiExpressionList list, PsiParameter[] parameters, String methodName, PsiSubstitutor substitutor, PsiClass aClass) {
        PsiExpression[] expressions = list.getExpressions();
        String s = "<html><body><table border=0><tr><td colspan=3><nobr><b>" + methodName + "()</b> in <b>" + HighlightUtil.formatClass(aClass, false) + "</b> cannot be applied to:</nobr>" + "</td></tr>" + "<tr><td colspan=2 align=left>Expected<br>Parameters:</td><td align=left>Actual<br>Arguments:</td></tr>" + "<tr><td colspan=3><hr></td></tr>";
        for (int i = 0; i < Math.max(parameters.length, expressions.length); ++i) {
            PsiType type;
            String name;
            PsiParameter parameter = i < parameters.length ? parameters[i] : null;
            PsiExpression expression = i < expressions.length ? expressions[i] : null;
            String mismatchColor = HighlightMethodUtil.showShortType(i, parameters, expressions, substitutor) ? null : "red";
            s = s + "<tr" + (i % 2 == 0 ? " style='background-color: #eeeeee'" : "") + ">";
            s = s + "<td><b><nobr>";
            if (parameter != null && (name = parameter.getName()) != null) {
                s = s + HighlightMethodUtil.esctrim(name) + ":";
            }
            s = s + "</nobr></b></td>";
            s = s + "<td><b><nobr>";
            if (parameter != null) {
                type = substitutor.substitute(parameter.getType());
                s = s + "<font " + (mismatchColor == null ? "" : "color=" + mismatchColor) + ">" + HighlightMethodUtil.esctrim(HighlightMethodUtil.showShortType(i, parameters, expressions, substitutor) ? type.getPresentableText() : HighlightUtil.formatType(type)) + "</font>";
            }
            s = s + "</nobr></b></td>";
            s = s + "<td><b><nobr>";
            if (expression != null) {
                type = expression.getType();
                s = s + "<font " + (mismatchColor == null ? "" : "color=" + mismatchColor) + ">" + HighlightMethodUtil.esctrim(expression.getText()) + "&nbsp;&nbsp;" + (mismatchColor == null || type == null || type == PsiType.NULL ? "" : "(" + HighlightMethodUtil.esctrim(HighlightUtil.formatType(type)) + ")") + "</font>";
            }
            s = s + "</nobr></b></td>";
            s = s + "</tr>";
        }
        s = s + "</table></body></html>";
        return s;
    }

    @Language(value="HTML")
    private static String createMismatchedArgsHtmlTooltipArgumentsRow(PsiExpression[] expressions, PsiParameter[] parameters, PsiSubstitutor substitutor, int cols) {
        int i;
        String ms = "";
        for (i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            PsiType type = expression.getType();
            String mismatchColor = HighlightMethodUtil.showShortType(i, parameters, expressions, substitutor) ? null : "red";
            ms = ms + "<td> <b><nobr>" + (i == 0 ? "(" : "") + "<font " + (mismatchColor == null ? "" : "color=" + mismatchColor) + ">" + XmlStringUtil.escapeString((String)(HighlightMethodUtil.showShortType(i, parameters, expressions, substitutor) ? type.getPresentableText() : HighlightUtil.formatType(type))) + "</font>" + (i == expressions.length - 1 ? ")" : ",") + "</nobr></b></td>";
        }
        for (i = expressions.length; i < cols + 1; ++i) {
            ms = ms + "<td>" + (i == 0 ? "<b>()</b>" : "") + "&nbsp;</td>";
        }
        return ms;
    }

    @Language(value="HTML")
    private static String createMismatchedArgsHtmlTooltipParamsRow(PsiParameter[] parameters, PsiSubstitutor substitutor, PsiExpression[] expressions) {
        String ms = "";
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType type = substitutor.substitute(parameter.getType());
            ms = ms + "<td><b><nobr>" + (i == 0 ? "(" : "") + XmlStringUtil.escapeString((String)(HighlightMethodUtil.showShortType(i, parameters, expressions, substitutor) ? type.getPresentableText() : HighlightUtil.formatType(type))) + (i == parameters.length - 1 ? ")" : ",") + "</nobr></b></td>";
        }
        return ms;
    }

    private static boolean showShortType(int i, PsiParameter[] parameters, PsiExpression[] expressions, PsiSubstitutor substitutor) {
        PsiExpression expression;
        PsiExpression psiExpression = expression = i < expressions.length ? expressions[i] : null;
        if (expression == null) {
            return true;
        }
        PsiType paramType = i < parameters.length && parameters[i] != null ? substitutor.substitute(parameters[i].getType()) : null;
        return paramType != null && TypeConversionUtil.areTypesAssignmentCompatible(paramType, (PsiExpression)expression);
    }

    static HighlightInfo checkMethodMustHaveBody(PsiMethod method, PsiClass aClass) {
        HighlightInfo errorResult = null;
        if (!(method.getBody() != null || method.hasModifierProperty("abstract") || method.hasModifierProperty("native") || aClass == null || aClass.isInterface() || PsiUtil.hasErrorElementChild((PsiElement)method))) {
            int start = method.getModifierList().getTextRange().getStartOffset();
            int end = method.getTextRange().getEndOffset();
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, start, end, JavaErrorMessages.message("missing.method.body", new Object[0]));
            if (HighlightUtil.getIncompatibleModifier("abstract", method.getModifierList()) == null) {
                IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", true, false);
                QuickFixAction.registerQuickFixAction(errorResult, fix);
            }
            QuickFixAction.registerQuickFixAction(errorResult, new AddMethodBodyFix(method));
        }
        return errorResult;
    }

    static HighlightInfo checkAbstractMethodInConcreteClass(PsiMethod method, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        PsiClass aClass = method.getContainingClass();
        if (method.hasModifierProperty("abstract") && aClass != null && !aClass.hasModifierProperty("abstract") && !aClass.isEnum() && !PsiUtil.hasErrorElementChild((PsiElement)method)) {
            IntentionAction fix;
            errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, elementToHighlight, JavaErrorMessages.message("abstract.method.in.non.abstract.class", new Object[0]));
            if (method.getBody() != null) {
                fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", false, false);
                QuickFixAction.registerQuickFixAction(errorResult, fix);
            }
            QuickFixAction.registerQuickFixAction(errorResult, new AddMethodBodyFix(method));
            fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", true, false);
            QuickFixAction.registerQuickFixAction(errorResult, fix);
        }
        return errorResult;
    }

    static HighlightInfo checkConstructorName(PsiMethod method) {
        String methodName = method.getName();
        PsiClass aClass = method.getContainingClass();
        HighlightInfo errorResult = null;
        if (aClass != null) {
            String className;
            String string = className = aClass instanceof PsiAnonymousClass ? null : aClass.getName();
            if (!Comparing.strEqual((String)methodName, (String)className)) {
                errorResult = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)method.getNameIdentifier(), JavaErrorMessages.message("missing.return.type", new Object[0]));
            }
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkDuplicateMethod(PsiClass aClass, PsiMethod method) {
        PsiMethod other;
        PsiMethod[] methodsByName;
        if (aClass == null || method instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        int methodCount = 0;
        PsiMethod[] arr$ = methodsByName = aClass.findMethodsByName(method.getName(), false);
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || ((other = arr$[i$]) == method || other.isConstructor() == method.isConstructor() && other.getSignature(PsiSubstitutor.EMPTY).equals(methodSignature)) && ++methodCount > 1); ++i$) {
        }
        if (methodCount == 1 && aClass.isEnum() && GenericsHighlightUtil.isEnumSyntheticMethod(methodSignature, aClass.getProject())) {
            ++methodCount;
        }
        if (methodCount > 1) {
            String message = JavaErrorMessages.message("duplicate.method", HighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass));
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, message);
        }
        return null;
    }

    public static HighlightInfo checkMethodCanHaveBody(PsiMethod method) {
        if (method.getBody() == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        String message = null;
        if (aClass != null && aClass.isInterface()) {
            message = JavaErrorMessages.message("interface.methods.cannot.have.body", new Object[0]);
        } else if (method.hasModifierProperty("abstract")) {
            message = JavaErrorMessages.message("abstract.methods.cannot.have.a.body", new Object[0]);
        } else if (method.hasModifierProperty("native")) {
            message = JavaErrorMessages.message("native.methods.cannot.have.a.body", new Object[0]);
        }
        if (message != null) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, message);
            QuickFixAction.registerQuickFixAction(info, new DeleteMethodBodyFix(method));
            if (method.hasModifierProperty("abstract") && aClass != null && !aClass.isInterface()) {
                IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", false, false);
                QuickFixAction.registerQuickFixAction(info, fix);
            }
            return info;
        }
        return null;
    }

    static HighlightInfo checkConstructorCallMustBeFirstStatement(PsiReferenceExpression expression) {
        String text = expression.getText();
        PsiElement methodCall = expression.getParent();
        if (!HighlightUtil.isSuperOrThisMethodCall(methodCall)) {
            return null;
        }
        PsiElement codeBlock = methodCall.getParent().getParent();
        if (codeBlock instanceof PsiCodeBlock && codeBlock.getParent() instanceof PsiMethod && ((PsiMethod)codeBlock.getParent()).isConstructor()) {
            PsiElement prevSibling = methodCall.getParent().getPrevSibling();
            while (true) {
                if (prevSibling == null) {
                    return null;
                }
                if (prevSibling instanceof PsiStatement) break;
                prevSibling = prevSibling.getPrevSibling();
            }
        }
        String message = JavaErrorMessages.message("constructor.call.must.be.first.statement", text + "()");
        return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, expression.getParent(), message);
    }

    public static HighlightInfo checkAbstractMethodDirectCall(PsiSuperExpression expr) {
        PsiMethodCallExpression methodCallExpression;
        PsiMethod method;
        if (expr.getParent() instanceof PsiReferenceExpression && expr.getParent().getParent() instanceof PsiMethodCallExpression && (method = (methodCallExpression = (PsiMethodCallExpression)expr.getParent().getParent()).resolveMethod()) != null && method.hasModifierProperty("abstract")) {
            String message = JavaErrorMessages.message("direct.abstract.method.access", HighlightUtil.formatMethod(method));
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)methodCallExpression, message);
        }
        return null;
    }

    public static HighlightInfo checkConstructorCallsBaseClassConstructor(PsiMethod constructor, RefCountHolder refCountHolder, PsiResolveHelper resolveHelper) {
        PsiClassType[] handledExceptions;
        if (!constructor.isConstructor()) {
            return null;
        }
        PsiClass aClass = constructor.getContainingClass();
        if (aClass == null) {
            return null;
        }
        if (aClass.isEnum()) {
            return null;
        }
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return null;
        }
        PsiElement element = new PsiMatcherImpl((PsiElement)body).firstChild(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).getElement();
        if (element != null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(constructor);
        HighlightInfo info = HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, handledExceptions = constructor.getThrowsList().getReferencedTypes());
        if (info != null) {
            QuickFixAction.registerQuickFixAction(info, new InsertSuperFix(constructor));
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddDefaultConstructorFix(aClass.getSuperClass()));
        }
        return info;
    }

    public static HighlightInfo checkStaticMethodOverride(PsiMethod method) {
        PsiClass[] interfaces;
        if (method.isConstructor()) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiClass superClass = aClass.getSuperClass();
        PsiMethod superMethod = superClass == null ? null : MethodSignatureUtil.findMethodBySignature((PsiClass)superClass, (PsiMethod)method, (boolean)true);
        boolean isStatic = method.hasModifierProperty("static");
        HighlightInfo highlightInfo = HighlightMethodUtil.checkStaticMethodOverride(aClass, method, isStatic, superClass, superMethod);
        if (highlightInfo != null) {
            return highlightInfo;
        }
        if (!isStatic) {
            return null;
        }
        for (PsiClass aInterfaces : interfaces = aClass.getInterfaces()) {
            superClass = aInterfaces;
            superMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)superClass, (PsiMethod)method, (boolean)true);
            highlightInfo = HighlightMethodUtil.checkStaticMethodOverride(aClass, method, true, superClass, superMethod);
            if (highlightInfo == null) continue;
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkStaticMethodOverride(PsiClass aClass, PsiMethod method, boolean isMethodStatic, PsiClass superClass, PsiMethod superMethod) {
        if (superMethod == null) {
            return null;
        }
        PsiManager manager = superMethod.getManager();
        PsiModifierList superModifierList = superMethod.getModifierList();
        PsiModifierList modifierList = method.getModifierList();
        if (superModifierList.hasModifierProperty("private")) {
            return null;
        }
        if (superModifierList.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)manager.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)superClass)) {
            return null;
        }
        boolean isSuperMethodStatic = superModifierList.hasModifierProperty("static");
        if (isMethodStatic != isSuperMethodStatic) {
            IntentionAction fix;
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String messageKey = isMethodStatic ? "static.method.cannot.override.instance.method" : "instance.method.cannot.override.static.method";
            String message = JavaErrorMessages.message(messageKey, HighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass), HighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superClass));
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, message);
            if (!isSuperMethodStatic || HighlightUtil.getIncompatibleModifier("static", modifierList) == null) {
                fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", isSuperMethodStatic, false);
                QuickFixAction.registerQuickFixAction(info, fix);
            }
            if (manager.isInProject((PsiElement)superMethod) && (!isMethodStatic || HighlightUtil.getIncompatibleModifier("static", superModifierList) == null)) {
                fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)superMethod, "static", isMethodStatic, true);
                QuickFixAction.registerQuickFixAction(info, fix);
            }
            return info;
        }
        if (isMethodStatic && isSuperMethodStatic) {
            int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
            String accessModifier = PsiUtil.getAccessModifier((int)accessLevel);
            HighlightInfo info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, true);
            if (info != null) {
                return info;
            }
            info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    private static HighlightInfo checkInterfaceInheritedMethodsReturnTypes(List<? extends MethodSignatureBackedByPsiMethod> superMethodSignatures) {
        if (superMethodSignatures.size() < 2) {
            return null;
        }
        MethodSignatureBackedByPsiMethod returnTypeSubstitutable = superMethodSignatures.get(0);
        for (int i = 1; i < superMethodSignatures.size(); ++i) {
            PsiMethod currentMethod = returnTypeSubstitutable.getMethod();
            PsiType currentType = returnTypeSubstitutable.getSubstitutor().substitute(currentMethod.getReturnType());
            MethodSignatureBackedByPsiMethod otherSuperSignature = superMethodSignatures.get(i);
            PsiMethod otherSuperMethod = otherSuperSignature.getMethod();
            PsiType otherSuperReturnType = otherSuperSignature.getSubstitutor().substitute(otherSuperMethod.getReturnType());
            PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)returnTypeSubstitutable, (MethodSignature)otherSuperSignature);
            if (unifyingSubstitutor != null) {
                otherSuperReturnType = unifyingSubstitutor.substitute(otherSuperReturnType);
                currentType = unifyingSubstitutor.substitute(currentType);
            }
            if (otherSuperReturnType == null || currentType == null || otherSuperReturnType.equals(currentType)) continue;
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)currentMethod)) {
                if (otherSuperReturnType.isAssignableFrom(currentType)) continue;
                if (currentType.isAssignableFrom(otherSuperReturnType)) {
                    returnTypeSubstitutable = otherSuperSignature;
                    continue;
                }
            }
            return HighlightMethodUtil.createIncompatibleReturnTypeMessage(currentMethod, currentMethod, otherSuperMethod, false, otherSuperReturnType, currentType, JavaErrorMessages.message("unrelated.overriding.methods.return.types", new Object[0]));
        }
        return null;
    }

    public static HighlightInfo checkOverrideEquivalentInheritedMethods(PsiClass aClass) {
        String errorDescription = null;
        Collection visibleSignatures = aClass.getVisibleSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        block0: for (HierarchicalMethodSignature signature : visibleSignatures) {
            PsiMethod method = signature.getMethod();
            if (!resolveHelper.isAccessible((PsiMember)method, (PsiElement)aClass, null)) continue;
            ArrayList<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            boolean allAbstracts = method.hasModifierProperty("abstract");
            PsiClass containingClass = method.getContainingClass();
            if (aClass.equals(containingClass) || aClass.isInterface() && !containingClass.isInterface()) continue;
            HighlightInfo highlightInfo = null;
            if (allAbstracts) {
                if (!containingClass.equals(aClass)) {
                    superSignatures = new ArrayList<HierarchicalMethodSignature>(superSignatures);
                    superSignatures.add(signature);
                }
                highlightInfo = HighlightMethodUtil.checkInterfaceInheritedMethodsReturnTypes((List<? extends MethodSignatureBackedByPsiMethod>)superSignatures);
            } else if (!aClass.equals(containingClass)) {
                highlightInfo = HighlightMethodUtil.checkMethodIncompatibleReturnType((MethodSignatureBackedByPsiMethod)signature, (List<HierarchicalMethodSignature>)superSignatures, false);
            }
            if (highlightInfo != null) {
                errorDescription = highlightInfo.description;
            }
            if (method.hasModifierProperty("static")) {
                for (HierarchicalMethodSignature superSignature : superSignatures) {
                    PsiMethod superMethod = superSignature.getMethod();
                    if (superMethod.hasModifierProperty("static")) continue;
                    errorDescription = JavaErrorMessages.message("static.method.cannot.override.instance.method", HighlightUtil.formatMethod(method), HighlightUtil.formatClass(containingClass), HighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superMethod.getContainingClass()));
                    break block0;
                }
                continue;
            }
            if (errorDescription == null && (highlightInfo = HighlightMethodUtil.checkMethodIncompatibleThrows((MethodSignatureBackedByPsiMethod)signature, superSignatures, false, aClass)) != null) {
                errorDescription = highlightInfo.description;
            }
            if (errorDescription == null && (highlightInfo = HighlightMethodUtil.checkMethodWeakerPrivileges((MethodSignatureBackedByPsiMethod)signature, superSignatures, false)) != null) {
                errorDescription = highlightInfo.description;
            }
            if (errorDescription == null) continue;
            break;
        }
        if (errorDescription != null) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, errorDescription);
        }
        return null;
    }

    public static HighlightInfo checkConstructorHandleSuperClassExceptions(PsiMethod method) {
        PsiStatement[] statements;
        if (!method.isConstructor()) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        PsiStatement[] psiStatementArray = statements = body == null ? null : body.getStatements();
        if (statements == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)method, (PsiElement)method.getContainingClass());
        if (unhandled.isEmpty()) {
            return null;
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled);
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, description);
        for (PsiClassType exception : unhandled) {
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, true, false));
        }
        return highlightInfo;
    }

    public static HighlightInfo checkRecursiveConstructorInvocation(PsiMethod method) {
        if (HighlightControlFlowUtil.isRecursivelyCalledConstructor(method)) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, textRange, JavaErrorMessages.message("recursive.constructor.invocation", new Object[0]));
        }
        return null;
    }

    public static TextRange getFixRange(PsiElement element) {
        TextRange range = element.getTextRange();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        PsiElement nextSibling = element.getNextSibling();
        if (nextSibling instanceof PsiJavaToken && ((PsiJavaToken)nextSibling).getTokenType() == JavaTokenType.SEMICOLON) {
            return new TextRange(start, end + 1);
        }
        return range;
    }

    static void checkNewExpression(@NotNull PsiNewExpression expression, @NotNull HighlightInfoHolder holder) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil.checkNewExpression must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil.checkNewExpression must not be null");
        }
        PsiType type = expression.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
        PsiClass aClass = typeResult.getElement();
        if (aClass == null) {
            return;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = (typeResult = ((PsiClassType)(type = ((PsiAnonymousClass)aClass).getBaseClassType())).resolveGenerics()).getElement()) == null) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        HighlightMethodUtil.checkConstructorCall(typeResult, (PsiConstructorCall)expression, type, classReference, holder);
    }

    public static void checkConstructorCall(PsiClassType.ClassResolveResult typeResolveResult, PsiConstructorCall constructorCall, PsiType type, PsiJavaCodeReferenceElement classReference, HighlightInfoHolder holder) {
        PsiExpression qualifier;
        PsiExpressionList list = constructorCall.getArgumentList();
        if (list == null) {
            return;
        }
        PsiClass aClass = typeResolveResult.getElement();
        if (aClass == null) {
            return;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)constructorCall.getProject()).getResolveHelper();
        PsiClass accessObjectClass = null;
        if (constructorCall instanceof PsiNewExpression && (qualifier = ((PsiNewExpression)constructorCall).getQualifier()) != null) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
        }
        if (classReference != null && !resolveHelper.isAccessible((PsiMember)aClass, (PsiElement)constructorCall, accessObjectClass)) {
            String description = HighlightUtil.buildProblemWithAccessDescription(classReference, (JavaResolveResult)typeResolveResult);
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, classReference.getReferenceNameElement(), description);
            HighlightUtil.registerAccessQuickFixAction((PsiMember)aClass, classReference, info, null);
            holder.add(info);
            return;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            if (list.getExpressions().length != 0) {
                String constructorName = aClass.getName();
                String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorMessages.message("wrong.constructor.arguments", constructorName + "()", argTypes);
                String tooltip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list, PsiParameter.EMPTY_ARRAY, constructorName, PsiSubstitutor.EMPTY, aClass);
                HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)list, description, tooltip);
                QuickFixAction.registerQuickFixAction(info, constructorCall.getTextRange(), (IntentionAction)new CreateConstructorFromCallFix(constructorCall), null);
                if (classReference != null) {
                    ConstructorParametersFixer.registerFixActions(classReference, constructorCall, info, HighlightMethodUtil.getFixRange((PsiElement)list));
                }
                info.navigationShift = 1;
                holder.add(info);
                return;
            }
            if (classReference != null && aClass.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass)) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference, (JavaResolveResult)typeResolveResult, (PsiMember)aClass));
            }
        } else {
            PsiAnonymousClass anonymousClass;
            PsiExpressionList place = list;
            if (constructorCall instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)constructorCall).getAnonymousClass()) != null) {
                place = anonymousClass;
            }
            JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type, list, (PsiElement)place);
            MethodCandidateInfo result = null;
            if (results.length == 1) {
                result = (MethodCandidateInfo)results[0];
            }
            PsiMethod constructor = result == null ? null : result.getElement();
            boolean applicable = true;
            try {
                applicable = constructor != null && result.isApplicable();
            }
            catch (IndexNotReadyException e) {
                // empty catch block
            }
            if (constructor == null) {
                String name = aClass.getName();
                name = name + HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorMessages.message("cannot.resolve.constructor", name);
                HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)list, description);
                QuickFixAction.registerQuickFixAction(info, constructorCall.getTextRange(), (IntentionAction)new CreateConstructorFromCallFix(constructorCall), null);
                if (classReference != null) {
                    ConstructorParametersFixer.registerFixActions(classReference, constructorCall, info, HighlightMethodUtil.getFixRange((PsiElement)list));
                    PermuteArgumentsFix.registerFix(info, (PsiCall)constructorCall, (CandidateInfo[])HighlightMethodUtil.toMethodCandidates(results), HighlightMethodUtil.getFixRange((PsiElement)list));
                }
                WrapExpressionFix.registerWrapAction(results, list.getExpressions(), info);
                info.navigationShift = 1;
                holder.add(info);
                ChangeStringLiteralToCharInMethodCallFix.registerFixes(constructors, constructorCall, info);
            } else if (classReference != null && (!result.isAccessible() || constructor.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass))) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference, (JavaResolveResult)result, (PsiMember)constructor));
            } else if (!applicable) {
                String constructorName = HighlightMessageUtil.getSymbolName((PsiElement)constructor, result.getSubstitutor());
                String containerName = HighlightMessageUtil.getSymbolName((PsiElement)constructor.getContainingClass(), result.getSubstitutor());
                String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorMessages.message("wrong.method.arguments", constructorName, containerName, argTypes);
                String toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(result, list);
                PsiExpressionList infoElement = list.getTextLength() > 0 ? list : constructorCall;
                HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)infoElement, description, toolTip);
                QuickFixAction.registerQuickFixAction(info, constructorCall.getTextRange(), (IntentionAction)new CreateConstructorFromCallFix(constructorCall), null);
                if (classReference != null) {
                    ConstructorParametersFixer.registerFixActions(classReference, constructorCall, info, HighlightMethodUtil.getFixRange((PsiElement)infoElement));
                    ChangeMethodSignatureFromUsageFix.registerIntentions(results, list, info, null);
                    PermuteArgumentsFix.registerFix(info, (PsiCall)constructorCall, (CandidateInfo[])HighlightMethodUtil.toMethodCandidates(results), HighlightMethodUtil.getFixRange((PsiElement)list));
                    QuickFixAction.registerQuickFixAction(info, HighlightMethodUtil.getFixRange((PsiElement)list), (IntentionAction)new SurroundWithArrayFix((PsiCall)constructorCall), null);
                }
                info.navigationShift = 1;
                holder.add(info);
                ChangeStringLiteralToCharInMethodCallFix.registerFixes(constructors, constructorCall, info);
            } else {
                HighlightInfo highlightInfo = GenericsHighlightUtil.checkUncheckedCall((JavaResolveResult)result, (PsiCall)constructorCall);
                if (highlightInfo != null) {
                    holder.add(highlightInfo);
                    return;
                }
                if (constructorCall instanceof PsiNewExpression) {
                    highlightInfo = GenericsHighlightUtil.checkReferenceTypeArgumentList((PsiTypeParameterListOwner)constructor, ((PsiNewExpression)constructorCall).getTypeArgumentList(), result.getSubstitutor(), false);
                    if (highlightInfo != null) {
                        holder.add(highlightInfo);
                        return;
                    }
                    highlightInfo = GenericsHighlightUtil.checkGenericCallWithRawArguments((JavaResolveResult)result, (PsiCallExpression)constructorCall);
                }
                if (highlightInfo != null) {
                    holder.add(highlightInfo);
                }
            }
        }
    }

    private static HighlightInfo buildAccessProblem(@NotNull PsiJavaCodeReferenceElement classReference, JavaResolveResult result, PsiMember elementToFix) {
        if (classReference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil.buildAccessProblem must not be null");
        }
        String description = HighlightUtil.buildProblemWithAccessDescription(classReference, result);
        HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)classReference, description);
        info.navigationShift = 1;
        if (result.isStaticsScopeCorrect()) {
            HighlightUtil.registerAccessQuickFixAction(elementToFix, classReference, info, result.getCurrentFileResolveScope());
        }
        return info;
    }

    private static boolean callingProtectedConstructorFromDerivedClass(PsiConstructorCall place, PsiClass constructorClass) {
        PsiClass aClass;
        if (constructorClass == null) {
            return false;
        }
        if (place instanceof PsiNewExpression && ((PsiNewExpression)place).getAnonymousClass() != null) {
            return false;
        }
        PsiConstructorCall curElement = place;
        PsiClass containingClass = constructorClass.getContainingClass();
        do {
            if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)curElement, PsiClass.class)) == null) {
                return false;
            }
            curElement = aClass;
        } while (!aClass.isInheritor(constructorClass, true) && (containingClass == null || !aClass.isInheritor(containingClass, true)) || JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)constructorClass));
        return true;
    }

    public static boolean isSerializationRelatedMethod(PsiMethod method, PsiClass containingClass) {
        if (containingClass == null || method.isConstructor()) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        String name = method.getName();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiType returnType = method.getReturnType();
        if ("readObjectNoData".equals(name)) {
            return parameters.length == 0 && TypeConversionUtil.isVoidType((PsiType)returnType) && HighlightUtil.isSerializable(containingClass);
        }
        if ("readObject".equals(name)) {
            return parameters.length == 1 && parameters[0].getType().equalsToText("java.io.ObjectInputStream") && TypeConversionUtil.isVoidType((PsiType)returnType) && method.hasModifierProperty("private") && HighlightUtil.isSerializable(containingClass);
        }
        if ("readResolve".equals(name)) {
            return parameters.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && HighlightUtil.isSerializable(containingClass);
        }
        if ("writeReplace".equals(name)) {
            return parameters.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && HighlightUtil.isSerializable(containingClass);
        }
        if ("writeObject".equals(name)) {
            return parameters.length == 1 && TypeConversionUtil.isVoidType((PsiType)returnType) && parameters[0].getType().equalsToText("java.io.ObjectOutputStream") && method.hasModifierProperty("private") && HighlightUtil.isSerializable(containingClass);
        }
        return false;
    }

    private static String buildArgTypesList(PsiExpressionList list) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        PsiExpression[] args = list.getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = args[i].getType()) != null ? HighlightUtil.formatType(argType) : "?");
        }
        builder.append(")");
        return builder.toString();
    }
}

