/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddTypeCastFix
implements IntentionAction {
    private final PsiType myType;
    private final PsiExpression myExpression;

    public AddTypeCastFix(PsiType type, PsiExpression expression) {
        this.myType = type;
        this.myExpression = expression;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.typecast.text", this.myType.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.typecast.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix.isAvailable must not be null");
        }
        return this.myType.isValid() && this.myExpression.isValid() && this.myExpression.getManager().isInProject((PsiElement)this.myExpression);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        AddTypeCastFix.addTypeCast(project, this.myExpression, this.myType);
    }

    private static void addTypeCast(Project project, PsiExpression originalExpression, PsiType type) throws IncorrectOperationException {
        PsiExpression typeCast = AddTypeCastFix.createCastExpression(originalExpression, project, type);
        originalExpression.replace((PsiElement)typeCast);
    }

    static PsiExpression createCastExpression(PsiExpression originalExpression, Project project, PsiType type) throws IncorrectOperationException {
        PsiExpression element = PsiUtil.deparenthesizeExpression((PsiExpression)originalExpression);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)originalExpression.getProject()).getElementFactory();
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)factory.createExpressionFromText("(Type)value", null);
        typeCast = (PsiTypeCastExpression)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)typeCast);
        typeCast.getCastType().replace((PsiElement)factory.createTypeElement(type));
        if (element instanceof PsiConditionalExpression) {
            PsiType elseType;
            PsiConditionalExpression expression = (PsiConditionalExpression)element.copy();
            PsiExpression thenE = expression.getThenExpression();
            PsiExpression elseE = expression.getElseExpression();
            PsiType thenType = thenE == null ? null : thenE.getType();
            PsiType psiType = elseType = elseE == null ? null : elseE.getType();
            if (elseType != null && thenType != null) {
                boolean replaceElse;
                boolean replaceThen = !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)thenType);
                boolean bl = replaceElse = !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)elseType);
                if (replaceThen != replaceElse) {
                    if (replaceThen) {
                        typeCast.getOperand().replace((PsiElement)thenE);
                        thenE.replace((PsiElement)typeCast);
                    } else {
                        typeCast.getOperand().replace((PsiElement)elseE);
                        elseE.replace((PsiElement)typeCast);
                    }
                    return expression;
                }
            }
        }
        typeCast.getOperand().replace((PsiElement)element);
        return typeCast;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

