/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JavaDocUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.javadoc.JavaDocUtil");
    @NonNls
    private static final Pattern ourTypePattern = Pattern.compile("[ ]+[^ ^\\[^\\]]");
    @NonNls
    private static final Pattern ourLtFixupPattern = Pattern.compile("<([^/^\\w^!])");
    @NonNls
    private static final Pattern ourToQuote = Pattern.compile("[\\\\\\.\\^\\$\\?\\*\\+\\|\\)\\}\\]\\{\\(\\[]");
    @NonNls
    private static final String LT_ENTITY = "&lt;";

    private JavaDocUtil() {
    }

    public static String[] getDocPaths(Project project) {
        VirtualFile[] roots;
        ArrayList<String> result = new ArrayList<String>();
        for (VirtualFile root : roots = ProjectRootManagerEx.getInstanceEx(project).getFilesFromAllModules(JavadocOrderRootType.getInstance())) {
            if (root.getFileSystem() instanceof HttpFileSystem) continue;
            result.add(root.getUrl());
        }
        return ArrayUtil.toStringArray(result);
    }

    public static int extractReference(String text) {
        int lparenthIndex = text.indexOf(40);
        int spaceIndex = text.indexOf(32);
        if (spaceIndex < 0) {
            spaceIndex = text.length();
        }
        if (lparenthIndex < 0) {
            return spaceIndex;
        }
        if (spaceIndex < lparenthIndex) {
            return spaceIndex;
        }
        int rparenthIndex = text.indexOf(41, lparenthIndex);
        if (rparenthIndex < 0) {
            rparenthIndex = text.length() - 1;
        }
        return rparenthIndex + 1;
    }

    @Nullable
    public static PsiElement findReferenceTarget(PsiManager manager, String refText, PsiElement context) {
        LOG.assertTrue(context == null || context.isValid());
        int poundIndex = refText.indexOf(35);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        if (poundIndex < 0) {
            PsiClass aClass = facade.getResolveHelper().resolveReferencedClass(refText, context);
            if (aClass == null) {
                aClass = facade.findClass(refText, context.getResolveScope());
            }
            if (aClass != null) {
                return aClass.getNavigationElement();
            }
            PsiPackage aPackage = facade.findPackage(refText);
            if (aPackage != null) {
                return aPackage;
            }
            return null;
        }
        String classRef = refText.substring(0, poundIndex).trim();
        if (classRef.length() > 0) {
            PsiClass aClass = facade.getResolveHelper().resolveReferencedClass(classRef, context);
            if (aClass == null) {
                aClass = facade.findClass(classRef, context.getResolveScope());
            }
            if (aClass == null) {
                return null;
            }
            return JavaDocUtil.findReferencedMember(aClass, refText.substring(poundIndex + 1), context);
        }
        String memberRefText = refText.substring(1);
        PsiElement scope = context;
        while (!(scope instanceof PsiFile)) {
            PsiElement member;
            if (scope instanceof PsiClass && (member = JavaDocUtil.findReferencedMember((PsiClass)scope, memberRefText, context)) != null) {
                return member;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Nullable
    private static PsiElement findReferencedMember(PsiClass aClass, String memberRefText, PsiElement context) {
        PsiMethod[] methods;
        int parenthIndex = memberRefText.indexOf(40);
        if (parenthIndex < 0) {
            PsiMethod[] methods2;
            String name = memberRefText;
            PsiField field = aClass.findFieldByName(name, true);
            if (field != null) {
                return field.getNavigationElement();
            }
            PsiClass inner = aClass.findInnerClassByName(name, true);
            if (inner != null) {
                return inner.getNavigationElement();
            }
            for (PsiMethod method : methods2 = aClass.getAllMethods()) {
                if (!method.getName().equals(name)) continue;
                return method.getNavigationElement();
            }
            return null;
        }
        String name = memberRefText.substring(0, parenthIndex).trim();
        int rparenIndex = memberRefText.lastIndexOf(41);
        if (rparenIndex == -1) {
            return null;
        }
        String parmsText = memberRefText.substring(parenthIndex + 1, rparenIndex).trim();
        StringTokenizer tokenizer = new StringTokenizer(parmsText.replaceAll("[*]", ""), ",");
        PsiType[] types = new PsiType[tokenizer.countTokens()];
        int i = 0;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        while (tokenizer.hasMoreTokens()) {
            String parmText = tokenizer.nextToken().trim();
            try {
                Matcher typeMatcher = ourTypePattern.matcher(parmText);
                String typeText = parmText;
                if (typeMatcher.find()) {
                    typeText = parmText.substring(0, typeMatcher.start());
                }
                PsiType type = factory.createTypeFromText(typeText, context);
                types[i++] = type;
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
            }
        }
        block4: for (PsiMethod method : methods = aClass.findMethodsByName(name, true)) {
            int parameterNumber;
            PsiParameter[] parms = method.getParameterList().getParameters();
            if (parms.length != types.length) continue;
            for (int k = 0; k < parms.length; ++k) {
                PsiParameter parm = parms[k];
                if (types[k] != null && !TypeConversionUtil.erasure((PsiType)parm.getType()).getCanonicalText().equals(types[k].getCanonicalText()) && !parm.getType().getCanonicalText().equals(types[k].getCanonicalText())) continue block4;
            }
            int hashIndex = memberRefText.indexOf(35, rparenIndex);
            if (hashIndex != -1 && (parameterNumber = Integer.parseInt(memberRefText.substring(hashIndex + 1))) < parms.length) {
                return method.getParameterList().getParameters()[parameterNumber].getNavigationElement();
            }
            return method.getNavigationElement();
        }
        return null;
    }

    @Nullable
    public static String getReferenceText(Project project, PsiElement element) {
        PsiMethod method;
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        if (element instanceof PsiClass) {
            String refText = ((PsiClass)element).getQualifiedName();
            if (refText != null) {
                return refText;
            }
            return ((PsiClass)element).getName();
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            String name = field.getName();
            PsiClass aClass = field.getContainingClass();
            if (aClass != null) {
                return JavaDocUtil.getReferenceText(project, (PsiElement)aClass) + "#" + name;
            }
            return "#" + name;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)element;
            String name = method2.getName();
            StringBuffer buffer = new StringBuffer();
            PsiClass aClass = method2.getContainingClass();
            if (aClass != null) {
                buffer.append(JavaDocUtil.getReferenceText(project, (PsiElement)aClass));
            }
            buffer.append("#");
            buffer.append(name);
            buffer.append("(");
            PsiParameter[] parms = method2.getParameterList().getParameters();
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)project);
            boolean spaceBeforeComma = styleSettings.SPACE_BEFORE_COMMA;
            boolean spaceAfterComma = styleSettings.SPACE_AFTER_COMMA;
            for (int i = 0; i < parms.length; ++i) {
                PsiParameter parm = parms[i];
                String typeText = TypeConversionUtil.erasure((PsiType)parm.getType()).getCanonicalText();
                buffer.append(typeText);
                if (i >= parms.length - 1) continue;
                if (spaceBeforeComma) {
                    buffer.append(" ");
                }
                buffer.append(",");
                if (!spaceAfterComma) continue;
                buffer.append(" ");
            }
            buffer.append(")");
            return buffer.toString();
        }
        if (element instanceof PsiParameter && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null) {
            return JavaDocUtil.getReferenceText(project, (PsiElement)method) + "#" + ((PsiParameterList)element.getParent()).getParameterIndex((PsiParameter)element);
        }
        return null;
    }

    public static String getShortestClassName(PsiClass aClass, PsiElement context) {
        String shortName = aClass.getName();
        if (shortName == null) {
            shortName = "null";
        }
        for (PsiClass containingClass = aClass.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            shortName = containingClass.getName() + "." + shortName;
        }
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return shortName;
        }
        PsiManager manager = aClass.getManager();
        return manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getResolveHelper().resolveReferencedClass(shortName, context)) ? shortName : qName;
    }

    public static String getLabelText(Project project, PsiManager manager, String refText, PsiElement context) {
        PsiElement refElement = JavaDocUtil.findReferenceTarget(manager, refText, context);
        if (refElement == null) {
            return refText.replaceFirst("^#", "").replaceAll("#", ".");
        }
        int poundIndex = refText.indexOf(35);
        if (poundIndex < 0) {
            if (refElement instanceof PsiClass) {
                return JavaDocUtil.getShortestClassName((PsiClass)refElement, context);
            }
            return refText;
        }
        PsiClass aClass = null;
        if (refElement instanceof PsiField) {
            aClass = ((PsiField)refElement).getContainingClass();
        } else if (refElement instanceof PsiMethod) {
            aClass = ((PsiMethod)refElement).getContainingClass();
        } else if (refElement instanceof PsiClass) {
            return refText.replaceAll("#", ".");
        }
        if (aClass == null) {
            return refText;
        }
        String classRef = refText.substring(0, poundIndex).trim();
        String memberText = refText.substring(poundIndex + 1);
        String memberLabel = JavaDocUtil.getMemberLabelText(project, manager, memberText, context);
        if (classRef.length() > 0) {
            PsiElement refClass = JavaDocUtil.findReferenceTarget(manager, classRef, context);
            if (refClass instanceof PsiClass) {
                for (PsiElement scope = context; scope != null && !(scope instanceof PsiFile); scope = scope.getParent()) {
                    if (!scope.equals(refClass)) continue;
                    return memberLabel;
                }
            }
            return JavaDocUtil.getLabelText(project, manager, classRef, context) + "." + memberLabel;
        }
        return memberLabel;
    }

    private static String getMemberLabelText(Project project, PsiManager manager, String memberText, PsiElement context) {
        int parenthIndex = memberText.indexOf(40);
        if (parenthIndex < 0) {
            return memberText;
        }
        if (!StringUtil.endsWithChar((CharSequence)memberText, (char)')')) {
            return memberText;
        }
        String parms = memberText.substring(parenthIndex + 1, memberText.length() - 1);
        StringBuffer buffer = new StringBuffer();
        CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)project);
        boolean spaceBeforeComma = styleSettings.SPACE_BEFORE_COMMA;
        boolean spaceAfterComma = styleSettings.SPACE_AFTER_COMMA;
        StringTokenizer tokenizer = new StringTokenizer(parms, ",");
        while (tokenizer.hasMoreTokens()) {
            int index2;
            String param = tokenizer.nextToken().trim();
            int index1 = param.indexOf(91);
            if (index1 < 0) {
                index1 = param.length();
            }
            if ((index2 = param.indexOf(32)) < 0) {
                index2 = param.length();
            }
            int index = Math.min(index1, index2);
            String className = param.substring(0, index).trim();
            String shortClassName = JavaDocUtil.getLabelText(project, manager, className, context);
            buffer.append(shortClassName);
            buffer.append(param.substring(className.length()));
            if (!tokenizer.hasMoreElements()) continue;
            if (spaceBeforeComma) {
                buffer.append(" ");
            }
            buffer.append(",");
            if (!spaceAfterComma) continue;
            buffer.append(" ");
        }
        return memberText.substring(0, parenthIndex + 1) + buffer.toString() + ")";
    }

    private static String quote(String x) {
        if (ourToQuote.matcher(x).find()) {
            return "\\" + x;
        }
        return x;
    }

    public static String fixupText(String docText) {
        Matcher fixupMatcher = ourLtFixupPattern.matcher(docText);
        LinkedList<String> secondSymbols = new LinkedList<String>();
        while (fixupMatcher.find()) {
            String s = fixupMatcher.group(1);
            if (s.equals("\\")) continue;
            secondSymbols.addFirst(s);
        }
        for (String s : secondSymbols) {
            String pattern = "<" + JavaDocUtil.quote(s);
            try {
                docText = Pattern.compile(pattern).matcher(docText).replaceAll(LT_ENTITY + pattern);
            }
            catch (PatternSyntaxException e) {
                LOG.error("Pattern syntax exception on " + pattern);
            }
        }
        return docText;
    }

    public static PsiClassType[] getImplementsList(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return new PsiClassType[]{((PsiAnonymousClass)aClass).getBaseClassType()};
        }
        PsiReferenceList list = aClass.getImplementsList();
        return list == null ? PsiClassType.EMPTY_ARRAY : list.getReferencedTypes();
    }

    public static PsiClassType[] getExtendsList(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return new PsiClassType[]{((PsiAnonymousClass)aClass).getBaseClassType()};
        }
        PsiReferenceList list = aClass.getExtendsList();
        return list == null ? PsiClassType.EMPTY_ARRAY : list.getReferencedTypes();
    }
}

