/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.zencoding;

import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateInvokationListener;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.zencoding.TemplateToken;
import com.intellij.codeInsight.template.zencoding.XmlTemplateToken;
import com.intellij.codeInsight.template.zencoding.XmlZenCodingFilterImpl;
import com.intellij.codeInsight.template.zencoding.XmlZenCodingInterpreter;
import com.intellij.codeInsight.template.zencoding.ZenCodingFilter;
import com.intellij.codeInsight.template.zencoding.ZenCodingTemplate;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.util.XML11Char;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlZenCodingTemplate
extends ZenCodingTemplate {
    private static final String SELECTORS = ".#[";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String DEFAULT_TAG = "div";

    private static String getPrefix(@NotNull String templateKey) {
        if (templateKey == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingTemplate.getPrefix must not be null");
        }
        int n = templateKey.length();
        for (int i = 0; i < n; ++i) {
            char c = templateKey.charAt(i);
            if (SELECTORS.indexOf(c) < 0) continue;
            return templateKey.substring(0, i);
        }
        return templateKey;
    }

    @Nullable
    private static Pair<String, String> parseAttrNameAndValue(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingTemplate.parseAttrNameAndValue must not be null");
        }
        int eqIndex = text.indexOf(61);
        if (eqIndex > 0) {
            return new Pair((Object)text.substring(0, eqIndex), (Object)text.substring(eqIndex + 1));
        }
        return null;
    }

    @Nullable
    private static XmlTemplateToken parseSelectors(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingTemplate.parseSelectors must not be null");
        }
        String templateKey = null;
        ArrayList<Pair<String, String>> attributes = new ArrayList<Pair<String, String>>();
        HashSet definedAttrs = new HashSet();
        ArrayList<String> classes = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int lastDelim = 0;
        text = text + '$';
        int classAttrPosition = -1;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c;
            block18: {
                block20: {
                    block19: {
                        c = text.charAt(i);
                        if (c != '#' && c != '.' && c != '[' && c != ']' && i != n - 1) break block18;
                        if (c == ']') break block19;
                        switch (lastDelim) {
                            case 0: {
                                templateKey = builder.toString();
                                break block20;
                            }
                            case 35: {
                                if (!definedAttrs.add(ID)) {
                                    return null;
                                }
                                attributes.add((Pair<String, String>)new Pair((Object)ID, (Object)builder.toString()));
                                break block20;
                            }
                            case 46: {
                                if (builder.length() <= 0) {
                                    return null;
                                }
                                if (classAttrPosition < 0) {
                                    classAttrPosition = attributes.size();
                                }
                                classes.add(builder.toString());
                                break block20;
                            }
                            case 93: {
                                if (builder.length() > 0) {
                                    return null;
                                }
                                break block20;
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    if (lastDelim != 91) {
                        return null;
                    }
                    Pair<String, String> pair = XmlZenCodingTemplate.parseAttrNameAndValue(builder.toString());
                    if (pair == null || !definedAttrs.add(pair.first)) {
                        return null;
                    }
                    attributes.add(pair);
                }
                lastDelim = c;
                builder = new StringBuilder();
                continue;
            }
            builder.append(c);
        }
        if (classes.size() > 0) {
            if (definedAttrs.contains(CLASS)) {
                return null;
            }
            StringBuilder classesAttrValue = new StringBuilder();
            for (int i = 0; i < classes.size(); ++i) {
                classesAttrValue.append((String)classes.get(i));
                if (i >= classes.size() - 1) continue;
                classesAttrValue.append(' ');
            }
            assert (classAttrPosition >= 0);
            attributes.add(classAttrPosition, (Pair<String, String>)new Pair((Object)CLASS, (Object)classesAttrValue.toString()));
        }
        return new XmlTemplateToken(templateKey, attributes);
    }

    private static boolean isXML11ValidQName(String str) {
        int colon = str.indexOf(58);
        if (colon == 0 || colon == str.length() - 1) {
            return false;
        }
        if (colon > 0) {
            String prefix = str.substring(0, colon);
            String localPart = str.substring(colon + 1);
            return XML11Char.isXML11ValidNCName((String)prefix) && XML11Char.isXML11ValidNCName((String)localPart);
        }
        return XML11Char.isXML11ValidNCName((String)str);
    }

    public static boolean isTrueXml(CustomTemplateCallback callback) {
        return XmlZenCodingTemplate.isTrueXml(callback.getFileType());
    }

    public static boolean isTrueXml(FileType type) {
        return type == StdFileTypes.XHTML || type == StdFileTypes.JSPX || type == StdFileTypes.XML;
    }

    private static boolean isHtml(CustomTemplateCallback callback) {
        FileType type = callback.getFileType();
        return type == StdFileTypes.HTML || type == StdFileTypes.XHTML;
    }

    @Override
    @Nullable
    protected TemplateToken parseTemplateKey(String key, CustomTemplateCallback callback) {
        TemplateImpl template;
        String prefix = XmlZenCodingTemplate.getPrefix(key);
        boolean useDefaultTag = false;
        if (prefix.length() == 0) {
            if (!XmlZenCodingTemplate.isHtml(callback)) {
                return null;
            }
            useDefaultTag = true;
            prefix = DEFAULT_TAG;
            key = prefix + key;
        }
        if ((template = callback.findApplicableTemplate(prefix)) == null && !XmlZenCodingTemplate.isXML11ValidQName(prefix)) {
            return null;
        }
        final XmlTemplateToken token = XmlZenCodingTemplate.parseSelectors(key);
        if (token == null) {
            return null;
        }
        if (useDefaultTag && token.getAttribute2Value().size() == 0) {
            return null;
        }
        if (template == null) {
            template = XmlZenCodingTemplate.generateTagTemplate(token.getKey(), callback);
        }
        assert (prefix.equals(token.getKey()));
        token.setTemplate(template);
        final XmlTag tag = XmlZenCodingTemplate.parseXmlTagInTemplate(template.getString(), callback, true);
        if (token.getAttribute2Value().size() > 0 && tag == null) {
            return null;
        }
        if (tag != null) {
            if (!XmlZenCodingInterpreter.containsAttrsVar(template) && token.getAttribute2Value().size() > 0) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        XmlZenCodingTemplate.addMissingAttributes(tag, token.getAttribute2Value());
                    }
                });
            }
            token.setTag(tag);
        }
        return token;
    }

    private static void addMissingAttributes(XmlTag tag, List<Pair<String, String>> value) {
        ArrayList<Pair<String, String>> attr2value = new ArrayList<Pair<String, String>>(value);
        Iterator iterator = attr2value.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (tag.getAttribute((String)pair.first) == null) continue;
            iterator.remove();
        }
        XmlZenCodingTemplate.addAttributesBefore(tag, attr2value);
    }

    private static void addAttributesBefore(XmlTag tag, List<Pair<String, String>> attr2value) {
        XmlAttribute[] attributes = tag.getAttributes();
        XmlAttribute firstAttribute = attributes.length > 0 ? attributes[0] : null;
        XmlElementFactory factory = XmlElementFactory.getInstance((Project)tag.getProject());
        for (Pair<String, String> pair : attr2value) {
            XmlAttribute xmlAttribute = factory.createXmlAttribute((String)pair.first, "");
            if (firstAttribute != null) {
                tag.addBefore((PsiElement)xmlAttribute, (PsiElement)firstAttribute);
                continue;
            }
            tag.add((PsiElement)xmlAttribute);
        }
    }

    @NotNull
    private static TemplateImpl generateTagTemplate(String tagName, CustomTemplateCallback callback) {
        StringBuilder builder = new StringBuilder("<");
        builder.append(tagName).append('>');
        if (XmlZenCodingTemplate.isTrueXml(callback) || !HtmlUtil.isSingleHtmlTag(tagName)) {
            builder.append("$END$</").append(tagName).append('>');
        }
        TemplateImpl templateImpl = new TemplateImpl("", builder.toString(), "");
        if (templateImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/zencoding/XmlZenCodingTemplate.generateTagTemplate must not return null");
        }
        return templateImpl;
    }

    @Nullable
    static XmlTag parseXmlTagInTemplate(String templateString, CustomTemplateCallback callback, boolean createPhysicalFile) {
        XmlDocument document;
        XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)callback.getProject()).createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, (CharSequence)templateString, LocalTimeCounter.currentTime(), createPhysicalFile);
        VirtualFile vFile = xmlFile.getVirtualFile();
        if (vFile != null) {
            vFile.putUserData(UndoManager.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        return (document = xmlFile.getDocument()) == null ? null : document.getRootTag();
    }

    @Override
    protected boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingTemplate.isApplicable must not be null");
        }
        if (element.getLanguage() instanceof XMLLanguage) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class) != null) {
                return false;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlComment.class) != null) {
                return false;
            }
            return XmlZenCodingTemplate.findApplicableFilter(element);
        }
        return false;
    }

    private static boolean findApplicableFilter(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingTemplate.findApplicableFilter must not be null");
        }
        for (ZenCodingFilter filter : (ZenCodingFilter[])ZenCodingFilter.EP_NAME.getExtensions()) {
            if (!filter.isMyContext(context)) continue;
            return true;
        }
        return new XmlZenCodingFilterImpl().isMyContext(context);
    }

    public static boolean startZenCoding(Editor editor, PsiFile file, String abbreviation) {
        int caretAt = editor.getCaretModel().getOffset();
        XmlZenCodingTemplate template = (XmlZenCodingTemplate)CustomLiveTemplate.EP_NAME.findExtension(XmlZenCodingTemplate.class);
        if (abbreviation != null && !template.supportsWrapping()) {
            return false;
        }
        if (template.isApplicable(file, caretAt)) {
            final CustomTemplateCallback callback = new CustomTemplateCallback(editor, file);
            if (abbreviation != null) {
                String selection = callback.getEditor().getSelectionModel().getSelectedText();
                assert (selection != null);
                selection = selection.trim();
                template.doWrap(selection, abbreviation, callback, new TemplateInvokationListener(){

                    @Override
                    public void finished() {
                        callback.startAllExpandedTemplates();
                    }
                });
            } else {
                String key = template.computeTemplateKey(callback);
                if (key != null) {
                    template.expand(key, callback);
                    callback.startAllExpandedTemplates();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        int elementStart;
        if (callback == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingTemplate.computeTemplateKey must not be null");
        }
        Editor editor = callback.getEditor();
        PsiElement element = callback.getContext();
        int line = editor.getCaretModel().getLogicalPosition().line;
        int lineStart = editor.getDocument().getLineStartOffset(line);
        do {
            int startOffset;
            String key;
            if (!this.checkTemplateKey(key = XmlZenCodingTemplate.computeKey(editor, startOffset = (elementStart = element.getTextRange().getStartOffset()) > lineStart ? elementStart : lineStart), callback)) continue;
            return key;
        } while ((element = element.getParent()) != null && elementStart > lineStart);
        return null;
    }

    @Override
    public boolean supportsWrapping() {
        return true;
    }
}

