/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class Descriptor {
    private final String myText;
    private final String[] myGroup;
    private final HighlightDisplayKey myKey;
    private final Element myConfig;
    private final InspectionProfileEntry myTool;
    private final HighlightDisplayLevel myLevel;
    private boolean myEnabled = false;
    private final NamedScope myScope;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.Descriptor");
    private final ScopeToolState myState;

    public Descriptor(ScopeToolState pair, InspectionProfile inspectionProfile) {
        String[] stringArray;
        this.myState = pair;
        InspectionProfileEntry tool = pair.getTool();
        Element config = new Element("options");
        try {
            tool.writeSettings(config);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        this.myConfig = config;
        this.myText = tool.getDisplayName();
        String[] groupPath = tool.getGroupPath();
        if (groupPath.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = InspectionProfileEntry.GENERAL_GROUP_NAME;
        } else {
            stringArray = groupPath;
        }
        this.myGroup = stringArray;
        this.myKey = HighlightDisplayKey.find((String)tool.getShortName());
        this.myLevel = ((InspectionProfileImpl)inspectionProfile).getErrorLevel(this.myKey, pair.getScope());
        this.myEnabled = ((InspectionProfileImpl)inspectionProfile).isToolEnabled(this.myKey, pair.getScope());
        this.myTool = tool;
        this.myScope = pair.getScope();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Descriptor)) {
            return false;
        }
        Descriptor descriptor = (Descriptor)obj;
        return this.myKey.equals(descriptor.getKey()) && this.myLevel.equals(descriptor.getLevel()) && this.myEnabled == descriptor.isEnabled() && this.myState.equalTo(descriptor.getState());
    }

    public int hashCode() {
        int hash = this.myKey.hashCode() + 29 * this.myLevel.hashCode();
        return this.myScope != null ? this.myScope.hashCode() + 29 * hash : hash;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public HighlightDisplayKey getKey() {
        HighlightDisplayKey highlightDisplayKey = this.myKey;
        if (highlightDisplayKey == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/Descriptor.getKey must not return null");
        }
        return highlightDisplayKey;
    }

    public HighlightDisplayLevel getLevel() {
        return this.myLevel;
    }

    public Element getConfig() {
        return this.myConfig;
    }

    public InspectionProfileEntry getTool() {
        return this.myTool;
    }

    public String loadDescription() {
        if (!(this.myTool instanceof InspectionTool)) {
            return null;
        }
        return this.myTool.loadDescription();
    }

    public String[] getGroup() {
        return this.myGroup;
    }

    public NamedScope getScope() {
        return this.myScope;
    }

    public ScopeToolState getState() {
        return this.myState;
    }

    public String toString() {
        return this.myKey.toString();
    }
}

