/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileObject {
    private static final byte[] NOT_LOADED = new byte[0];
    private final File myFile;
    private final byte[] myContent;

    public FileObject(@NotNull File file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/FileObject.<init> must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/FileObject.<init> must not be null");
        }
        this.myFile = file;
        this.myContent = content;
    }

    public FileObject(File file) {
        this.myFile = file;
        this.myContent = NOT_LOADED;
    }

    public File getFile() {
        return this.myFile;
    }

    public byte[] getContent() throws IOException {
        if (this.myContent == NOT_LOADED) {
            return FileUtil.loadFileBytes((File)this.myFile);
        }
        return this.myContent;
    }

    public void save() throws IOException {
        if (this.myContent == NOT_LOADED) {
            return;
        }
        try {
            FileUtil.writeToFile((File)this.myFile, (byte[])this.myContent);
        }
        catch (FileNotFoundException e) {
            FileUtil.createParentDirs((File)this.myFile);
            FileUtil.writeToFile((File)this.myFile, (byte[])this.myContent);
        }
    }

    public String toString() {
        return this.getFile().toString();
    }
}

