/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public abstract class BreakpointFactory {
    public static final ExtensionPointName<BreakpointFactory> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.debugger.breakpointFactory");

    public abstract Breakpoint createBreakpoint(Project var1, Element var2);

    public abstract Key<? extends Breakpoint> getBreakpointCategory();

    @Nullable
    public abstract BreakpointPanel createBreakpointPanel(Project var1, DialogWrapper var2);

    public abstract Icon getIcon();

    public abstract Icon getDisabledIcon();

    @Nullable
    public static BreakpointFactory getInstance(Key<? extends Breakpoint> category) {
        BreakpointFactory[] allFactories;
        for (BreakpointFactory factory : allFactories = (BreakpointFactory[])ApplicationManager.getApplication().getExtensions(EXTENSION_POINT_NAME)) {
            if (!category.equals(factory.getBreakpointCategory())) continue;
            return factory;
        }
        return null;
    }
}

