/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerNotificationsHandler;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerUIActionsHandler;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.statistics.StatisticsPanel;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class SMTestRunnerConnectionUtil {
    private static final String TEST_RUNNER_DEBUG_MODE_PROPERTY = "idea.smrunner.debug";

    private SMTestRunnerConnectionUtil() {
    }

    public static BaseTestsOutputConsoleView attachRunner(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler, @NotNull TestConsoleProperties consoleProperties, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) throws ExecutionException {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil.attachRunner must not be null");
        }
        if (processHandler == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil.attachRunner must not be null");
        }
        if (consoleProperties == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil.attachRunner must not be null");
        }
        String splitterPropertyName = testFrameworkName + ".Splitter.Proportion";
        SMTRunnerConsoleView testRunnerConsole = new SMTRunnerConsoleView(consoleProperties, runnerSettings, configurationSettings, splitterPropertyName);
        testRunnerConsole.initUI();
        SMTestRunnerResultsForm resultsViewer = testRunnerConsole.getResultsViewer();
        SMTestRunnerConnectionUtil.attachEventsProcessors(consoleProperties, resultsViewer, resultsViewer.getStatisticsPane(), processHandler, testFrameworkName);
        testRunnerConsole.attachToProcess(processHandler);
        return testRunnerConsole;
    }

    public static ConsoleView attachRunner(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler, @NotNull CommandLineState commandLineState, @NotNull RuntimeConfiguration config) throws ExecutionException {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil.attachRunner must not be null");
        }
        if (processHandler == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil.attachRunner must not be null");
        }
        if (commandLineState == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil.attachRunner must not be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil.attachRunner must not be null");
        }
        SMTRunnerConsoleProperties consoleProperties = new SMTRunnerConsoleProperties(config, testFrameworkName);
        return SMTestRunnerConnectionUtil.attachRunner(testFrameworkName, processHandler, consoleProperties, commandLineState.getRunnerSettings(), commandLineState.getConfigurationSettings());
    }

    public static boolean isInDebugMode() {
        return Boolean.valueOf(System.getProperty(TEST_RUNNER_DEBUG_MODE_PROPERTY));
    }

    private static ProcessHandler attachEventsProcessors(@NotNull TestConsoleProperties consoleProperties, SMTestRunnerResultsForm resultsViewer, StatisticsPanel statisticsPane, ProcessHandler processHandler, @NotNull String testFrameworkName) throws ExecutionException {
        if (consoleProperties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil.attachEventsProcessors must not be null");
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil.attachEventsProcessors must not be null");
        }
        final OutputToGeneralTestEventsConverter outputConsumer = new OutputToGeneralTestEventsConverter(testFrameworkName);
        final GeneralToSMTRunnerEventsConvertor eventsProcessor = new GeneralToSMTRunnerEventsConvertor(resultsViewer.getTestsRootNode(), testFrameworkName);
        SMTRunnerUIActionsHandler uiActionsHandler = new SMTRunnerUIActionsHandler(consoleProperties);
        SMTRunnerNotificationsHandler notifierHandler = new SMTRunnerNotificationsHandler(consoleProperties);
        outputConsumer.setProcessor(eventsProcessor);
        eventsProcessor.addEventsListener(resultsViewer);
        resultsViewer.addEventsListener(uiActionsHandler);
        eventsProcessor.addEventsListener(statisticsPane.createTestEventsListener());
        eventsProcessor.addEventsListener(notifierHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                Disposer.dispose((Disposable)eventsProcessor);
                Disposer.dispose((Disposable)outputConsumer);
            }

            public void startNotified(ProcessEvent event) {
                eventsProcessor.onStartTesting();
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                outputConsumer.flushBufferBeforeTerminating();
                eventsProcessor.onFinishTesting();
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                outputConsumer.process(event.getText(), outputType);
            }
        });
        return processHandler;
    }
}

