/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.autodetecting.FacetAutodetectingManagerImpl;
import com.intellij.facet.impl.autodetecting.FacetDetectionIndexEntry;
import com.intellij.facet.impl.autodetecting.model.DetectedFacetInfo;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.fileIndex.AbstractFileIndex;
import gnu.trove.THashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetDetectionIndex
extends AbstractFileIndex<FacetDetectionIndexEntry> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.autodetecting.FacetDetectionIndex");
    private static final byte CURRENT_VERSION = 1;
    @NonNls
    private static final String CACHE_DIRECTORY_NAME = "facets";
    private final FileTypeManager myFileTypeManager;
    private final Set<FileType> myFileTypes;
    private final Set<FacetType> myNewFacetTypes = new THashSet();
    private final FacetPointersManager myFacetPointersManager;
    private final FacetAutodetectingManagerImpl myAutodetectingManager;
    private final BidirectionalMultiMap<String, FacetPointer> myFacets;
    private final BidirectionalMultiMap<String, Integer> myDetectedFacetIds;

    public FacetDetectionIndex(Project project, FacetAutodetectingManagerImpl autodetectingManager, Set<FileType> fileTypes) {
        super(project);
        this.myAutodetectingManager = autodetectingManager;
        this.myFileTypes = new THashSet(fileTypes);
        this.myFileTypeManager = FileTypeManager.getInstance();
        this.myFacetPointersManager = FacetPointersManager.getInstance((Project)project);
        this.myFacets = new BidirectionalMultiMap();
        this.myDetectedFacetIds = new BidirectionalMultiMap();
    }

    @Override
    protected FacetDetectionIndexEntry createIndexEntry(DataInputStream input) throws IOException {
        return new FacetDetectionIndexEntry(input, this.myFacetPointersManager);
    }

    @Override
    public boolean belongs(VirtualFile file) {
        FileType fileType = this.myFileTypeManager.getFileTypeByFile(file);
        return this.myFileTypes.contains(fileType);
    }

    @Override
    protected String getLoadingIndicesMessage() {
        return ProjectBundle.message((String)"progress.text.loading.facet.detection.indices", (Object[])new Object[0]);
    }

    @Override
    protected String getBuildingIndicesMessage(boolean formatChanged) {
        return formatChanged ? ProjectBundle.message((String)"progress.text.facet.indices.format.has.changed.redetecting.facets", (Object[])new Object[0]) : ProjectBundle.message((String)"progress.text.detecting.facets", (Object[])new Object[0]);
    }

    @Override
    public byte getCurrentVersion() {
        return 1;
    }

    @Override
    public String getCachesDirName() {
        return CACHE_DIRECTORY_NAME;
    }

    public static File getDetectedFacetsFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectionIndex.getDetectedFacetsFile must not be null");
        }
        return new File(PathManager.getSystemPath() + File.separator + CACHE_DIRECTORY_NAME + File.separator + project.getName() + ".detected." + project.getLocationHash());
    }

    @Override
    protected void readHeader(DataInputStream input) throws IOException {
        int size = input.readInt();
        THashSet facetTypesInCache = new THashSet();
        while (size-- > 0) {
            facetTypesInCache.add(input.readUTF());
        }
        THashSet unknownTypes = new THashSet((Collection)facetTypesInCache);
        for (FacetType type : FacetTypeRegistry.getInstance().getFacetTypes()) {
            unknownTypes.remove(type.getStringId());
            if (facetTypesInCache.contains(type.getStringId())) continue;
            this.myNewFacetTypes.add(type);
        }
        if (!unknownTypes.isEmpty()) {
            LOG.info("Unknown facet types in cache: " + new HashSet(unknownTypes));
        }
    }

    @Override
    @Nullable
    protected Set<FileType> getFileTypesToRefresh() {
        if (this.myNewFacetTypes.isEmpty()) {
            return null;
        }
        return this.myAutodetectingManager.getFileTypes(this.myNewFacetTypes);
    }

    @Override
    protected void writeHeader(DataOutputStream output) throws IOException {
        FacetType[] types = FacetTypeRegistry.getInstance().getFacetTypes();
        output.writeInt(types.length);
        for (FacetType type : types) {
            output.writeUTF(type.getStringId());
        }
    }

    @Override
    public void queueEntryUpdate(VirtualFile file) {
        this.myAutodetectingManager.queueUpdate(file);
    }

    @Override
    protected void doUpdateIndexEntry(VirtualFile file) {
        this.myAutodetectingManager.processFile(file);
    }

    @Nullable
    public Set<String> getFiles(Integer id) {
        return this.myDetectedFacetIds.getKeys((Object)id);
    }

    @Nullable
    public Set<String> getFiles(FacetPointer pointer) {
        return this.myFacets.getKeys((Object)pointer);
    }

    @Nullable
    public Set<String> getFiles(Facet facet) {
        return this.myFacets.getKeys((Object)this.myFacetPointersManager.create(facet));
    }

    @Override
    protected void onEntryAdded(String url, FacetDetectionIndexEntry entry) {
        this.myFacets.removeKey((Object)url);
        SmartList<FacetPointer> detectedFacets = entry.getFacets();
        if (detectedFacets != null) {
            for (FacetPointer detectedFacet : detectedFacets) {
                this.myFacets.put((Object)url, (Object)detectedFacet);
            }
        }
        this.myDetectedFacetIds.removeKey((Object)url);
        SmartList<Integer> facetIds = entry.getDetectedFacetIds();
        if (facetIds != null) {
            for (Integer id : facetIds) {
                this.myDetectedFacetIds.put((Object)url, (Object)id);
            }
        }
    }

    @Override
    protected void onEntryRemoved(String url, FacetDetectionIndexEntry entry) {
        Set ids = this.myDetectedFacetIds.getValues((Object)url);
        this.myDetectedFacetIds.removeKey((Object)url);
        if (ids != null && !ids.isEmpty()) {
            this.myAutodetectingManager.removeObsoleteFacets(ids);
        }
    }

    public void removeFacetFromCache(FacetPointer<Facet> facetPointer) {
        Set urls = this.myFacets.getKeys(facetPointer);
        if (urls != null) {
            for (String url : urls) {
                FacetDetectionIndexEntry indexEntry = (FacetDetectionIndexEntry)this.getIndexEntry(url);
                if (indexEntry == null) continue;
                indexEntry.remove(facetPointer);
            }
        }
        this.myFacets.removeValue(facetPointer);
    }

    public void updateIndexEntryForCreatedFacet(DetectedFacetInfo<Module> info, Facet facet) {
        FacetPointer pointer = FacetPointersManager.getInstance((Project)facet.getModule().getProject()).create(facet);
        Set urls = this.myDetectedFacetIds.getKeys((Object)info.getId());
        if (urls != null) {
            String[] urlsArray;
            for (String url : urlsArray = ArrayUtil.toStringArray((Collection)urls)) {
                this.myDetectedFacetIds.remove((Object)url, (Object)info.getId());
                this.myFacets.put((Object)url, (Object)pointer);
                FacetDetectionIndexEntry indexEntry = (FacetDetectionIndexEntry)this.getIndexEntry(url);
                indexEntry.remove(info.getId());
                indexEntry.add((FacetPointer<Facet>)pointer);
            }
        }
    }

    public boolean isEmpty() {
        return this.myDetectedFacetIds.isEmpty() && this.myFacets.isEmpty();
    }

    public void removeFromIndex(DetectedFacetInfo<Module> info) {
        int id = info.getId();
        Set urls = this.myDetectedFacetIds.getKeys((Object)id);
        if (urls != null) {
            for (String url : urls) {
                FacetDetectionIndexEntry entry = (FacetDetectionIndexEntry)this.getIndexEntry(url);
                if (entry == null) continue;
                entry.remove(id);
            }
        }
        this.myDetectedFacetIds.removeValue((Object)id);
    }
}

