/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.annotations.NotNull;

public class ShowFilePathAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ShowFilePathAction");

    public void update(AnActionEvent e) {
        if (!ShowFilePathAction.isSupported()) {
            e.getPresentation().setVisible(false);
            return;
        }
        e.getPresentation().setEnabled(this.getFile(e) != null);
    }

    public static boolean isSupported() {
        return ShowFilePathAction.isJava6() || SystemInfo.isMac;
    }

    private static boolean isJava6() {
        return System.getProperty("java.version").startsWith("1.6");
    }

    public void actionPerformed(AnActionEvent e) {
        ShowFilePathAction.show(this.getFile(e), new ShowAction(){

            @Override
            public void show(ListPopup popup) {
                DataContext context = DataManager.getInstance().getDataContext();
                popup.showInBestPositionFor(context);
            }
        });
    }

    public static void show(VirtualFile file, final MouseEvent e) {
        ShowFilePathAction.show(file, new ShowAction(){

            @Override
            public void show(ListPopup popup) {
                if (!e.getComponent().isShowing()) {
                    return;
                }
                popup.show(new RelativePoint(e));
            }
        });
    }

    public static void show(VirtualFile file, final ShowAction show) {
        if (!ShowFilePathAction.isSupported()) {
            return;
        }
        final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        final ArrayList<String> fileUrls = new ArrayList<String>();
        for (VirtualFile eachParent = file; eachParent != null; eachParent = eachParent.getParent()) {
            int index = files.size() == 0 ? 0 : files.size();
            files.add(index, eachParent);
            fileUrls.add(index, ShowFilePathAction.getPresentableUrl(eachParent));
            if (eachParent.getParent() == null && eachParent.getFileSystem() instanceof JarFileSystem && (eachParent = JarFileSystem.getInstance().getVirtualFileForJar(eachParent)) == null) break;
        }
        final ArrayList icons = new ArrayList();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                for (String each : fileUrls) {
                    File ioFile = new File(each);
                    Icon eachIcon = ioFile.exists() ? FileSystemView.getFileSystemView().getSystemIcon(ioFile) : new EmptyIcon(16, 16);
                    icons.add(eachIcon);
                }
                LaterInvocator.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        show.show(ShowFilePathAction.createPopup(files, icons));
                    }
                });
            }
        });
    }

    private static String getPresentableUrl(VirtualFile eachParent) {
        String url = eachParent.getPresentableUrl();
        if (eachParent.getParent() == null && SystemInfo.isWindows) {
            url = url + "\\";
        }
        return url;
    }

    private static ListPopup createPopup(final ArrayList<VirtualFile> files, ArrayList<Icon> icons) {
        BaseListPopupStep<VirtualFile> step = new BaseListPopupStep<VirtualFile>("File Path", files, icons){

            @NotNull
            public String getTextFor(VirtualFile value) {
                String string = value.getPresentableName();
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/actions/ShowFilePathAction$4.getTextFor must not return null");
                }
                return string;
            }

            public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                final Ref open = new Ref();
                final Ref toSelect = new Ref();
                File selectedIoFile = new File(ShowFilePathAction.getPresentableUrl(selectedValue));
                if (files.indexOf(selectedValue) == 0 && files.size() > 1) {
                    open.set((Object)new File(ShowFilePathAction.getPresentableUrl((VirtualFile)files.get(1))));
                    toSelect.set((Object)selectedIoFile);
                } else {
                    open.set((Object)selectedIoFile);
                }
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        ShowFilePathAction.open((File)open.get(), (File)toSelect.get());
                    }
                });
                return FINAL_CHOICE;
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        return popup;
    }

    public static void open(File ioFile, File toSelect) {
        block9: {
            if (SystemInfo.isMac) {
                String cmd = "open";
                String path = ioFile.getAbsolutePath();
                try {
                    File parent = ioFile.getParentFile();
                    if (parent != null) {
                        Runtime.getRuntime().exec(cmd + " " + path, ArrayUtil.EMPTY_STRING_ARRAY, parent);
                        break block9;
                    }
                    Runtime.getRuntime().exec(cmd + " " + path);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            } else if (ShowFilePathAction.isJava6()) {
                try {
                    Object desktopObject = Class.forName("java.awt.Desktop").getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    desktopObject.getClass().getMethod("open", File.class).invoke(desktopObject, ioFile);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    private VirtualFile getFile(AnActionEvent e) {
        return (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
    }

    static interface ShowAction {
        public void show(ListPopup var1);
    }
}

