/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;

public class DefaultClassNavigationContributor
implements GotoClassContributor {
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        return JavaPsiFacade.getInstance((Project)project).getShortNamesCache().getAllClassNames();
    }

    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        return DefaultClassNavigationContributor.filterUnshowable(JavaPsiFacade.getInstance((Project)project).getShortNamesCache().getClassesByName(name, scope), pattern);
    }

    private static NavigationItem[] filterUnshowable(PsiClass[] items, String pattern) {
        boolean isAnnotation = pattern.startsWith("@");
        ArrayList<PsiClass> list = new ArrayList<PsiClass>(items.length);
        for (PsiClass item : items) {
            if (item.getContainingFile().getVirtualFile() == null || isAnnotation && !item.isAnnotationType()) continue;
            list.add(item);
        }
        return list.toArray(new NavigationItem[list.size()]);
    }

    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)item;
            String qName = psiClass.getQualifiedName();
            if (qName != null) {
                return qName;
            }
            String containerText = SymbolPresentationUtil.getSymbolContainerText((PsiElement)psiClass);
            return containerText + "." + psiClass.getName();
        }
        return null;
    }
}

