/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lifecycle;

import com.intellij.lifecycle.ControlledAlarmFactory;
import com.intellij.lifecycle.SlowlyClosingAlarm;
import com.intellij.openapi.project.Project;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ScheduledSlowlyClosingAlarm
extends SlowlyClosingAlarm {
    ScheduledSlowlyClosingAlarm(@NotNull Project project, @NotNull String name, ControlledAlarmFactory.MyExecutorWrapper executor, boolean executorIsShared) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lifecycle/ScheduledSlowlyClosingAlarm.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lifecycle/ScheduledSlowlyClosingAlarm.<init> must not be null");
        }
        super(project, name, executor, executorIsShared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(Runnable runnable, int delayMillis) {
        if (this.myExecutorService.supportsScheduling()) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myDisposeStarted) {
                    return;
                }
                SlowlyClosingAlarm.MyWrapper wrapper = new SlowlyClosingAlarm.MyWrapper(this, runnable);
                Future<?> future = this.myExecutorService.schedule(wrapper, delayMillis, TimeUnit.MILLISECONDS);
                wrapper.setFuture(future);
                this.myFutureList.add(future);
                this.debug("request scheduled");
            }
        } else {
            this.addRequest(runnable);
        }
    }
}

