/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibrariesAlphaComparator;
import com.intellij.openapi.roots.ui.configuration.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.AbstractLibraryTreeStructure;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;

class LibraryTableTreeStructure
extends AbstractLibraryTreeStructure {
    private final Object myRootElement = new Object();

    public LibraryTableTreeStructure(LibraryTableEditor parentEditor) {
        super(parentEditor);
        this.myRootElementDescriptor = new NodeDescriptor(null, null){

            public boolean update() {
                this.myName = ProjectBundle.message((String)"library.root.node", (Object[])new Object[0]);
                return false;
            }

            public Object getElement() {
                return LibraryTableTreeStructure.this.myRootElement;
            }
        };
    }

    public Object getRootElement() {
        return this.myRootElement;
    }

    public Object[] getChildElements(Object element) {
        LibraryTableTreeContentElement contentElement;
        LibraryTableTreeContentElement parentElement;
        if (element == this.myRootElement) {
            Library[] libraries = this.myParentEditor.getLibraries();
            Arrays.sort(libraries, LibrariesAlphaComparator.INSTANCE);
            Object[] elements = new LibraryElement[libraries.length];
            for (int idx = 0; idx < libraries.length; ++idx) {
                Library library = libraries[idx];
                boolean allPathsValid = true;
                for (OrderRootType type : OrderRootType.getAllTypes()) {
                    allPathsValid &= this.allPathsValid(library, type);
                }
                elements[idx] = new LibraryElement(library, this.myParentEditor, !allPathsValid);
            }
            return elements;
        }
        if (element instanceof LibraryElement) {
            LibraryElement libraryItemElement = (LibraryElement)element;
            ArrayList<LibraryTableTreeContentElement> elements = new ArrayList<LibraryTableTreeContentElement>(3);
            Library library = libraryItemElement.getLibrary();
            LibraryEditor parentEditor = this.myParentEditor.getLibraryEditor(library);
            for (OrderRootType type : OrderRootType.getAllTypes()) {
                String[] urls = parentEditor.getUrls(type);
                if (urls.length <= 0) continue;
                elements.add(((OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type)).createElement(libraryItemElement));
            }
            return elements.toArray();
        }
        if (element instanceof LibraryTableTreeContentElement && (parentElement = (contentElement = (LibraryTableTreeContentElement)element).getParent()) instanceof LibraryElement) {
            return this.buildItems(contentElement, ((LibraryElement)parentElement).getLibrary(), contentElement.getOrderRootType());
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private boolean allPathsValid(Library library, OrderRootType orderRootType) {
        return this.myParentEditor.getLibraryEditor(library).allPathsValid(orderRootType);
    }
}

