/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.ui.ChangelistMoveOfferDialog;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ConfirmationDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ui.CommitHelper");
    private final Project myProject;
    private final ChangeList myChangeList;
    private final List<Change> myIncludedChanges;
    private final String myActionName;
    private final String myCommitMessage;
    private final List<CheckinHandler> myHandlers;
    private final boolean myAllOfDefaultChangeListChangesIncluded;
    private final boolean myForceSyncCommit;
    private final Map<String, Object> myAdditionalData;
    private final List<Document> myCommittingDocuments = new ArrayList<Document>();
    private final VcsConfiguration myConfiguration;
    private final VcsDirtyScopeManager myDirtyScopeManager;

    public CommitHelper(Project project, ChangeList changeList, List<Change> includedChanges, String actionName, String commitMessage, List<CheckinHandler> handlers, boolean allOfDefaultChangeListChangesIncluded, boolean synchronously, Map<String, Object> additionalData) {
        this.myProject = project;
        this.myChangeList = changeList;
        this.myIncludedChanges = includedChanges;
        this.myActionName = actionName;
        this.myCommitMessage = commitMessage;
        this.myHandlers = handlers;
        this.myAllOfDefaultChangeListChangesIncluded = allOfDefaultChangeListChangesIncluded;
        this.myForceSyncCommit = synchronously;
        this.myAdditionalData = additionalData;
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
    }

    public boolean doCommit() {
        return this.doCommit(new CommitProcessor());
    }

    public boolean doAlienCommit(AbstractVcs vcs) {
        return this.doCommit(new AlienCommitProcessor(vcs));
    }

    private boolean doCommit(final GeneralCommitProcessor processor) {
        final Runnable action = new Runnable(){

            @Override
            public void run() {
                CommitHelper.this.generalCommit(processor);
            }
        };
        if (this.myForceSyncCommit) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(action, this.myActionName, true, this.myProject);
            return CommitHelper.doesntContainErrors(processor.getVcsExceptions());
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, this.myActionName, true, this.myConfiguration.getCommitOption()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ui/CommitHelper$2.run must not be null");
                }
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
                vcsManager.startBackgroundVcsOperation();
                try {
                    action.run();
                }
                finally {
                    vcsManager.stopBackgroundVcsOperation();
                }
            }

            @Nullable
            public Task.NotificationInfo getNotificationInfo() {
                List<Change> changesFailedToCommit = processor.getChangesFailedToCommit();
                String text = CommitHelper.this.myIncludedChanges.size() - changesFailedToCommit.size() + " Change(s) Commited";
                if (changesFailedToCommit.size() > 0) {
                    text = text + ", " + changesFailedToCommit.size() + " Change(s) Failed To Commit";
                }
                return new Task.NotificationInfo("VCS Commit", "VCS Commit Finished", text, true);
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return false;
    }

    private static boolean doesntContainErrors(List<VcsException> vcsExceptions) {
        for (VcsException vcsException : vcsExceptions) {
            if (vcsException.isWarning()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generalCommit(GeneralCommitProcessor processor) {
        try {
            Application appManager = ApplicationManager.getApplication();
            appManager.runReadAction(new Runnable(){

                @Override
                public void run() {
                    CommitHelper.this.markCommittingDocuments();
                }
            });
            try {
                processor.callSelf();
            }
            catch (Throwable throwable) {
                appManager.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        CommitHelper.this.unmarkCommittingDocuments();
                    }
                });
                throw throwable;
            }
            appManager.runReadAction(new /* invalid duplicate definition of identical inner class */);
            processor.doBeforeRefresh();
            AbstractVcsHelper.getInstanceChecked((Project)this.myProject).showErrors(processor.getVcsExceptions(), this.myActionName);
            this.commitCompleted(processor.getVcsExceptions(), processor);
        }
        catch (Exception e) {
            try {
                LOG.error((Throwable)e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.commitCompleted(processor.getVcsExceptions(), processor);
                processor.customRefresh();
                ApplicationManager.getApplication().invokeLater(new Runnable(processor){
                    final /* synthetic */ GeneralCommitProcessor val$processor;
                    {
                        this.val$processor = generalCommitProcessor;
                    }

                    @Override
                    public void run() {
                        Runnable runnable = this.val$processor.postRefresh();
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                });
                throw throwable;
            }
        }
        processor.customRefresh();
        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void markCommittingDocuments() {
        for (Change change : this.myIncludedChanges) {
            Document doc = ChangesUtil.getFilePath((Change)change).getDocument();
            if (doc == null) continue;
            doc.putUserData(ChangeListManagerImpl.DOCUMENT_BEING_COMMITTED_KEY, (Object)this.myProject);
            this.myCommittingDocuments.add(doc);
        }
    }

    private void unmarkCommittingDocuments() {
        for (Document doc : this.myCommittingDocuments) {
            doc.putUserData(ChangeListManagerImpl.DOCUMENT_BEING_COMMITTED_KEY, null);
        }
        this.myCommittingDocuments.clear();
    }

    private void commitCompleted(List<VcsException> allExceptions, final GeneralCommitProcessor processor) {
        List<VcsException> errors = CommitHelper.collectErrors(allExceptions);
        final int errorsSize = errors.size();
        final int warningsSize = allExceptions.size() - errorsSize;
        if (errorsSize == 0) {
            for (CheckinHandler handler : this.myHandlers) {
                handler.checkinSuccessful();
            }
            processor.afterSuccessfulCheckIn();
        } else {
            for (CheckinHandler handler : this.myHandlers) {
                handler.checkinFailed(errors);
            }
        }
        if (errorsSize == 0 && warningsSize == 0) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setText(VcsBundle.message((String)"commit.dialog.completed.successfully", (Object[])new Object[0]));
            }
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String message = errorsSize > 0 && warningsSize > 0 ? VcsBundle.message((String)"message.text.commit.failed.with.errors.and.warnings", (Object[])new Object[0]) : (errorsSize > 0 ? VcsBundle.message((String)"message.text.commit.failed.with.errors", (Object[])new Object[0]) : VcsBundle.message((String)"message.text.commit.finished.with.warnings", (Object[])new Object[0]));
                    Messages.showErrorDialog((String)message, (String)VcsBundle.message((String)"message.title.commit", (Object[])new Object[0]));
                    if (errorsSize > 0) {
                        processor.afterFailedCheckIn();
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    public static void moveToFailedList(ChangeList changeList, String commitMessage, List<Change> failedChanges, String newChangelistName, Project project) {
        VcsShowConfirmationOption option;
        boolean result;
        if (failedChanges.containsAll(changeList.getChanges())) {
            return;
        }
        final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project);
        if (configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST != VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY && !(result = ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)(option = new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
                configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST = value;
            }
        }), (Project)project, (String)VcsBundle.message((String)"commit.failed.confirm.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.failed.confirm.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()))) {
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        int index = 1;
        String failedListName = newChangelistName;
        while (changeListManager.findChangeList(failedListName) != null) {
            failedListName = newChangelistName + " (" + ++index + ")";
        }
        LocalChangeList failedList = changeListManager.addChangeList(failedListName, commitMessage);
        changeListManager.moveChangesTo(failedList, failedChanges.toArray(new Change[failedChanges.size()]));
    }

    private static List<VcsException> collectErrors(List<VcsException> vcsExceptions) {
        ArrayList<VcsException> result = new ArrayList<VcsException>();
        for (VcsException vcsException : vcsExceptions) {
            if (vcsException.isWarning()) continue;
            result.add(vcsException);
        }
        return result;
    }

    private class CommitProcessor
    extends GeneralCommitProcessor {
        private boolean myKeepChangeListAfterCommit;
        private LocalHistoryAction myAction;
        private ChangeListsModificationAfterCommit myAfterVcsRefreshModification = ChangeListsModificationAfterCommit.NOTHING;
        private boolean myCommitSuccess;

        private CommitProcessor() {
            if (CommitHelper.this.myChangeList instanceof LocalChangeList) {
                LocalChangeList localList = (LocalChangeList)CommitHelper.this.myChangeList;
                boolean containsAll = CommitHelper.this.myIncludedChanges.containsAll(CommitHelper.this.myChangeList.getChanges());
                if (containsAll && !localList.isDefault() && !localList.isReadOnly()) {
                    this.myAfterVcsRefreshModification = ChangeListsModificationAfterCommit.DELETE_LIST;
                } else if (((CommitHelper)CommitHelper.this).myConfiguration.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT && !containsAll && localList.isDefault() && CommitHelper.this.myAllOfDefaultChangeListChangesIncluded) {
                    this.myAfterVcsRefreshModification = ChangeListsModificationAfterCommit.MOVE_OTHERS;
                }
            }
        }

        @Override
        public void callSelf() {
            ChangesUtil.processChangesByVcs((Project)CommitHelper.this.myProject, (Collection)CommitHelper.this.myIncludedChanges, (ChangesUtil.PerVcsProcessor)this);
        }

        public void process(AbstractVcs vcs, List<Change> items) {
            CheckinEnvironment environment = vcs.getCheckinEnvironment();
            if (environment != null) {
                List paths = ChangesUtil.getPaths(items);
                this.myPathsToRefresh.addAll(paths);
                if (environment.keepChangeListAfterCommit(CommitHelper.this.myChangeList)) {
                    this.myKeepChangeListAfterCommit = true;
                }
                Object addData = CommitHelper.this.myAdditionalData == null ? null : CommitHelper.this.myAdditionalData.get(vcs.getName());
                List exceptions = environment.commit(items, CommitHelper.this.myCommitMessage, addData);
                if (exceptions != null && exceptions.size() > 0) {
                    this.myVcsExceptions.addAll(exceptions);
                    this.myChangesFailedToCommit.addAll(items);
                }
            }
        }

        @Override
        public void afterSuccessfulCheckIn() {
            this.myCommitSuccess = true;
        }

        @Override
        public void afterFailedCheckIn() {
            CommitHelper.moveToFailedList(CommitHelper.this.myChangeList, CommitHelper.this.myCommitMessage, this.getChangesFailedToCommit(), VcsBundle.message((String)"commit.dialog.failed.commit.template", (Object[])new Object[]{CommitHelper.this.myChangeList.getName()}), CommitHelper.this.myProject);
        }

        @Override
        public void doBeforeRefresh() {
            ChangeListManagerImpl clManager = (ChangeListManagerImpl)ChangeListManager.getInstance((Project)CommitHelper.this.myProject);
            clManager.showLocalChangesInvalidated();
            this.myAction = (LocalHistoryAction)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LocalHistoryAction>(){

                public LocalHistoryAction compute() {
                    return LocalHistory.startAction((Project)CommitHelper.this.myProject, (String)CommitHelper.this.myActionName);
                }
            });
        }

        @Override
        public void customRefresh() {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setText(VcsBundle.message((String)"commit.dialog.refresh.files", (Object[])new Object[0]));
            }
            RefreshVFsSynchronously.updateChanges(CommitHelper.this.myIncludedChanges);
        }

        @Override
        public Runnable postRefresh() {
            return new Runnable(){

                @Override
                public void run() {
                    if (CommitProcessor.this.myAction != null) {
                        CommitProcessor.this.myAction.finish();
                    }
                    if (!CommitHelper.this.myProject.isDisposed()) {
                        final ChangeListManager clManager = ChangeListManager.getInstance((Project)CommitHelper.this.myProject);
                        clManager.invokeAfterUpdate(new Runnable(){

                            @Override
                            public void run() {
                                if (CommitProcessor.this.myCommitSuccess) {
                                    if (ChangeListsModificationAfterCommit.DELETE_LIST.equals((Object)CommitProcessor.this.myAfterVcsRefreshModification)) {
                                        if (!CommitProcessor.this.myKeepChangeListAfterCommit) {
                                            clManager.removeChangeList(CommitHelper.this.myChangeList.getName());
                                        }
                                    } else if (ChangeListsModificationAfterCommit.MOVE_OTHERS.equals((Object)CommitProcessor.this.myAfterVcsRefreshModification)) {
                                        ChangelistMoveOfferDialog dialog = new ChangelistMoveOfferDialog(CommitHelper.this.myConfiguration);
                                        dialog.show();
                                        if (dialog.isOK()) {
                                            Collection changes = clManager.getDefaultChangeList().getChanges();
                                            MoveChangesToAnotherListAction.askAndMove(CommitHelper.this.myProject, changes.toArray(new Change[changes.size()]), null);
                                        }
                                    }
                                }
                                CommittedChangesCache cache = CommittedChangesCache.getInstance(CommitHelper.this.myProject);
                                cache.refreshAllCachesAsync(false, true);
                                cache.refreshIncomingChangesAsync();
                            }
                        }, InvokeAfterUpdateMode.SILENT, null, (Consumer)new Consumer<VcsDirtyScopeManager>(){

                            public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                                for (FilePath path : CommitProcessor.this.myPathsToRefresh) {
                                    vcsDirtyScopeManager.fileDirty(path);
                                }
                            }
                        }, null);
                        LocalHistory.putSystemLabel((Project)CommitHelper.this.myProject, (String)(CommitHelper.this.myActionName + ": " + CommitHelper.this.myCommitMessage));
                    }
                }
            };
        }

        private void vcsRefresh() {
            for (FilePath path : this.myPathsToRefresh) {
                CommitHelper.this.myDirtyScopeManager.fileDirty(path);
            }
        }

        @Override
        public void doVcsRefresh() {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    CommitProcessor.this.vcsRefresh();
                }
            });
        }
    }

    private static enum ChangeListsModificationAfterCommit {
        DELETE_LIST,
        MOVE_OTHERS,
        NOTHING;

    }

    private static interface ActionsAroundRefresh {
        public void doBeforeRefresh();

        public void customRefresh();

        public void doVcsRefresh();

        public Runnable postRefresh();
    }

    private static abstract class GeneralCommitProcessor
    implements ChangesUtil.PerVcsProcessor<Change>,
    ActionsAroundRefresh {
        protected final List<FilePath> myPathsToRefresh = new ArrayList<FilePath>();
        protected final List<VcsException> myVcsExceptions = new ArrayList<VcsException>();
        protected final List<Change> myChangesFailedToCommit = new ArrayList<Change>();

        protected GeneralCommitProcessor() {
        }

        public abstract void callSelf();

        public abstract void afterSuccessfulCheckIn();

        public abstract void afterFailedCheckIn();

        public List<FilePath> getPathsToRefresh() {
            return this.myPathsToRefresh;
        }

        public List<VcsException> getVcsExceptions() {
            return this.myVcsExceptions;
        }

        public List<Change> getChangesFailedToCommit() {
            return this.myChangesFailedToCommit;
        }
    }

    private class AlienCommitProcessor
    extends GeneralCommitProcessor {
        private final AbstractVcs myVcs;

        private AlienCommitProcessor(AbstractVcs vcs) {
            this.myVcs = vcs;
        }

        @Override
        public void callSelf() {
            ChangesUtil.processItemsByVcs((Collection)CommitHelper.this.myIncludedChanges, (ChangesUtil.VcsSeparator)new ChangesUtil.VcsSeparator<Change>(){

                public AbstractVcs getVcsFor(Change item) {
                    return AlienCommitProcessor.this.myVcs;
                }
            }, (ChangesUtil.PerVcsProcessor)this);
        }

        public void process(AbstractVcs vcs, List<Change> items) {
            CheckinEnvironment environment;
            if (this.myVcs.getName().equals(vcs.getName()) && (environment = vcs.getCheckinEnvironment()) != null) {
                List paths = ChangesUtil.getPaths(items);
                this.myPathsToRefresh.addAll(paths);
                Object addData = CommitHelper.this.myAdditionalData == null ? null : CommitHelper.this.myAdditionalData.get(vcs.getName());
                List exceptions = environment.commit(items, CommitHelper.this.myCommitMessage, addData);
                if (exceptions != null && exceptions.size() > 0) {
                    this.myVcsExceptions.addAll(exceptions);
                    this.myChangesFailedToCommit.addAll(items);
                }
            }
        }

        @Override
        public void afterSuccessfulCheckIn() {
        }

        @Override
        public void afterFailedCheckIn() {
        }

        @Override
        public void doBeforeRefresh() {
        }

        @Override
        public void customRefresh() {
        }

        @Override
        public Runnable postRefresh() {
            return null;
        }

        @Override
        public void doVcsRefresh() {
        }
    }
}

