/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectBaseDirectory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PlatformVcsDetector
implements ProjectComponent {
    private final Project myProject;
    private final ProjectLevelVcsManagerImpl myVcsManager;

    public PlatformVcsDetector(Project project, ProjectLevelVcsManagerImpl vcsManager) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerStartupActivity(new Runnable(){

            @Override
            public void run() {
                VirtualFile file = ProjectBaseDirectory.getInstance(PlatformVcsDetector.this.myProject).getBaseDir(PlatformVcsDetector.this.myProject.getBaseDir());
                AbstractVcs vcs = PlatformVcsDetector.this.myVcsManager.findVersioningVcs(file);
                if (vcs != null && vcs != PlatformVcsDetector.this.myVcsManager.getVcsFor(file)) {
                    PlatformVcsDetector.this.myVcsManager.setAutoDirectoryMapping(file.getPath(), vcs.getName());
                    PlatformVcsDetector.this.myVcsManager.cleanupMappings();
                    PlatformVcsDetector.this.myVcsManager.updateActiveVcss();
                }
            }
        });
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("PlatformVcsDetector" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/platform/PlatformVcsDetector.getComponentName must not return null");
        }
        return "PlatformVcsDetector";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

