/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;

public class Helper {
    private final CodeStyleSettings mySettings;
    private final FileType myFileType;
    public static final int INDENT_FACTOR = 10000;
    public static final int TOO_BIG_WALK_THRESHOULD = 450;

    protected Helper(FileType fileType, Project project) {
        this.mySettings = CodeStyleSettingsManager.getSettings((Project)project);
        this.myFileType = fileType;
    }

    public int getIndent(ASTNode element) {
        return this.getIndent(element, false);
    }

    public int getIndent(ASTNode element, boolean includeNonSpace) {
        return this.getIndentInner(element, includeNonSpace, 0);
    }

    protected int getIndentInner(ASTNode element, boolean includeNonSpace, int recursionLevel) {
        if (recursionLevel > 450) {
            return 0;
        }
        if (element.getTreePrev() != null) {
            ASTNode parent;
            ASTNode prev = element.getTreePrev();
            while (prev instanceof CompositeElement && !TreeUtil.isStrongWhitespaceHolder(prev.getElementType())) {
                ASTNode lastCompositePrev = prev;
                if ((prev = prev.getLastChildNode()) != null) continue;
                return this.getIndentInner(lastCompositePrev, includeNonSpace, recursionLevel + 1);
            }
            String text = prev.getText();
            int index = Math.max(text.lastIndexOf(10), text.lastIndexOf(13));
            if (index >= 0) {
                return this.getIndent(text.substring(index + 1), includeNonSpace);
            }
            if (includeNonSpace) {
                return this.getIndentInner(prev, includeNonSpace, recursionLevel + 1) + this.getIndent(text, includeNonSpace);
            }
            ASTNode child = prev;
            for (parent = prev.getTreeParent(); parent != null && child.getTreePrev() == null; parent = parent.getTreeParent()) {
                child = parent;
            }
            if (parent == null) {
                return this.getIndent(text, includeNonSpace);
            }
            return this.getIndentInner(prev, includeNonSpace, recursionLevel + 1);
        }
        if (element.getTreeParent() == null) {
            return 0;
        }
        return this.getIndentInner(element.getTreeParent(), includeNonSpace, recursionLevel + 1);
    }

    public String fillIndent(int indent) {
        int indentLevel = (indent + 5000) / 10000;
        int spaceCount = indent - indentLevel * 10000;
        int indentLevelSize = indentLevel * this.mySettings.getIndentSize(this.getFileType());
        int totalSize = indentLevelSize + spaceCount;
        StringBuffer buffer = new StringBuffer();
        if (this.mySettings.useTabCharacter(this.getFileType())) {
            if (this.mySettings.isSmartTabs(this.getFileType())) {
                int i;
                int tabCount = indentLevelSize / this.mySettings.getTabSize(this.getFileType());
                int leftSpaces = indentLevelSize - tabCount * this.mySettings.getTabSize(this.getFileType());
                for (i = 0; i < tabCount; ++i) {
                    buffer.append('\t');
                }
                for (i = 0; i < leftSpaces + spaceCount; ++i) {
                    buffer.append(' ');
                }
            } else {
                int size = totalSize;
                while (size > 0) {
                    if (size >= this.mySettings.getTabSize(this.getFileType())) {
                        buffer.append('\t');
                        size -= this.mySettings.getTabSize(this.getFileType());
                        continue;
                    }
                    buffer.append(' ');
                    --size;
                }
            }
        } else {
            for (int i = 0; i < totalSize; ++i) {
                buffer.append(' ');
            }
        }
        return buffer.toString();
    }

    public int getIndent(String text, boolean includeNonSpace) {
        char c;
        for (int i = text.length() - 1; i >= 0 && (c = text.charAt(i)) != '\n' && c != '\r'; --i) {
        }
        int spaceCount = 0;
        int tabCount = 0;
        for (int j = ++i; j < text.length(); ++j) {
            char c2 = text.charAt(j);
            if (c2 != '\t') {
                if (!includeNonSpace && c2 != ' ') break;
                ++spaceCount;
                continue;
            }
            ++tabCount;
        }
        if (tabCount == 0) {
            return spaceCount;
        }
        int tabSize = this.mySettings.getTabSize(this.getFileType());
        int indentLevel = tabCount * tabSize / this.mySettings.getIndentSize(this.getFileType());
        return indentLevel * 10000 + spaceCount;
    }

    public FileType getFileType() {
        return this.myFileType;
    }
}

