/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.TokenSet;

public class AstBufferUtil {
    private AstBufferUtil() {
    }

    public static int toBuffer(ASTNode element, char[] buffer, int offset) {
        return AstBufferUtil.toBuffer(element, buffer, offset, null);
    }

    public static int toBuffer(ASTNode element, char[] buffer, int offset, TokenSet skipTypes) {
        LazyParseableElement lpe;
        int lpeResult;
        if (element instanceof ForeignLeafPsiElement || skipTypes != null && skipTypes.contains(element.getElementType())) {
            return offset;
        }
        if (element instanceof LeafElement) {
            return ((LeafElement)element).copyTo(buffer, offset);
        }
        if (element instanceof LazyParseableElement && (lpeResult = (lpe = (LazyParseableElement)element).copyTo(buffer, offset)) > 0) {
            return lpeResult;
        }
        int curOffset = offset;
        for (TreeElement child = (TreeElement)element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            curOffset = AstBufferUtil.toBuffer(child, buffer, curOffset, skipTypes);
        }
        return curOffset;
    }
}

