/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.fixtures.LightIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class LightIdeaTestFixtureImpl
extends BaseFixture
implements LightIdeaTestFixture {
    private final LightProjectDescriptor myProjectDescriptor;

    public LightIdeaTestFixtureImpl(LightProjectDescriptor projectDescriptor) {
        this.myProjectDescriptor = projectDescriptor;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        LightPlatformTestCase.initApplication(new MyDataProvider());
        LightPlatformTestCase.doSetup(this.myProjectDescriptor, new LocalInspectionTool[0], null);
        this.storeSettings();
    }

    @Override
    public void tearDown() throws Exception {
        CodeStyleSettingsManager.getInstance((Project)this.getProject()).dropTemporarySettings();
        this.checkForSettingsDamage();
        LightPlatformTestCase.doTearDown(this.getProject(), LightPlatformTestCase.getApplication(), true);
        super.tearDown();
    }

    @Override
    public Project getProject() {
        return LightPlatformTestCase.getProject();
    }

    @Override
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        return CodeStyleSettingsManager.getSettings((Project)this.getProject());
    }

    @Override
    public Module getModule() {
        return LightPlatformTestCase.getModule();
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.PROJECT.is(dataId)) {
                return LightIdeaTestFixtureImpl.this.getProject();
            }
            if (PlatformDataKeys.EDITOR.is(dataId) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                return FileEditorManager.getInstance((Project)LightIdeaTestFixtureImpl.this.getProject()).getSelectedTextEditor();
            }
            return null;
        }
    }
}

