/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementPresentation;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.EvaluatedXmlNameImpl;
import com.intellij.util.xml.impl.FileDescriptionCachedValueProvider;
import com.intellij.util.xml.impl.RootDomParentStrategy;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomFileElementImpl<T extends DomElement>
implements DomFileElement<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomFileElementImpl");
    private static final DomGenericInfo EMPTY_DOM_GENERIC_INFO = new DomGenericInfo(){

        @Nullable
        public XmlElement getNameElement(DomElement element) {
            return null;
        }

        @Nullable
        public GenericDomValue getNameDomElement(DomElement element) {
            return null;
        }

        @Nullable
        public CustomDomChildrenDescription getCustomNameChildrenDescription() {
            return null;
        }

        @Nullable
        public String getElementName(DomElement element) {
            return null;
        }

        @NotNull
        public List<DomChildrenDescription> getChildrenDescriptions() {
            List<DomChildrenDescription> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl$1.getChildrenDescriptions must not return null");
            }
            return list;
        }

        @NotNull
        public List<DomFixedChildDescription> getFixedChildrenDescriptions() {
            List<DomFixedChildDescription> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl$1.getFixedChildrenDescriptions must not return null");
            }
            return list;
        }

        @NotNull
        public List<DomCollectionChildDescription> getCollectionChildrenDescriptions() {
            List<DomCollectionChildDescription> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl$1.getCollectionChildrenDescriptions must not return null");
            }
            return list;
        }

        @NotNull
        public List<DomAttributeChildDescription> getAttributeChildrenDescriptions() {
            List<DomAttributeChildDescription> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl$1.getAttributeChildrenDescriptions must not return null");
            }
            return list;
        }

        public boolean isTagValueElement() {
            return false;
        }

        @Nullable
        public DomFixedChildDescription getFixedChildDescription(String tagName) {
            return null;
        }

        @Nullable
        public DomFixedChildDescription getFixedChildDescription(@NonNls String tagName, @NonNls String namespace) {
            return null;
        }

        @Nullable
        public DomCollectionChildDescription getCollectionChildDescription(String tagName) {
            return null;
        }

        @Nullable
        public DomCollectionChildDescription getCollectionChildDescription(@NonNls String tagName, @NonNls String namespace) {
            return null;
        }

        public DomAttributeChildDescription getAttributeChildDescription(String attributeName) {
            return null;
        }

        @Nullable
        public DomAttributeChildDescription getAttributeChildDescription(@NonNls String attributeName, @NonNls String namespace) {
            return null;
        }

        public Type[] getConcreteInterfaceVariants() {
            return new Class[]{DomFileElement.class};
        }
    };
    private final XmlFile myFile;
    private final DomFileDescription<T> myFileDescription;
    private final DomRootInvocationHandler myRootHandler;
    private final Class<T> myRootElementClass;
    private final EvaluatedXmlNameImpl myRootTagName;
    private final DomManagerImpl myManager;
    private final Map<Key, Object> myUserData = new HashMap<Key, Object>();

    protected DomFileElementImpl(XmlFile file, Class<T> rootElementClass, EvaluatedXmlNameImpl rootTagName, DomManagerImpl manager, DomFileDescription<T> fileDescription) {
        this.myFile = file;
        this.myRootElementClass = rootElementClass;
        this.myRootTagName = rootTagName;
        this.myManager = manager;
        this.myFileDescription = fileDescription;
        this.myRootHandler = new DomRootInvocationHandler(rootElementClass, new RootDomParentStrategy(this), this, rootTagName);
    }

    @NotNull
    public final XmlFile getFile() {
        XmlFile xmlFile = this.myFile;
        if (xmlFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getFile must not return null");
        }
        return xmlFile;
    }

    @NotNull
    public XmlFile getOriginalFile() {
        XmlFile xmlFile = (XmlFile)this.myFile.getOriginalFile();
        if (xmlFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getOriginalFile must not return null");
        }
        return xmlFile;
    }

    @Nullable
    public XmlTag getRootTag() {
        XmlTag tag;
        if (!this.myFile.isValid()) {
            return null;
        }
        XmlDocument document = this.myFile.getDocument();
        if (document != null && (tag = document.getRootTag()) != null) {
            if (tag.getTextLength() > 0 && this.getFileDescription().acceptsOtherRootTagNames()) {
                return tag;
            }
            if (this.myRootTagName.getXmlName().getLocalName().equals(tag.getLocalName()) && this.myRootTagName.isNamespaceAllowed(this, tag.getNamespace())) {
                return tag;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DomFileElementImpl)) {
            return false;
        }
        DomFileElementImpl that = (DomFileElementImpl)o;
        if (this.myFile != null ? !this.myFile.equals(that.myFile) : that.myFile != null) {
            return false;
        }
        if (this.myRootElementClass != null ? !this.myRootElementClass.equals(that.myRootElementClass) : that.myRootElementClass != null) {
            return false;
        }
        return !(this.myRootTagName != null ? !this.myRootTagName.equals(that.myRootTagName) : that.myRootTagName != null);
    }

    public int hashCode() {
        int result = this.myFile != null ? this.myFile.hashCode() : 0;
        result = 31 * result + (this.myRootElementClass != null ? this.myRootElementClass.hashCode() : 0);
        result = 31 * result + (this.myRootTagName != null ? this.myRootTagName.hashCode() : 0);
        return result;
    }

    @NotNull
    public final DomManagerImpl getManager() {
        DomManagerImpl domManagerImpl = this.myManager;
        if (domManagerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getManager must not return null");
        }
        return domManagerImpl;
    }

    public final Type getDomElementType() {
        return this.getClass();
    }

    @NotNull
    public AbstractDomChildrenDescription getChildDescription() {
        throw new UnsupportedOperationException("Method getChildDescription is not yet implemented in " + this.getClass().getName());
    }

    public DomNameStrategy getNameStrategy() {
        return this.getRootHandler().getNameStrategy();
    }

    @NotNull
    public ElementPresentation getPresentation() {
        DomElementPresentation domElementPresentation = new DomElementPresentation(){

            @NonNls
            public String getElementName() {
                return "<ROOT>";
            }

            @NonNls
            public String getTypeName() {
                return "<ROOT>";
            }

            public Icon getIcon() {
                return null;
            }
        };
        if (domElementPresentation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getPresentation must not return null");
        }
        return domElementPresentation;
    }

    public GlobalSearchScope getResolveScope() {
        return this.myFile.getResolveScope();
    }

    @Nullable
    public <T extends DomElement> T getParentOfType(Class<T> requiredClass, boolean strict) {
        return (T)(DomFileElement.class.isAssignableFrom(requiredClass) && !strict ? this : null);
    }

    public Module getModule() {
        return ModuleUtil.findModuleForPsiElement((PsiElement)this.getFile());
    }

    public void copyFrom(DomElement other) {
        throw new UnsupportedOperationException("Method copyFrom is not yet implemented in " + this.getClass().getName());
    }

    public final <T extends DomElement> T createMockCopy(boolean physical) {
        throw new UnsupportedOperationException("Method createMockCopy is not yet implemented in " + this.getClass().getName());
    }

    public final <T extends DomElement> T createStableCopy() {
        return this.myManager.createStableValue(new Factory<T>(){

            @Nullable
            public T create() {
                return DomFileElementImpl.this.myManager.getFileElement(DomFileElementImpl.this.myFile);
            }
        });
    }

    @NotNull
    public String getXmlElementNamespace() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getXmlElementNamespace must not return null");
        }
        return "";
    }

    @Nullable
    @NonNls
    public String getXmlElementNamespaceKey() {
        return null;
    }

    @NotNull
    public final T getRootElement() {
        if (!this.isValid()) {
            if (!this.myFile.isValid()) {
                assert (false) : this.myFile + " is not valid";
            } else {
                DomFileElement fileElement = this.myManager.getFileElement(this.myFile);
                if (fileElement == null) {
                    FileDescriptionCachedValueProvider provider = this.myManager.getOrCreateCachedValueProvider(this.myFile);
                    String s = provider.getFileElementWithLogging();
                    LOG.error("Null, log=" + s);
                } else assert (false) : this + " does not equal to " + fileElement;
            }
        }
        DomElement domElement = this.getRootHandler().getProxy();
        if (domElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getRootElement must not return null");
        }
        return (T)domElement;
    }

    @NotNull
    public Class<T> getRootElementClass() {
        Class<T> clazz = this.myRootElementClass;
        if (clazz == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getRootElementClass must not return null");
        }
        return clazz;
    }

    @NotNull
    public DomFileDescription<T> getFileDescription() {
        DomFileDescription<T> domFileDescription = this.myFileDescription;
        if (domFileDescription == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getFileDescription must not return null");
        }
        return domFileDescription;
    }

    @NotNull
    protected final DomRootInvocationHandler getRootHandler() {
        DomRootInvocationHandler domRootInvocationHandler = this.myRootHandler;
        if (domRootInvocationHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getRootHandler must not return null");
        }
        return domRootInvocationHandler;
    }

    @NonNls
    public String toString() {
        return "File " + this.myFile.toString();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    public final XmlTag getXmlTag() {
        return null;
    }

    @NotNull
    public <T extends DomElement> DomFileElementImpl<T> getRoot() {
        DomFileElementImpl domFileElementImpl = this;
        if (domFileElementImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getRoot must not return null");
        }
        return domFileElementImpl;
    }

    @Nullable
    public DomElement getParent() {
        return null;
    }

    public final XmlTag ensureTagExists() {
        return null;
    }

    public final XmlElement getXmlElement() {
        return this.getFile();
    }

    public final XmlElement ensureXmlElementExists() {
        return this.ensureTagExists();
    }

    public void undefine() {
    }

    public final boolean isValid() {
        return this.myFile.isValid() && this.equals(this.myManager.getFileElement(this.myFile));
    }

    @NotNull
    public final DomGenericInfo getGenericInfo() {
        DomGenericInfo domGenericInfo = EMPTY_DOM_GENERIC_INFO;
        if (domGenericInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getGenericInfo must not return null");
        }
        return domGenericInfo;
    }

    @NotNull
    public String getXmlElementName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomFileElementImpl.getXmlElementName must not return null");
        }
        return "";
    }

    public void accept(DomElementVisitor visitor) {
        this.myManager.getVisitorDescription(visitor.getClass()).acceptElement(visitor, (DomElement)this);
    }

    public void acceptChildren(DomElementVisitor visitor) {
        this.getRootElement().accept(visitor);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomFileElementImpl.getUserData must not be null");
        }
        return (T)this.myUserData.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomFileElementImpl.putUserData must not be null");
        }
        this.myUserData.put(key, value);
    }

    public final long getModificationCount() {
        return this.myFile.getModificationStamp();
    }
}

