/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlFileTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlStructureViewTreeModel;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.structure.DomStructureTreeElement;
import org.jetbrains.annotations.NotNull;

public class DomStructureViewTreeModel
extends XmlStructureViewTreeModel
implements Disposable {
    private final XmlFile myFile;
    private final DomElementNavigationProvider myNavigationProvider;
    private final Function<DomElement, DomService.StructureViewMode> myDescriptor;

    public DomStructureViewTreeModel(XmlFile file, Function<DomElement, DomService.StructureViewMode> descriptor) {
        this(file, DomElementsNavigationManager.getManager((Project)file.getProject()).getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME), descriptor);
    }

    public DomStructureViewTreeModel(XmlFile file, DomElementNavigationProvider navigationProvider, Function<DomElement, DomService.StructureViewMode> descriptor) {
        super(file);
        this.myFile = file;
        this.myNavigationProvider = navigationProvider;
        this.myDescriptor = descriptor;
    }

    @Override
    @NotNull
    public StructureViewTreeElement getRoot() {
        DomFileElement fileElement = DomManager.getDomManager((Project)this.myFile.getProject()).getFileElement(this.myFile, DomElement.class);
        Object object = fileElement == null ? new XmlFileTreeElement(this.myFile) : new DomStructureTreeElement(fileElement.getRootElement().createStableCopy(), this.myDescriptor, this.myNavigationProvider);
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/structure/DomStructureViewTreeModel.getRoot must not return null");
        }
        return object;
    }

    @Override
    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER};
        if (sorterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/structure/DomStructureViewTreeModel.getSorters must not return null");
        }
        return sorterArray;
    }

    @Override
    protected PsiFile getPsiFile() {
        return this.myFile;
    }
}

