/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointsTree<B extends XBreakpoint<?>>
extends CheckboxTree {
    private final TreeNodeComparator myComparator;
    private final CheckedTreeNode myRoot;
    private final Map<B, BreakpointNode<B>> myNodes = new HashMap<B, BreakpointNode<B>>();
    private List<XBreakpointGroupingRule<B, ?>> myGroupingRules;
    private final Map<XBreakpointGroup, BreakpointsGroupNode> myGroupNodes = new HashMap<XBreakpointGroup, BreakpointsGroupNode>();
    private final MultiValuesMap<XBreakpointGroupingRule<B, ?>, XBreakpointGroup> myGroups = new MultiValuesMap();

    private XBreakpointsTree(XBreakpointType<B, ?> type, CheckedTreeNode root, Collection<XBreakpointGroupingRule<B, ?>> groupingRules) {
        super(new BreakpointsTreeCellRenderer(), root);
        this.myRoot = root;
        this.myComparator = new TreeNodeComparator<B>(type);
        this.setGroupingRulesInternal(groupingRules);
    }

    private void setGroupingRulesInternal(Collection<XBreakpointGroupingRule<B, ?>> groupingRules) {
        this.myGroupingRules = new ArrayList(groupingRules);
        this.setShowsRootHandles(!groupingRules.isEmpty());
    }

    public static <B extends XBreakpoint<?>> XBreakpointsTree<B> createTree(XBreakpointType<B, ?> type, Collection<XBreakpointGroupingRule<B, ?>> groupingRules) {
        return new XBreakpointsTree<B>(type, new CheckedTreeNode(null), groupingRules);
    }

    public void buildTree(@NotNull Collection<? extends B> breakpoints) {
        if (breakpoints == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointsTree.buildTree must not be null");
        }
        this.myRoot.removeAllChildren();
        this.myNodes.clear();
        this.myGroupNodes.clear();
        this.myGroups.clear();
        for (XBreakpoint breakpoint : breakpoints) {
            BreakpointNode node = new BreakpointNode(breakpoint, null);
            CheckedTreeNode parent = this.getParentNode(breakpoint);
            parent.add(node);
            this.myNodes.put(breakpoint, node);
        }
        TreeUtil.sort((DefaultMutableTreeNode)this.myRoot, (Comparator)this.myComparator);
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged((TreeNode)this.myRoot);
        this.expandPath(new TreePath(this.myRoot));
    }

    @NotNull
    private CheckedTreeNode getParentNode(B breakpoint) {
        BreakpointsGroupNode<XBreakpointGroup> parent = this.myRoot;
        for (int i = 0; i < this.myGroupingRules.size(); ++i) {
            XBreakpointGroup group = this.getGroup(breakpoint, this.myGroupingRules.get(i));
            if (group == null) continue;
            parent = this.getOrCreateGroupNode(parent, group, i);
        }
        BreakpointsGroupNode<XBreakpointGroup> breakpointsGroupNode = parent;
        if (breakpointsGroupNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointsTree.getParentNode must not return null");
        }
        return breakpointsGroupNode;
    }

    private <G extends XBreakpointGroup> BreakpointsGroupNode<G> getOrCreateGroupNode(CheckedTreeNode parent, G group, int level) {
        BreakpointsGroupNode groupNode = this.myGroupNodes.get(group);
        if (groupNode == null) {
            groupNode = new BreakpointsGroupNode(group, level, null);
            this.myGroupNodes.put(group, groupNode);
            parent.add(groupNode);
        }
        return groupNode;
    }

    @Nullable
    private <G extends XBreakpointGroup> XBreakpointGroup getGroup(B breakpoint, XBreakpointGroupingRule<B, G> groupingRule) {
        XBreakpointGroup group;
        List groups = this.myGroups.get(groupingRule);
        if (groups == null) {
            groups = Collections.emptyList();
        }
        if ((group = groupingRule.getGroup(breakpoint, groups)) != null) {
            this.myGroups.put(groupingRule, (Object)group);
        }
        return group;
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
        if (node instanceof BreakpointNode) {
            ((BreakpointNode)node).getBreakpoint().setEnabled(node.isChecked());
        }
    }

    public void setGroupingRules(List<XBreakpointGroupingRule<B, ?>> groupingRules) {
        List<B> selectedBreakpoints = this.getSelectedBreakpoints();
        ArrayList<B> allBreakpoints = new ArrayList<B>(this.myNodes.keySet());
        this.setGroupingRulesInternal(groupingRules);
        this.buildTree(allBreakpoints);
        if (selectedBreakpoints.size() > 0) {
            this.selectBreakpoint((XBreakpoint)selectedBreakpoints.get(0));
        }
    }

    public List<B> getSelectedBreakpoints() {
        final ArrayList list = new ArrayList();
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return list;
        }
        for (TreePath selectionPath : selectionPaths) {
            TreeUtil.traverseDepth((TreeNode)((TreeNode)selectionPath.getLastPathComponent()), (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    if (node instanceof BreakpointNode) {
                        list.add(((BreakpointNode)((Object)node)).getBreakpoint());
                    }
                    return true;
                }
            });
        }
        return list;
    }

    public void selectBreakpoint(B breakpoint) {
        BreakpointNode<B> node = this.myNodes.get(breakpoint);
        if (node != null) {
            TreeUtil.selectNode((JTree)((Object)this), node);
        }
    }

    private static class TreeNodeComparator<B extends XBreakpoint<?>>
    implements Comparator<TreeNode> {
        private final Comparator<B> myBreakpointComparator;

        public TreeNodeComparator(XBreakpointType<B, ?> type) {
            this.myBreakpointComparator = type.getBreakpointComparator();
        }

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            if (o1 instanceof BreakpointNode && o2 instanceof BreakpointNode) {
                Object b1 = ((BreakpointNode)((Object)o1)).getBreakpoint();
                Object b2 = ((BreakpointNode)((Object)o2)).getBreakpoint();
                return this.myBreakpointComparator.compare(b1, b2);
            }
            if (o1 instanceof BreakpointsGroupNode && o2 instanceof BreakpointsGroupNode) {
                BreakpointsGroupNode group1 = (BreakpointsGroupNode)((Object)o1);
                BreakpointsGroupNode group2 = (BreakpointsGroupNode)((Object)o2);
                if (group1.getLevel() != group2.getLevel()) {
                    return group1.getLevel() - group2.getLevel();
                }
                return group1.getGroup().compareTo(group2.getGroup());
            }
            return o1 instanceof BreakpointsGroupNode ? -1 : 1;
        }
    }

    private static class BreakpointNode<B extends XBreakpoint<?>>
    extends CheckedTreeNode {
        private final B myBreakpoint;

        private BreakpointNode(B breakpoint) {
            super(null);
            this.myBreakpoint = breakpoint;
            this.setChecked(breakpoint.isEnabled());
        }

        public B getBreakpoint() {
            return this.myBreakpoint;
        }

        public Icon getIcon() {
            XBreakpointType type = this.myBreakpoint.getType();
            return this.isChecked() ? type.getEnabledIcon() : type.getDisabledIcon();
        }

        public SimpleTextAttributes getTextAttributes() {
            return this.isChecked() ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        }

        /* synthetic */ BreakpointNode(XBreakpoint x0, 1 x1) {
            this(x0);
        }
    }

    private static class BreakpointsGroupNode<G extends XBreakpointGroup>
    extends CheckedTreeNode {
        private final G myGroup;
        private final int myLevel;

        private BreakpointsGroupNode(G group, int level) {
            super(null);
            this.myLevel = level;
            this.setChecked(false);
            this.myGroup = group;
        }

        public G getGroup() {
            return this.myGroup;
        }

        public int getLevel() {
            return this.myLevel;
        }

        /* synthetic */ BreakpointsGroupNode(XBreakpointGroup x0, int x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class BreakpointsTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private BreakpointsTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof BreakpointNode) {
                BreakpointNode node = (BreakpointNode)((Object)value);
                Object breakpoint = node.getBreakpoint();
                String text = XBreakpointUtil.getDisplayText(breakpoint);
                this.getTextRenderer().setIcon(node.getIcon());
                this.getTextRenderer().append(text, node.getTextAttributes());
            } else if (value instanceof BreakpointsGroupNode) {
                Object group = ((BreakpointsGroupNode)((Object)value)).getGroup();
                this.getTextRenderer().setIcon(group.getIcon(expanded));
                this.getTextRenderer().append(group.getName(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
            }
        }
    }
}

