/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.ExternalDocumentValidator;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.SimpleTypeDescriptor;
import com.intellij.xml.impl.schema.StdTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorByType;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSTypeDescriptorProvider;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNSDescriptorImpl
implements XmlNSDescriptor,
Validator<XmlDocument>,
DumbAware,
XmlNSTypeDescriptorProvider {
    @NonNls
    private static final Set<String> STD_TYPES = new HashSet<String>();
    private static final Set<String> UNDECLARED_STD_TYPES = new HashSet<String>();
    private XmlFile myFile;
    private XmlTag myTag;
    private String myTargetNamespace;
    @NonNls
    public static final String XSD_PREFIX = "xsd";
    @NonNls
    static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    static final String ATTRIBUTE_TAG_NAME = "attribute";
    @NonNls
    static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    @NonNls
    static final String SEQUENCE_TAG_NAME = "sequence";
    @NonNls
    static final String SCHEMA_TAG_NAME = "schema";
    @NonNls
    private static final String INCLUDE_TAG_NAME = "include";
    @NonNls
    private static final String IMPORT_TAG_NAME = "import";
    @NonNls
    private static final String REDEFINE_TAG_NAME = "redefine";
    private Object[] dependencies;
    private static final ThreadLocal<Set<PsiFile>> myRedefinedDescriptorsInProcessing = new ThreadLocal();
    private final Map<QNameKey, CachedValue<XmlElementDescriptor>> myDescriptorsMap = Collections.synchronizedMap(new HashMap());
    private final Map<Pair<QNameKey, XmlTag>, CachedValue<TypeDescriptor>> myTypesMap = Collections.synchronizedMap(new HashMap());
    private Map<String, List<XmlTag>> mySubstitutions;

    public XmlNSDescriptorImpl(XmlFile file) {
        this.init((PsiElement)file.getDocument());
    }

    public XmlNSDescriptorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectDependencies(@Nullable XmlTag myTag, @NotNull XmlFile myFile, @NotNull Set<PsiFile> visited) {
        XmlTag[] tags;
        if (myFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/impl/schema/XmlNSDescriptorImpl.collectDependencies must not be null");
        }
        if (visited == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xml/impl/schema/XmlNSDescriptorImpl.collectDependencies must not be null");
        }
        if (visited.contains(myFile)) {
            return;
        }
        visited.add((PsiFile)myFile);
        if (myTag == null) {
            return;
        }
        for (XmlTag tag : tags = myTag.getSubTags()) {
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, IMPORT_TAG_NAME)) {
                XmlAttribute schemaLocation = tag.getAttribute("schemaLocation", null);
                if (schemaLocation == null) continue;
                XmlFile xmlFile = XmlUtil.findNamespaceByLocation((PsiFile)myFile, schemaLocation.getValue());
                XmlNSDescriptorImpl.addDependency(xmlFile, visited);
                continue;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, REDEFINE_TAG_NAME)) continue;
            myRedefinedDescriptorsInProcessing.set(visited);
            try {
                XmlFile file = XmlNSDescriptorImpl.getRedefinedElementDescriptorFile(tag);
                XmlNSDescriptorImpl.addDependency(file, visited);
            }
            finally {
                myRedefinedDescriptorsInProcessing.set(null);
            }
        }
        String schemaLocationDeclaration = myTag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        if (schemaLocationDeclaration != null) {
            StringTokenizer tokenizer = new StringTokenizer(schemaLocationDeclaration);
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                PsiFile resourceLocation = ExternalResourceManager.getInstance().getResourceLocation(tokenizer.nextToken(), (PsiFile)myFile, null);
                if (resourceLocation == null && uri != null) {
                    resourceLocation = ExternalResourceManager.getInstance().getResourceLocation(uri, (PsiFile)myFile, null);
                }
                if (!(resourceLocation instanceof XmlFile)) continue;
                XmlNSDescriptorImpl.addDependency((XmlFile)resourceLocation, visited);
            }
        }
    }

    private static void addDependency(XmlFile file, Set<PsiFile> visited) {
        if (file != null) {
            XmlDocument document = file.getDocument();
            XmlNSDescriptorImpl.collectDependencies(document != null ? document.getRootTag() : null, file, visited);
        }
    }

    public XmlFile getDescriptorFile() {
        return this.myFile;
    }

    public boolean isHierarhyEnabled() {
        return true;
    }

    public String getDefaultNamespace() {
        return this.myTargetNamespace != null ? this.myTargetNamespace : "";
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        return this.getElementDescriptor(localName, namespace, new HashSet<XmlNSDescriptorImpl>(), false);
    }

    public XmlElementDescriptor getElementDescriptor(String localName, String namespace, Set<XmlNSDescriptorImpl> visited, boolean reference) {
        XmlElementDescriptor value;
        if (visited.contains(this)) {
            return null;
        }
        final QNameKey pair = new QNameKey(namespace, localName);
        CachedValue<XmlElementDescriptor> descriptor = this.myDescriptorsMap.get((Object)pair);
        if (descriptor != null && ((value = (XmlElementDescriptor)descriptor.getValue()) == null || value.getDeclaration().isValid())) {
            return value;
        }
        XmlTag rootTag = this.myTag;
        if (rootTag == null) {
            return null;
        }
        XmlTag[] tags = rootTag.getSubTags();
        visited.add(this);
        for (final XmlTag tag : tags) {
            XmlElementDescriptor xmlElementDescriptor;
            XmlNSDescriptorImpl nsDescriptor;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, ELEMENT_TAG_NAME)) {
                String name = tag.getAttributeValue("name");
                if (name == null || !this.checkElementNameEquivalence(localName, namespace, name, tag)) continue;
                CachedValue cachedValue = CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlElementDescriptor>(){

                    public CachedValueProvider.Result<XmlElementDescriptor> compute() {
                        String name = tag.getAttributeValue("name");
                        if (name != null && !name.equals(pair.second)) {
                            XmlNSDescriptorImpl.this.myDescriptorsMap.remove((Object)pair);
                            return new CachedValueProvider.Result(null, new Object[0]);
                        }
                        XmlElementDescriptor xmlElementDescriptor = XmlNSDescriptorImpl.this.createElementDescriptor(tag);
                        return new CachedValueProvider.Result((Object)xmlElementDescriptor, xmlElementDescriptor.getDependences());
                    }
                }, false);
                this.myDescriptorsMap.put(pair, (CachedValue<XmlElementDescriptor>)cachedValue);
                return (XmlElementDescriptor)cachedValue.getValue();
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) || reference && XmlNSDescriptorImpl.equalsToSchemaName(tag, IMPORT_TAG_NAME) && (namespace.equals(tag.getAttributeValue("namespace")) || namespace.length() == 0 && tag.getAttributeValue("namespace") == null)) {
                XmlElementDescriptor elementDescriptor;
                PsiMetaData data;
                XmlDocument includedDocument;
                XmlFile xmlFile;
                XmlAttribute schemaLocation = tag.getAttribute("schemaLocation", null);
                if (schemaLocation == null || (xmlFile = XmlUtil.findNamespaceByLocation(rootTag.getContainingFile(), schemaLocation.getValue())) == null || (includedDocument = xmlFile.getDocument()) == null || !((data = includedDocument.getMetaData()) instanceof XmlNSDescriptorImpl) || (elementDescriptor = ((XmlNSDescriptorImpl)data).getElementDescriptor(localName, namespace, visited, reference)) == null) continue;
                return elementDescriptor;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, REDEFINE_TAG_NAME) || (nsDescriptor = XmlNSDescriptorImpl.getRedefinedElementDescriptor(tag)) == null || (xmlElementDescriptor = nsDescriptor.getElementDescriptor(localName, namespace, visited, reference)) == null) continue;
            return xmlElementDescriptor;
        }
        return null;
    }

    protected XmlElementDescriptor createElementDescriptor(XmlTag tag) {
        return new XmlElementDescriptorImpl(tag);
    }

    private boolean checkElementNameEquivalence(String localName, String namespace, String fqn, XmlTag context) {
        String localAttrName = XmlUtil.findLocalNameByQualifiedName(fqn);
        if (!localAttrName.equals(localName)) {
            return false;
        }
        String attrNamespace = context.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(fqn));
        if (attrNamespace.equals(namespace)) {
            return true;
        }
        if (this.myTargetNamespace == null) {
            return "".equals(attrNamespace);
        }
        boolean b = this.myTargetNamespace.equals(namespace);
        if (b) {
            return b;
        }
        return context.getNSDescriptor(namespace, true) == this;
    }

    @Nullable
    public XmlAttributeDescriptor getAttribute(String localName, String namespace, XmlTag context) {
        return this.getAttributeImpl(localName, namespace, null);
    }

    @Nullable
    private XmlAttributeDescriptor getAttributeImpl(String localName, String namespace, Set<XmlTag> visited) {
        XmlTag[] tags;
        if (this.myTag == null) {
            return null;
        }
        XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)this.myTag.getNSDescriptor(namespace, true);
        if (nsDescriptor != this && nsDescriptor != null) {
            return nsDescriptor.getAttributeImpl(localName, namespace, visited);
        }
        if (visited == null) {
            visited = new HashSet<XmlTag>(1);
        } else if (visited.contains(this.myTag)) {
            return null;
        }
        visited.add(this.myTag);
        for (XmlTag tag : tags = this.myTag.getSubTags()) {
            XmlAttributeDescriptor attributeDescriptor;
            PsiMetaData data;
            XmlDocument includedDocument;
            XmlFile xmlFile;
            XmlAttribute schemaLocation;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, ATTRIBUTE_TAG_NAME)) {
                String name = tag.getAttributeValue("name");
                if (name == null || !this.checkElementNameEquivalence(localName, namespace, name, tag)) continue;
                return this.createAttributeDescriptor(tag);
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) && (!XmlNSDescriptorImpl.equalsToSchemaName(tag, IMPORT_TAG_NAME) || !namespace.equals(tag.getAttributeValue("namespace"))) || (schemaLocation = tag.getAttribute("schemaLocation", null)) == null || (xmlFile = XmlUtil.findNamespaceByLocation(this.myTag.getContainingFile(), schemaLocation.getValue())) == null || (includedDocument = xmlFile.getDocument()) == null || !((data = includedDocument.getMetaData()) instanceof XmlNSDescriptorImpl) || (attributeDescriptor = ((XmlNSDescriptorImpl)data).getAttributeImpl(localName, namespace, visited)) == null) continue;
            CachedValue value = CachedValuesManager.getManager((Project)includedDocument.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlAttributeDescriptor>(){

                public CachedValueProvider.Result<XmlAttributeDescriptor> compute() {
                    return new CachedValueProvider.Result((Object)attributeDescriptor, attributeDescriptor.getDependences());
                }
            }, false);
            return (XmlAttributeDescriptor)value.getValue();
        }
        return null;
    }

    protected XmlAttributeDescriptorImpl createAttributeDescriptor(XmlTag tag) {
        return new XmlAttributeDescriptorImpl(tag);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(XmlTag descriptorTag) {
        String type = descriptorTag.getAttributeValue("type");
        if (type != null) {
            return this.getTypeDescriptor(type, descriptorTag);
        }
        return this.findTypeDescriptorImpl(descriptorTag, null, null, null);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String name, XmlTag context) {
        String localNameByQualifiedName;
        if (this.checkSchemaNamespace(name, context) && STD_TYPES.contains(localNameByQualifiedName = XmlUtil.findLocalNameByQualifiedName(name)) && (name.length() == localNameByQualifiedName.length() || UNDECLARED_STD_TYPES.contains(localNameByQualifiedName))) {
            return new StdTypeDescriptor(localNameByQualifiedName);
        }
        return this.findTypeDescriptor(name, context);
    }

    public XmlElementDescriptor getDescriptorByType(String qName, XmlTag instanceTag) {
        if (this.myTag == null) {
            return null;
        }
        TypeDescriptor typeDescriptor = this.findTypeDescriptor(qName, instanceTag);
        if (!(typeDescriptor instanceof ComplexTypeDescriptor)) {
            return null;
        }
        return new XmlElementDescriptorByType(instanceTag, (ComplexTypeDescriptor)typeDescriptor);
    }

    private boolean checkSchemaNamespace(String name, XmlTag context) {
        String namespace = context.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(name));
        if (namespace != null && namespace.length() > 0) {
            return XmlNSDescriptorImpl.checkSchemaNamespace(namespace);
        }
        return XSD_PREFIX.equals(XmlUtil.findPrefixByQualifiedName(name));
    }

    private static boolean checkSchemaNamespace(String namespace) {
        return "http://www.w3.org/2001/XMLSchema".equals(namespace) || "http://www.w3.org/1999/XMLSchema".equals(namespace) || "http://www.w3.org/2000/10/XMLSchema".equals(namespace);
    }

    static boolean checkSchemaNamespace(XmlTag context) {
        String namespace = context.getNamespace();
        if (namespace != null && namespace.length() > 0) {
            return XmlNSDescriptorImpl.checkSchemaNamespace(namespace);
        }
        return StringUtil.startsWithConcatenationOf((String)context.getName(), (String)XSD_PREFIX, (String)":");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    static XmlNSDescriptorImpl getNSDescriptorToSearchIn(XmlTag rootTag, String name, XmlNSDescriptorImpl defaultNSDescriptor) {
        String namespace;
        XmlNSDescriptor nsDescriptor;
        XmlNSDescriptorImpl xmlNSDescriptorImpl;
        if (name == null) {
            xmlNSDescriptorImpl = defaultNSDescriptor;
            if (xmlNSDescriptorImpl == null) throw new IllegalStateException("@NotNull method com/intellij/xml/impl/schema/XmlNSDescriptorImpl.getNSDescriptorToSearchIn must not return null");
            return xmlNSDescriptorImpl;
        }
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(name);
        if (namespacePrefix != null && namespacePrefix.length() > 0 && (nsDescriptor = rootTag.getNSDescriptor(namespace = rootTag.getNamespaceByPrefix(namespacePrefix), true)) instanceof XmlNSDescriptorImpl) {
            xmlNSDescriptorImpl = (XmlNSDescriptorImpl)nsDescriptor;
            if (xmlNSDescriptorImpl == null) throw new IllegalStateException("@NotNull method com/intellij/xml/impl/schema/XmlNSDescriptorImpl.getNSDescriptorToSearchIn must not return null");
            return xmlNSDescriptorImpl;
        }
        xmlNSDescriptorImpl = defaultNSDescriptor;
        if (xmlNSDescriptorImpl != null) return xmlNSDescriptorImpl;
        throw new IllegalStateException("@NotNull method com/intellij/xml/impl/schema/XmlNSDescriptorImpl.getNSDescriptorToSearchIn must not return null");
    }

    @Nullable
    protected TypeDescriptor findTypeDescriptor(String qname) {
        return this.findTypeDescriptor(qname, this.myTag);
    }

    @Nullable
    protected TypeDescriptor findTypeDescriptor(String qname, XmlTag context) {
        String namespace = context.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(qname));
        return this.findTypeDescriptor(XmlUtil.findLocalNameByQualifiedName(qname), namespace);
    }

    @Nullable
    private TypeDescriptor findTypeDescriptor(String localName, String namespace) {
        return this.findTypeDescriptorImpl(this.myTag, localName, namespace, null);
    }

    @Nullable
    protected TypeDescriptor findTypeDescriptorImpl(XmlTag rootTag, String name, String namespace, Set<XmlTag> visited) {
        TypeDescriptor value;
        Pair pair;
        CachedValue<TypeDescriptor> descriptor;
        XmlNSDescriptor nsDescriptor;
        XmlNSDescriptorImpl responsibleDescriptor = this;
        if (namespace != null && namespace.length() != 0 && !namespace.equals(this.getDefaultNamespace()) && (nsDescriptor = rootTag.getNSDescriptor(namespace, true)) instanceof XmlNSDescriptorImpl) {
            responsibleDescriptor = (XmlNSDescriptorImpl)nsDescriptor;
        }
        if (responsibleDescriptor != this) {
            return responsibleDescriptor.findTypeDescriptor(XmlUtil.findLocalNameByQualifiedName(name));
        }
        if (rootTag == null) {
            return null;
        }
        if (visited != null) {
            if (visited.contains(rootTag)) {
                return null;
            }
            visited.add(rootTag);
        }
        if ((descriptor = this.myTypesMap.get(pair = new Pair((Object)new QNameKey(name, namespace), (Object)rootTag))) != null && ((value = (TypeDescriptor)descriptor.getValue()) == null || value instanceof ComplexTypeDescriptor && ((ComplexTypeDescriptor)value).getDeclaration().isValid())) {
            return value;
        }
        XmlTag[] tags = rootTag.getSubTags();
        if (visited == null) {
            visited = new HashSet<XmlTag>(1);
            visited.add(rootTag);
        }
        return this.doFindIn(tags, name, namespace, (Pair<QNameKey, XmlTag>)pair, rootTag, visited);
    }

    private TypeDescriptor doFindIn(XmlTag[] tags, final String name, final String namespace, final Pair<QNameKey, XmlTag> pair, XmlTag rootTag, Set<XmlTag> visited) {
        for (final XmlTag tag : tags) {
            XmlTag redefinedRootTag;
            CachedValue<TypeDescriptor> cachedValue;
            String nameAttribute;
            CachedValue<TypeDescriptor> value;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, COMPLEX_TYPE_TAG_NAME)) {
                if (name == null) {
                    value = this.createAndPutTypesCachedValue(tag, pair);
                    return (TypeDescriptor)value.getValue();
                }
                nameAttribute = tag.getAttributeValue("name");
                if (!this.isSameName(name, namespace, nameAttribute)) continue;
                cachedValue = this.createAndPutTypesCachedValue(tag, pair);
                return (TypeDescriptor)cachedValue.getValue();
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "simpleType")) {
                if (name == null) {
                    value = this.createAndPutTypesCachedValueSimpleType(tag, pair);
                    return (TypeDescriptor)value.getValue();
                }
                nameAttribute = tag.getAttributeValue("name");
                if (!this.isSameName(name, namespace, nameAttribute)) continue;
                cachedValue = this.createAndPutTypesCachedValue(tag, pair);
                return (TypeDescriptor)cachedValue.getValue();
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, IMPORT_TAG_NAME) && (namespace == null || !namespace.equals(this.getDefaultNamespace()))) {
                XmlDocument document;
                XmlFile xmlFile;
                String schemaLocation = tag.getAttributeValue("schemaLocation");
                if (schemaLocation == null || (xmlFile = XmlUtil.findNamespaceByLocation(rootTag.getContainingFile(), schemaLocation)) == null || (document = xmlFile.getDocument()) == null) continue;
                final Set<XmlTag> visited1 = visited;
                CachedValue value2 = CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<TypeDescriptor>(){

                    public CachedValueProvider.Result<TypeDescriptor> compute() {
                        String currentName = tag.getAttributeValue("name");
                        if (currentName != null && !currentName.equals(XmlUtil.findLocalNameByQualifiedName(name)) || !xmlFile.isValid() || xmlFile.getDocument() == null) {
                            XmlNSDescriptorImpl.this.myTypesMap.remove(pair);
                            return new CachedValueProvider.Result(null, new Object[0]);
                        }
                        XmlDocument document = xmlFile.getDocument();
                        XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.this.findNSDescriptor(tag, document);
                        if (nsDescriptor == null) {
                            XmlNSDescriptorImpl.this.myTypesMap.remove(pair);
                            return new CachedValueProvider.Result(null, new Object[0]);
                        }
                        XmlTag rTag = document.getRootTag();
                        TypeDescriptor complexTypeDescriptor = nsDescriptor.findTypeDescriptorImpl(rTag, name, namespace, visited1);
                        return new CachedValueProvider.Result((Object)complexTypeDescriptor, new Object[]{rTag});
                    }
                }, false);
                if (value2.getValue() == null) continue;
                this.myTypesMap.put(pair, (CachedValue<TypeDescriptor>)value2);
                return (TypeDescriptor)value2.getValue();
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, REDEFINE_TAG_NAME)) continue;
            XmlTag[] subTags = tag.getSubTags();
            TypeDescriptor descriptor = this.doFindIn(subTags, name, namespace, pair, rootTag, visited);
            if (descriptor != null) {
                return descriptor;
            }
            XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getRedefinedElementDescriptor(tag);
            if (nsDescriptor == null || (descriptor = this.doFindIn((redefinedRootTag = ((XmlDocument)nsDescriptor.getDeclaration()).getRootTag()).getSubTags(), name, namespace, pair, redefinedRootTag, visited)) == null) continue;
            return descriptor;
        }
        return null;
    }

    private boolean isSameName(@NotNull String name, String namespace, String nameAttribute) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/schema/XmlNSDescriptorImpl.isSameName must not be null");
        }
        return nameAttribute != null && (nameAttribute.equals(name) || name.indexOf(":") >= 0 && nameAttribute.equals(name.substring(name.indexOf(":") + 1))) && (namespace == null || namespace.length() == 0 || namespace.equals(this.getDefaultNamespace()));
    }

    private XmlNSDescriptorImpl findNSDescriptor(XmlTag tag, XmlDocument document) {
        XmlNSDescriptor importedDescriptor;
        XmlNSDescriptorImpl nsDescriptor = IMPORT_TAG_NAME.equals(tag.getLocalName()) ? ((importedDescriptor = (XmlNSDescriptor)document.getMetaData()) instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)importedDescriptor : this) : this;
        return nsDescriptor;
    }

    private CachedValue<TypeDescriptor> createAndPutTypesCachedValueSimpleType(final XmlTag tag, Pair<QNameKey, XmlTag> pair) {
        CachedValue value = CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<TypeDescriptor>(){

            public CachedValueProvider.Result<TypeDescriptor> compute() {
                SimpleTypeDescriptor simpleTypeDescriptor = new SimpleTypeDescriptor(tag);
                return new CachedValueProvider.Result((Object)simpleTypeDescriptor, new Object[]{tag});
            }
        }, false);
        this.myTypesMap.put(pair, (CachedValue<TypeDescriptor>)value);
        return value;
    }

    private CachedValue<TypeDescriptor> createAndPutTypesCachedValue(final XmlTag tag, final Pair<QNameKey, XmlTag> pair) {
        CachedValue value = CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<TypeDescriptor>(){

            public CachedValueProvider.Result<TypeDescriptor> compute() {
                String name = tag.getAttributeValue("name");
                if (name != null && pair.first != null && ((QNameKey)((Object)pair.first)).first != null && !name.equals(XmlUtil.findLocalNameByQualifiedName((String)((QNameKey)((Object)pair.first)).first))) {
                    XmlNSDescriptorImpl.this.myTypesMap.remove(pair);
                    return new CachedValueProvider.Result(null, new Object[0]);
                }
                ComplexTypeDescriptor complexTypeDescriptor = new ComplexTypeDescriptor(XmlNSDescriptorImpl.this, tag);
                return new CachedValueProvider.Result((Object)complexTypeDescriptor, new Object[]{tag});
            }
        }, false);
        this.myTypesMap.put(pair, (CachedValue<TypeDescriptor>)value);
        return value;
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/schema/XmlNSDescriptorImpl.getElementDescriptor must not be null");
        }
        PsiElement parent = tag.getParent();
        String namespace = tag.getNamespace();
        while (parent instanceof XmlTag && !namespace.equals(((XmlTag)parent).getNamespace())) {
            parent = parent.getContext();
        }
        if (parent instanceof XmlTag) {
            XmlTag parentTag = (XmlTag)parent;
            XmlElementDescriptor parentDescriptor = parentTag.getDescriptor();
            if (parentDescriptor != null) {
                XmlElementDescriptor elementDescriptor;
                XmlElementDescriptor elementDescriptorFromParent = parentDescriptor.getElementDescriptor(tag, parentTag);
                if (elementDescriptorFromParent == null) {
                    elementDescriptorFromParent = XmlNSDescriptorImpl.getDescriptorFromParent(tag, elementDescriptorFromParent);
                }
                if (elementDescriptorFromParent instanceof AnyXmlElementDescriptor && (elementDescriptor = this.getElementDescriptor(tag.getLocalName(), namespace)) != null) {
                    return elementDescriptor;
                }
                return elementDescriptorFromParent;
            }
            return null;
        }
        XmlElementDescriptor elementDescriptor = this.getElementDescriptor(tag.getLocalName(), tag.getNamespace());
        if (elementDescriptor == null) {
            elementDescriptor = XmlNSDescriptorImpl.getDescriptorFromParent(tag, elementDescriptor);
        }
        return elementDescriptor;
    }

    private static XmlElementDescriptor getDescriptorFromParent(XmlTag tag, XmlElementDescriptor elementDescriptor) {
        XmlElementDescriptor descriptor;
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag && (descriptor = ((XmlTag)parent).getDescriptor()) != null) {
            elementDescriptor = descriptor.getElementDescriptor(tag, (XmlTag)parent);
        }
        return elementDescriptor;
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        class CollectElementsProcessor
        implements PsiElementProcessor<XmlTag> {
            final List<XmlElementDescriptor> result = new ArrayList<XmlElementDescriptor>();

            CollectElementsProcessor() {
            }

            public boolean execute(XmlTag element) {
                this.result.add(XmlNSDescriptorImpl.this.getElementDescriptor(element.getAttributeValue("name"), XmlNSDescriptorImpl.this.getDefaultNamespace()));
                return true;
            }
        }
        CollectElementsProcessor processor = new CollectElementsProcessor(){
            {
            }

            @Override
            public boolean execute(XmlTag element) {
                if (!XmlElementDescriptorImpl.isAbstractDeclaration(element).booleanValue()) {
                    return super.execute(element);
                }
                return true;
            }
        };
        this.processTagsInNamespace(this.myTag, new String[]{ELEMENT_TAG_NAME}, processor);
        XmlElementDescriptor[] xmlElementDescriptorArray = processor.result.toArray(new XmlElementDescriptor[processor.result.size()]);
        if (xmlElementDescriptorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/impl/schema/XmlNSDescriptorImpl.getRootElementsDescriptors must not return null");
        }
        return xmlElementDescriptorArray;
    }

    public XmlAttributeDescriptor[] getRootAttributeDescriptors(XmlTag context) {
        class CollectAttributesProcessor
        implements PsiElementProcessor<XmlTag> {
            final List<XmlAttributeDescriptor> result = new ArrayList<XmlAttributeDescriptor>();

            CollectAttributesProcessor() {
            }

            public boolean execute(XmlTag element) {
                this.result.add(XmlNSDescriptorImpl.this.createAttributeDescriptor(element));
                return true;
            }
        }
        CollectAttributesProcessor processor = new CollectAttributesProcessor();
        this.processTagsInNamespace(this.myTag, new String[]{ATTRIBUTE_TAG_NAME}, processor);
        return processor.result.toArray(new XmlAttributeDescriptor[processor.result.size()]);
    }

    public boolean processTagsInNamespace(@NotNull XmlTag rootTag, String[] tagNames, PsiElementProcessor<XmlTag> processor) {
        if (rootTag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/schema/XmlNSDescriptorImpl.processTagsInNamespace must not be null");
        }
        return XmlNSDescriptorImpl.processTagsInNamespaceInner(rootTag, tagNames, processor, null);
    }

    private static boolean processTagsInNamespaceInner(@NotNull XmlTag rootTag, String[] tagNames, PsiElementProcessor<XmlTag> processor, Set<XmlTag> visitedTags) {
        XmlTag[] tags;
        if (rootTag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/schema/XmlNSDescriptorImpl.processTagsInNamespaceInner must not be null");
        }
        if (visitedTags == null) {
            visitedTags = new HashSet<XmlTag>(3);
        } else if (visitedTags.contains(rootTag)) {
            return true;
        }
        visitedTags.add(rootTag);
        block0: for (XmlTag tag : tags = rootTag.getSubTags()) {
            XmlDocument includedDocument;
            XmlFile xmlFile;
            String schemaLocation;
            for (String tagName : tagNames) {
                if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, tagName)) continue;
                String name = tag.getAttributeValue("name");
                if (name == null || processor.execute((PsiElement)tag)) continue block0;
                return false;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) || (schemaLocation = tag.getAttributeValue("schemaLocation")) == null || (xmlFile = XmlUtil.findNamespaceByLocation(rootTag.getContainingFile(), schemaLocation)) == null || (includedDocument = xmlFile.getDocument()) == null || XmlNSDescriptorImpl.processTagsInNamespaceInner(includedDocument.getRootTag(), tagNames, processor, visitedTags)) continue;
            return false;
        }
        return true;
    }

    protected static boolean equalsToSchemaName(XmlTag tag, @NonNls String schemaName) {
        return schemaName.equals(tag.getLocalName()) && XmlNSDescriptorImpl.checkSchemaNamespace(tag);
    }

    @Nullable
    private static XmlTag findSpecialTag(@NonNls String name, @NonNls String specialName, XmlTag rootTag, XmlNSDescriptorImpl descriptor, HashSet<XmlTag> visited) {
        XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getNSDescriptorToSearchIn(rootTag, name, descriptor);
        if (nsDescriptor != descriptor) {
            XmlDocument document;
            XmlDocument xmlDocument = document = nsDescriptor.getDescriptorFile() != null ? nsDescriptor.getDescriptorFile().getDocument() : null;
            if (document == null) {
                return null;
            }
            return XmlNSDescriptorImpl.findSpecialTag(XmlUtil.findLocalNameByQualifiedName(name), specialName, document.getRootTag(), nsDescriptor, visited);
        }
        if (visited == null) {
            visited = new HashSet(1);
        } else if (visited.contains(rootTag)) {
            return null;
        }
        visited.add(rootTag);
        XmlTag[] tags = rootTag.getSubTags();
        return XmlNSDescriptorImpl.findSpecialTagIn(tags, specialName, name, rootTag, descriptor, visited);
    }

    private static XmlTag findSpecialTagIn(XmlTag[] tags, String specialName, String name, XmlTag rootTag, XmlNSDescriptorImpl descriptor, HashSet<XmlTag> visited) {
        for (XmlTag tag : tags) {
            XmlTag redefinedRootTag;
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, specialName)) {
                String attribute = tag.getAttributeValue("name");
                if (!name.equals(attribute) && (name.indexOf(":") < 0 || !name.substring(name.indexOf(":") + 1).equals(attribute))) continue;
                return tag;
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, INCLUDE_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, IMPORT_TAG_NAME) && rootTag.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(name)).equals(tag.getAttributeValue("namespace"))) {
                XmlTag rTag;
                XmlDocument document;
                XmlFile xmlFile;
                String schemaLocation = tag.getAttributeValue("schemaLocation");
                if (schemaLocation == null || (xmlFile = XmlUtil.findNamespaceByLocation(rootTag.getContainingFile(), schemaLocation)) == null || (document = xmlFile.getDocument()) == null || (rTag = XmlNSDescriptorImpl.findSpecialTag(name, specialName, document.getRootTag(), descriptor, visited)) == null) continue;
                return rTag;
            }
            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, REDEFINE_TAG_NAME)) continue;
            XmlTag rTag = XmlNSDescriptorImpl.findSpecialTagIn(tag.getSubTags(), specialName, name, rootTag, descriptor, visited);
            if (rTag != null) {
                return rTag;
            }
            XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getRedefinedElementDescriptor(tag);
            if (nsDescriptor == null || (rTag = XmlNSDescriptorImpl.findSpecialTagIn((redefinedRootTag = ((XmlDocument)nsDescriptor.getDeclaration()).getRootTag()).getSubTags(), specialName, name, redefinedRootTag, nsDescriptor, visited)) == null) continue;
            return rTag;
        }
        return null;
    }

    public XmlTag findGroup(String name) {
        return XmlNSDescriptorImpl.findSpecialTag(name, "group", this.myTag, this, null);
    }

    public XmlTag findAttributeGroup(String name) {
        return XmlNSDescriptorImpl.findSpecialTag(name, "attributeGroup", this.myTag, this, null);
    }

    public XmlElementDescriptor[] getSubstitutes(String localName, String namespace) {
        ArrayList<XmlElementDescriptor> result = new ArrayList<XmlElementDescriptor>();
        this.initSubstitutes();
        List<XmlTag> substitutions = this.mySubstitutions.get(localName);
        if (substitutions == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        for (XmlTag tag : substitutions) {
            String substAttr = tag.getAttributeValue("substitutionGroup");
            if (substAttr == null || !this.checkElementNameEquivalence(localName, namespace, substAttr, tag)) continue;
            result.add(this.createElementDescriptor(tag));
        }
        return result.toArray(new XmlElementDescriptor[result.size()]);
    }

    private void initSubstitutes() {
        if (this.mySubstitutions == null) {
            XmlTag[] tags;
            this.mySubstitutions = new HashMap<String, List<XmlTag>>();
            for (XmlTag tag : tags = this.myTag.getSubTags()) {
                String substAttr;
                if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, ELEMENT_TAG_NAME) || (substAttr = tag.getAttributeValue("substitutionGroup")) == null) continue;
                String substLocalName = XmlUtil.findLocalNameByQualifiedName(substAttr);
                List<XmlTag> list = this.mySubstitutions.get(substLocalName);
                if (list == null) {
                    list = new LinkedList<XmlTag>();
                    this.mySubstitutions.put(substLocalName, list);
                }
                list.add(tag);
            }
        }
    }

    public static String getSchemaNamespace(XmlFile file) {
        return XmlUtil.findNamespacePrefixByURI(file, "http://www.w3.org/2001/XMLSchema");
    }

    public PsiElement getDeclaration() {
        return this.myFile.getDocument();
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return "";
    }

    public void init(PsiElement element) {
        this.myFile = (XmlFile)element.getContainingFile();
        if (element instanceof XmlTag) {
            this.myTag = (XmlTag)element;
        } else {
            XmlDocument document = this.myFile.getDocument();
            if (document != null) {
                this.myTag = document.getRootTag();
            }
        }
        if (this.myTag != null) {
            this.myTargetNamespace = this.myTag.getAttributeValue("targetNamespace");
        }
        THashSet dependenciesSet = new THashSet();
        Set<PsiFile> redefineProcessingSet = myRedefinedDescriptorsInProcessing.get();
        if (redefineProcessingSet != null) {
            dependenciesSet.addAll(redefineProcessingSet);
        }
        XmlNSDescriptorImpl.collectDependencies(this.myTag, this.myFile, (Set<PsiFile>)dependenciesSet);
        this.dependencies = ArrayUtil.toObjectArray((Collection)dependenciesSet);
    }

    public Object[] getDependences() {
        if (this.dependencies == null) {
            this.dependencies = new Object[]{this.myFile};
        }
        return this.dependencies;
    }

    @Override
    public void validate(@NotNull XmlDocument context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/schema/XmlNSDescriptorImpl.validate must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/impl/schema/XmlNSDescriptorImpl.validate must not be null");
        }
        ExternalDocumentValidator.doValidation(context, host);
    }

    public XmlTag getTag() {
        return this.myTag;
    }

    public static XmlNSDescriptorImpl getRedefinedElementDescriptor(XmlTag parentTag) {
        XmlFile file = XmlNSDescriptorImpl.getRedefinedElementDescriptorFile(parentTag);
        if (file != null) {
            PsiMetaData metaData;
            XmlDocument document = file.getDocument();
            PsiMetaData psiMetaData = metaData = document != null ? document.getMetaData() : null;
            if (metaData instanceof XmlNSDescriptorImpl) {
                return (XmlNSDescriptorImpl)metaData;
            }
        }
        return null;
    }

    public static XmlFile getRedefinedElementDescriptorFile(XmlTag parentTag) {
        PsiElement psiElement;
        PsiReference[] references;
        String schemaL = parentTag.getAttributeValue("schemaLocation");
        if (schemaL != null && (references = parentTag.getAttribute("schemaLocation", null).getValueElement().getReferences()).length > 0 && (psiElement = references[references.length - 1].resolve()) instanceof XmlFile) {
            return (XmlFile)psiElement;
        }
        return null;
    }

    public boolean hasSubstitutions() {
        this.initSubstitutes();
        return this.mySubstitutions != null && this.mySubstitutions.size() > 0;
    }

    public boolean isValid() {
        return this.myFile != null && this.getDeclaration().isValid();
    }

    static {
        STD_TYPES.add("string");
        STD_TYPES.add("normalizedString");
        STD_TYPES.add("token");
        STD_TYPES.add("byte");
        STD_TYPES.add("unsignedByte");
        STD_TYPES.add("base64Binary");
        STD_TYPES.add("hexBinary");
        STD_TYPES.add("integer");
        STD_TYPES.add("positiveInteger");
        STD_TYPES.add("negativeInteger");
        STD_TYPES.add("nonNegativeInteger");
        STD_TYPES.add("nonPositiveInteger");
        STD_TYPES.add("int");
        STD_TYPES.add("unsignedInt");
        STD_TYPES.add("long");
        STD_TYPES.add("unsignedLong");
        STD_TYPES.add("short");
        STD_TYPES.add("unsignedShort");
        STD_TYPES.add("decimal");
        STD_TYPES.add("float");
        STD_TYPES.add("double");
        STD_TYPES.add("boolean");
        STD_TYPES.add("time");
        STD_TYPES.add("dateTime");
        STD_TYPES.add("duration");
        STD_TYPES.add("date");
        STD_TYPES.add("gMonth");
        STD_TYPES.add("gYear");
        STD_TYPES.add("gYearMonth");
        STD_TYPES.add("gDay");
        STD_TYPES.add("gMonthDay");
        STD_TYPES.add("Name");
        STD_TYPES.add("QName");
        STD_TYPES.add("NCName");
        STD_TYPES.add("anyURI");
        STD_TYPES.add("language");
        STD_TYPES.add("ID");
        STD_TYPES.add("IDREF");
        STD_TYPES.add("IDREFS");
        STD_TYPES.add("ENTITY");
        STD_TYPES.add("ENTITIES");
        STD_TYPES.add("NOTATION");
        STD_TYPES.add("NMTOKEN");
        STD_TYPES.add("NMTOKENS");
        STD_TYPES.add("anySimpleType");
        UNDECLARED_STD_TYPES.add("anySimpleType");
    }

    static class QNameKey
    extends Pair<String, String> {
        QNameKey(String name, String namespace) {
            super((Object)name, (Object)namespace);
        }
    }
}

