/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownAttributeInspection;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspection;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.parsing.xml.HtmlBuilderDriver;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import gnu.trove.THashSet;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.bag.HashBag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUtil {
    @NonNls
    private static final String JSFC = "jsfc";
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";
    @NonNls
    private static final String[] EMPTY_TAGS = new String[]{"base", "hr", "meta", "link", "frame", "br", "basefont", "param", "img", "area", "input", "isindex", "col", "source"};
    private static final Set<String> EMPTY_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] OPTIONAL_END_TAGS = new String[]{"head", "p", "li", "dd", "dt", "thead", "tfoot", "tbody", "colgroup", "tr", "th", "td", "option", "embed", "noembed"};
    private static final Set<String> OPTIONAL_END_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] BLOCK_TAGS = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "dir", "menu", "pre", "dl", "div", "center", "noscript", "noframes", "blockquote", "form", "isindex", "hr", "table", "fieldset", "address", "map", "body", "object", "applet", "ins", "del", "dd", "li", "button", "th", "td", "iframe", "comment", "nobr"};
    @NonNls
    private static final String[] POSSIBLY_INLINE_TAGS = new String[]{"object", "applet", "ins", "del", "button", "nobr"};
    private static final Set<String> BLOCK_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] INLINE_ELEMENTS_CONTAINER = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "dt"};
    private static final Set<String> INLINE_ELEMENTS_CONTAINER_MAP = new THashSet();
    @NonNls
    private static final String[] EMPTY_ATTRS = new String[]{"nowrap", "compact", "disabled", "readonly", "selected", "multiple", "nohref", "ismap", "declare", "noshade", "checked"};
    private static final Set<String> EMPTY_ATTRS_MAP = new THashSet();
    private static final Set<String> POSSIBLY_INLINE_TAGS_MAP = new THashSet();

    private HtmlUtil() {
    }

    public static boolean isSingleHtmlTag(String tagName) {
        return EMPTY_TAGS_MAP.contains(tagName.toLowerCase());
    }

    public static boolean isSingleHtmlTagL(String tagName) {
        return EMPTY_TAGS_MAP.contains(tagName);
    }

    public static boolean isOptionalEndForHtmlTag(String tagName) {
        return OPTIONAL_END_TAGS_MAP.contains(tagName.toLowerCase());
    }

    public static boolean isOptionalEndForHtmlTagL(String tagName) {
        return OPTIONAL_END_TAGS_MAP.contains(tagName);
    }

    public static boolean isSingleHtmlAttribute(String attrName) {
        return EMPTY_ATTRS_MAP.contains(attrName.toLowerCase());
    }

    public static boolean isHtmlBlockTag(String tagName) {
        return BLOCK_TAGS_MAP.contains(tagName.toLowerCase());
    }

    public static boolean isPossiblyInlineTag(String tagName) {
        return POSSIBLY_INLINE_TAGS_MAP.contains(tagName);
    }

    public static boolean isHtmlBlockTagL(String tagName) {
        return BLOCK_TAGS_MAP.contains(tagName);
    }

    public static boolean isInlineTagContainer(String tagName) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(tagName.toLowerCase());
    }

    public static boolean isInlineTagContainerL(String tagName) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(tagName);
    }

    public static void addHtmlSpecificCompletions(XmlElementDescriptor descriptor, XmlTag element, List<XmlElementDescriptor> variants) {
        String name = descriptor.getName((PsiElement)element);
        if (name != null && HtmlUtil.isOptionalEndForHtmlTag(name)) {
            XmlElementDescriptor parentDescriptor;
            PsiElement parent = element.getParent();
            if (parent != null) {
                parent = parent.getParent();
            }
            if (parent instanceof HtmlTag && (parentDescriptor = ((HtmlTag)parent).getDescriptor()) != descriptor && parentDescriptor != null) {
                for (XmlElementDescriptor elementsDescriptor : parentDescriptor.getElementsDescriptors((XmlTag)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementsDescriptor.getName())) continue;
                    variants.add(elementsDescriptor);
                }
            }
        }
    }

    @Nullable
    public static XmlDocument getRealXmlDocument(@Nullable XmlDocument doc) {
        if (doc == null) {
            return null;
        }
        PsiFile containingFile = doc.getContainingFile();
        PsiFile templateFile = TemplateLanguageUtil.getTemplateFile((PsiFile)containingFile);
        if (templateFile instanceof XmlFile) {
            return ((XmlFile)templateFile).getDocument();
        }
        return doc;
    }

    public static String[] getHtmlTagNames() {
        return HtmlDescriptorsTable.getHtmlTagNames();
    }

    public static XmlAttributeDescriptor[] getCustomAttributeDescriptors(XmlElement context) {
        String entitiesString = HtmlUtil.getEntitiesString(context, 2);
        if (entitiesString == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlAttributeDescriptor[] descriptors = new XmlAttributeDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            final String customName = tokenizer.nextToken();
            if (customName.length() == 0) continue;
            descriptors[index++] = new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context) {
                    return customName;
                }

                @Override
                public String getName() {
                    return customName;
                }
            };
        }
        return descriptors;
    }

    public static XmlElementDescriptor[] getCustomTagDescriptors(XmlElement context) {
        String entitiesString = HtmlUtil.getEntitiesString(context, 1);
        if (entitiesString == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlElementDescriptor[] descriptors = new XmlElementDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            final String tagName = tokenizer.nextToken();
            if (tagName.length() == 0) continue;
            descriptors[index++] = new XmlElementDescriptorImpl(context instanceof XmlTag ? (XmlTag)context : null){

                @Override
                public String getName(PsiElement context) {
                    return tagName;
                }

                @Override
                public String getDefaultName() {
                    return tagName;
                }

                @Override
                public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
                    return true;
                }
            };
        }
        return descriptors;
    }

    @Nullable
    public static String getEntitiesString(XmlElement context, int type) {
        if (context == null) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile().getOriginalFile();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(context.getProject()).getInspectionProfile();
        switch (type) {
            case 1: {
                HtmlUnknownTagInspection unknownTagInspection;
                LocalInspectionToolWrapper wrapper = (LocalInspectionToolWrapper)profile.getInspectionTool("HtmlUnknownTag", (PsiElement)containingFile);
                HtmlUnknownTagInspection htmlUnknownTagInspection = unknownTagInspection = wrapper != null ? (HtmlUnknownTagInspection)wrapper.getTool() : null;
                if (unknownTagInspection == null) break;
                return unknownTagInspection.getAdditionalEntries();
            }
            case 2: {
                HtmlUnknownAttributeInspection unknownAttributeInspection;
                LocalInspectionToolWrapper wrapper1 = (LocalInspectionToolWrapper)profile.getInspectionTool("HtmlUnknownAttribute", (PsiElement)containingFile);
                HtmlUnknownAttributeInspection htmlUnknownAttributeInspection = unknownAttributeInspection = wrapper1 != null ? (HtmlUnknownAttributeInspection)wrapper1.getTool() : null;
                if (unknownAttributeInspection == null) break;
                return unknownAttributeInspection.getAdditionalEntries();
            }
        }
        return null;
    }

    public static XmlAttributeDescriptor[] appendHtmlSpecificAttributeCompletions(XmlTag declarationTag, XmlAttributeDescriptor[] descriptors, XmlAttributeImpl context) {
        if (declarationTag instanceof HtmlTag) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])HtmlUtil.getCustomAttributeDescriptors(context), XmlAttributeDescriptor.class);
            return descriptors;
        }
        if (declarationTag.getPrefixByNamespace("http://java.sun.com/jsf/html") != null && declarationTag.getNSDescriptor("http://www.w3.org/1999/xhtml", true) != null && !"http://java.sun.com/JSP/Page".equals(declarationTag.getNamespace())) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.append((Object[])descriptors, (Object)new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context) {
                    return HtmlUtil.JSFC;
                }

                @Override
                public String getName() {
                    return HtmlUtil.JSFC;
                }
            });
        }
        return descriptors;
    }

    public static Charset detectCharsetFromMetaHttpEquiv(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/HtmlUtil.detectCharsetFromMetaHttpEquiv must not be null");
        }
        final Ref charsetNameRef = new Ref();
        try {
            new HtmlBuilderDriver(content).build(new XmlBuilder(){
                @NonNls
                final Bag inTag = new HashBag();
                boolean metHttpEquiv = false;
                private String contentAttributeValue;

                @Override
                public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int startOffset, int endOffset) {
                }

                @Override
                public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int startoffset, int endoffset, int headerEndOffset) {
                    String name = ((Object)localName).toString().toLowerCase();
                    this.inTag.add((Object)name);
                    if (!this.inTag.contains((Object)"head") && !"html".equals(name)) {
                        this.terminate();
                    }
                    return XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES;
                }

                private void terminate() {
                    throw TerminateException.INSTANCE;
                }

                @Override
                public void endTag(CharSequence localName, String namespace, int startoffset, int endoffset) {
                    String name = ((Object)localName).toString().toLowerCase();
                    if ("meta".equals(name) && this.metHttpEquiv && this.contentAttributeValue != null) {
                        int start = this.contentAttributeValue.indexOf(HtmlUtil.CHARSET_PREFIX);
                        if (start == -1) {
                            return;
                        }
                        int end = this.contentAttributeValue.indexOf(59, start += HtmlUtil.CHARSET_PREFIX.length());
                        if (end == -1) {
                            end = this.contentAttributeValue.length();
                        }
                        String charsetName = this.contentAttributeValue.substring(start, end);
                        charsetNameRef.set((Object)charsetName);
                        this.terminate();
                    }
                    if ("head".equals(name)) {
                        this.terminate();
                    }
                    this.inTag.remove((Object)name);
                    this.metHttpEquiv = false;
                    this.contentAttributeValue = null;
                }

                @Override
                public void attribute(CharSequence localName, CharSequence v, int startoffset, int endoffset) {
                    String name = ((Object)localName).toString().toLowerCase();
                    if (this.inTag.contains((Object)"meta")) {
                        String value = ((Object)v).toString().toLowerCase();
                        if (name.equals("http-equiv")) {
                            this.metHttpEquiv |= value.equals("content-type");
                        }
                        if (name.equals("content")) {
                            this.contentAttributeValue = value;
                        }
                    }
                }

                @Override
                public void textElement(CharSequence display, CharSequence physical, int startoffset, int endoffset) {
                }

                @Override
                public void entityRef(CharSequence ref, int startOffset, int endOffset) {
                }

                @Override
                public void error(String message, int startOffset, int endOffset) {
                }
            });
        }
        catch (TerminateException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = (String)charsetNameRef.get();
        return CharsetToolkit.forName((String)name);
    }

    public static boolean isTagWithoutAttributes(@NonNls String tagName) {
        return tagName != null && "br".equalsIgnoreCase(tagName);
    }

    public static boolean hasHtml(PsiFile file) {
        if (HtmlUtil.isHtmlFile(file)) {
            return true;
        }
        return file.getViewProvider() instanceof TemplateLanguageFileViewProvider;
    }

    private static boolean isHtmlFile(PsiFile file) {
        Language language = file.getLanguage();
        return language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE;
    }

    public static boolean isHtmlTagContainingFile(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
            if (tag instanceof HtmlTag) {
                return true;
            }
            FileViewProvider provider = containingFile.getViewProvider();
            Language language = provider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() : provider.getBaseLanguage();
            return language == XHTMLLanguage.INSTANCE;
        }
        return false;
    }

    public static boolean isHtmlTagContainingFile(Editor editor, PsiFile file) {
        if (editor == null || file == null || !(file instanceof XmlFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return HtmlUtil.isHtmlTagContainingFile(element);
    }

    static {
        EMPTY_TAGS_MAP.addAll(Arrays.asList(EMPTY_TAGS));
        EMPTY_ATTRS_MAP.addAll(Arrays.asList(EMPTY_ATTRS));
        OPTIONAL_END_TAGS_MAP.addAll(Arrays.asList(OPTIONAL_END_TAGS));
        BLOCK_TAGS_MAP.addAll(Arrays.asList(BLOCK_TAGS));
        INLINE_ELEMENTS_CONTAINER_MAP.addAll(Arrays.asList(INLINE_ELEMENTS_CONTAINER));
        POSSIBLY_INLINE_TAGS_MAP.addAll(Arrays.asList(POSSIBLY_INLINE_TAGS));
    }

    private static class TerminateException
    extends RuntimeException {
        private static final TerminateException INSTANCE = new TerminateException();

        private TerminateException() {
        }
    }
}

