/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Icons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class InjectionsSettingsUI
implements Configurable {
    private final Project myProject;
    private final Configuration myConfiguration;
    private List<BaseInjection> myInjections;
    private List<BaseInjection> myOriginalInjections;
    private final JPanel myRoot;
    private final InjectionsTable myInjectionsTable;
    private final Map<String, LanguageInjectionSupport> mySupports = new THashMap();
    private final Map<String, AnAction> myEditActions = new THashMap();
    private final List<AnAction> myAddActions = new ArrayList<AnAction>();
    private ActionToolbar myToolbar;
    private JLabel myCountLabel;

    public InjectionsSettingsUI(Project project, Configuration configuration) {
        this.myProject = project;
        this.myConfiguration = configuration;
        this.myOriginalInjections = ContainerUtil.concat(InjectorUtils.getActiveInjectionSupportIds(), (Function)new Function<String, Collection<? extends BaseInjection>>(){

            public Collection<? extends BaseInjection> fun(String s) {
                return ContainerUtil.findAll(InjectionsSettingsUI.this.myConfiguration.getInjections(s), (Condition)new Condition<BaseInjection>(){

                    public boolean value(BaseInjection injection) {
                        return InjectedLanguage.findLanguageById(injection.getInjectedLanguageId()) != null;
                    }
                });
            }
        });
        InjectionsSettingsUI.sortInjections(this.myOriginalInjections);
        this.myInjections = new ArrayList<BaseInjection>();
        for (BaseInjection injection : this.myOriginalInjections) {
            this.myInjections.add(injection.copy());
        }
        this.myRoot = new JPanel(new BorderLayout());
        this.myInjectionsTable = new InjectionsTable(this.myInjections);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)((Object)this.myInjectionsTable)), "Center");
        DefaultActionGroup group = this.createActions();
        this.myToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        this.myToolbar.setTargetComponent((JComponent)((Object)this.myInjectionsTable));
        this.myRoot.add((Component)this.myToolbar.getComponent(), "North");
        this.myRoot.add((Component)tablePanel, "Center");
        this.myCountLabel = new JLabel();
        this.myCountLabel.setHorizontalAlignment(4);
        this.myCountLabel.setForeground(SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES.getFgColor());
        this.myRoot.add((Component)this.myCountLabel, "South");
        this.updateCountLabel();
    }

    private DefaultActionGroup createActions() {
        Consumer<BaseInjection> consumer = new Consumer<BaseInjection>(){

            public void consume(BaseInjection injection) {
                InjectionsSettingsUI.this.addInjection(injection);
            }
        };
        NullableFactory<BaseInjection> producer = new NullableFactory<BaseInjection>(){

            public BaseInjection create() {
                return InjectionsSettingsUI.this.getSelectedInjection();
            }
        };
        for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
            this.myAddActions.addAll(Arrays.asList(support.createAddActions(this.myProject, consumer)));
            AnAction action = support.createEditAction(this.myProject, (Factory<BaseInjection>)producer);
            this.myEditActions.put(support.getId(), action == null ? AbstractLanguageInjectionSupport.createDefaultEditAction(this.myProject, (Factory<BaseInjection>)producer) : action);
            this.mySupports.put(support.getId(), support);
        }
        Collections.sort(this.myAddActions, new Comparator<AnAction>(){

            @Override
            public int compare(AnAction o1, AnAction o2) {
                return Comparing.compare((Comparable)((Object)o1.getTemplatePresentation().getText()), (Comparable)((Object)o2.getTemplatePresentation().getText()));
            }
        });
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction addAction = new AnAction("Add", "Add", Icons.ADD_ICON){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(!InjectionsSettingsUI.this.myAddActions.isEmpty());
            }

            public void actionPerformed(AnActionEvent e) {
                InjectionsSettingsUI.this.performAdd(e);
            }
        };
        AnAction removeAction = new AnAction("Remove", "Remove", Icons.DELETE_ICON){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(!InjectionsSettingsUI.this.getSelectedInjections().isEmpty());
            }

            public void actionPerformed(AnActionEvent e) {
                InjectionsSettingsUI.this.performRemove();
            }
        };
        AnAction editAction = new AnAction("Edit", "Edit", Icons.PROPERTIES_ICON){

            public void update(AnActionEvent e) {
                AnAction action = InjectionsSettingsUI.this.getEditAction();
                e.getPresentation().setEnabled(action != null);
                if (action != null) {
                    action.update(e);
                }
            }

            public void actionPerformed(AnActionEvent e) {
                InjectionsSettingsUI.this.performEditAction(e);
            }
        };
        AnAction copyAction = new AnAction("Duplicate", "Duplicate", Icons.DUPLICATE_ICON){

            public void update(AnActionEvent e) {
                AnAction action = InjectionsSettingsUI.this.getEditAction();
                e.getPresentation().setEnabled(action != null);
                if (action != null) {
                    action.update(e);
                }
            }

            public void actionPerformed(AnActionEvent e) {
                BaseInjection injection = InjectionsSettingsUI.this.getSelectedInjection();
                if (injection != null) {
                    InjectionsSettingsUI.this.addInjection(injection.copy());
                }
            }
        };
        group.add(addAction);
        group.add(removeAction);
        group.add(copyAction);
        group.add(editAction);
        addAction.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)((Object)this.myInjectionsTable));
        removeAction.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)((Object)this.myInjectionsTable));
        editAction.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)this.myInjectionsTable));
        group.add(new AnAction("Import", "Import", IconLoader.getIcon((String)"/actions/install.png")){

            public void actionPerformed(AnActionEvent e) {
                InjectionsSettingsUI.this.doImportAction(e.getDataContext());
                InjectionsSettingsUI.this.updateCountLabel();
            }
        });
        group.addSeparator();
        group.add(new AnAction("Enable Selected Injections", "Enable Selected Injections", Icons.SELECT_ALL_ICON){

            public void actionPerformed(AnActionEvent e) {
                InjectionsSettingsUI.this.performSelectedInjectionsEnabled(true);
            }
        });
        group.add(new AnAction("Disable Selected Injections", "Disable Selected Injections", Icons.UNSELECT_ALL_ICON){

            public void actionPerformed(AnActionEvent e) {
                InjectionsSettingsUI.this.performSelectedInjectionsEnabled(false);
            }
        });
        new AnAction("Toggle"){

            public void actionPerformed(AnActionEvent e) {
                InjectionsSettingsUI.this.performToggleAction();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)((Object)this.myInjectionsTable));
        return group;
    }

    private void performEditAction(AnActionEvent e) {
        AnAction action = this.getEditAction();
        if (action != null) {
            int row = this.myInjectionsTable.getSelectedRow();
            action.actionPerformed(e);
            ((ListTableModel)this.myInjectionsTable.getModel()).fireTableDataChanged();
            this.myInjectionsTable.getSelectionModel().setSelectionInterval(row, row);
            this.updateCountLabel();
        }
    }

    private void updateCountLabel() {
        int placesCount = 0;
        int enablePlacesCount = 0;
        for (BaseInjection injection : this.myInjections) {
            for (InjectionPlace place : injection.getInjectionPlaces()) {
                ++placesCount;
                if (!place.isEnabled()) continue;
                ++enablePlacesCount;
            }
        }
        if (!this.myInjections.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.myInjections.size()).append(" injection").append(this.myInjections.size() > 1 ? "s" : "").append(" (").append(enablePlacesCount).append(" of ").append(placesCount).append(" place").append(placesCount > 1 ? "s" : "").append(" enabled) ");
            this.myCountLabel.setText(sb.toString());
        } else {
            this.myCountLabel.setText("no injections configured ");
        }
    }

    @Nullable
    private AnAction getEditAction() {
        BaseInjection injection = this.getSelectedInjection();
        String supportId = injection == null ? null : injection.getSupportId();
        return supportId == null ? null : this.myEditActions.get(supportId);
    }

    private void addInjection(BaseInjection injection) {
        injection.initializePlaces(true);
        this.myInjections.add(injection);
        this.myInjectionsTable.getListTableModel().setItems(this.myInjections);
        int index = this.myInjections.indexOf(injection);
        this.myInjectionsTable.getSelectionModel().setSelectionInterval(index, index);
        TableUtil.scrollSelectionToVisible((JTable)((Object)this.myInjectionsTable));
    }

    private static void sortInjections(List<BaseInjection> injections) {
        Collections.sort(injections, new Comparator<BaseInjection>(){

            @Override
            public int compare(BaseInjection o1, BaseInjection o2) {
                int support = Comparing.compare((Comparable)((Object)o1.getSupportId()), (Comparable)((Object)o2.getSupportId()));
                if (support != 0) {
                    return support;
                }
                int lang = Comparing.compare((Comparable)((Object)o1.getInjectedLanguageId()), (Comparable)((Object)o2.getInjectedLanguageId()));
                if (lang != 0) {
                    return lang;
                }
                return Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName()));
            }
        });
    }

    public JComponent createComponent() {
        return this.myRoot;
    }

    public void reset() {
        this.myInjections.clear();
        for (BaseInjection injection : this.myOriginalInjections) {
            this.myInjections.add(injection.copy());
        }
        this.myInjectionsTable.getListTableModel().setItems(this.myInjections);
        this.updateCountLabel();
    }

    public void disposeUIResources() {
    }

    public void apply() {
        this.myConfiguration.replaceInjections(this.myInjections, this.myOriginalInjections);
        this.myOriginalInjections.clear();
        this.myOriginalInjections.addAll(this.myInjections);
        InjectionsSettingsUI.sortInjections(this.myOriginalInjections);
        this.reset();
    }

    public boolean isModified() {
        ArrayList<BaseInjection> copy = new ArrayList<BaseInjection>(this.myInjections);
        InjectionsSettingsUI.sortInjections(copy);
        return !((Object)this.myOriginalInjections).equals(copy);
    }

    private void performSelectedInjectionsEnabled(boolean enabled) {
        for (BaseInjection injection : this.getSelectedInjections()) {
            injection.setPlaceEnabled(null, enabled);
        }
        this.myInjectionsTable.updateUI();
        this.updateCountLabel();
    }

    private void performToggleAction() {
        List<BaseInjection> selectedInjections = this.getSelectedInjections();
        boolean enabledExists = false;
        boolean disabledExists = false;
        for (BaseInjection injection : selectedInjections) {
            if (injection.isEnabled()) {
                enabledExists = true;
            } else {
                disabledExists = true;
            }
            if (!enabledExists || !disabledExists) continue;
            break;
        }
        boolean allEnabled = !enabledExists && disabledExists;
        this.performSelectedInjectionsEnabled(allEnabled);
    }

    private void performRemove() {
        int selectedRow = this.myInjectionsTable.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        List<BaseInjection> selected = this.getSelectedInjections();
        Iterator<BaseInjection> it = this.myInjections.iterator();
        block0: while (it.hasNext()) {
            BaseInjection injection = it.next();
            for (BaseInjection selectedInjection : selected) {
                if (injection != selectedInjection) continue;
                it.remove();
                continue block0;
            }
        }
        ((ListTableModel)this.myInjectionsTable.getModel()).fireTableDataChanged();
        int index = Math.min(this.myInjections.size() - 1, selectedRow);
        this.myInjectionsTable.getSelectionModel().setSelectionInterval(index, index);
        TableUtil.scrollSelectionToVisible((JTable)((Object)this.myInjectionsTable));
        this.updateCountLabel();
    }

    private List<BaseInjection> getSelectedInjections() {
        ArrayList<BaseInjection> toRemove = new ArrayList<BaseInjection>();
        for (int row : this.myInjectionsTable.getSelectedRows()) {
            toRemove.add((BaseInjection)this.myInjectionsTable.getItems().get(row));
        }
        return toRemove;
    }

    @Nullable
    private BaseInjection getSelectedInjection() {
        int row = this.myInjectionsTable.getSelectedRow();
        return row < 0 ? null : (BaseInjection)this.myInjectionsTable.getItems().get(row);
    }

    private void performAdd(AnActionEvent e) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (AnAction action : this.myAddActions) {
            group.add(action);
        }
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, true, new Runnable(){

            @Override
            public void run() {
                InjectionsSettingsUI.this.updateCountLabel();
            }
        }, -1).showUnderneathOf((Component)this.myToolbar.getComponent());
    }

    @Nls
    public String getDisplayName() {
        return "Injections";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.settings.injection.language.injection.settings";
    }

    private ColumnInfo[] createInjectionColumnInfos() {
        BooleanTableCellRenderer booleanCellRenderer = InjectionsSettingsUI.createBooleanCellRenderer();
        final TableCellRenderer displayNameCellRenderer = this.createDisplayNameCellRenderer();
        final TableCellRenderer languageCellRenderer = InjectionsSettingsUI.createLanguageCellRenderer();
        final Comparator<BaseInjection> languageComparator = new Comparator<BaseInjection>(){

            @Override
            public int compare(BaseInjection o1, BaseInjection o2) {
                return Comparing.compare((Comparable)((Object)o1.getInjectedLanguageId()), (Comparable)((Object)o2.getInjectedLanguageId()));
            }
        };
        final Comparator<BaseInjection> displayNameComparator = new Comparator<BaseInjection>(){

            @Override
            public int compare(BaseInjection o1, BaseInjection o2) {
                int support = Comparing.compare((Comparable)((Object)o1.getSupportId()), (Comparable)((Object)o2.getSupportId()));
                if (support != 0) {
                    return support;
                }
                return Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName()));
            }
        };
        return new ColumnInfo[]{new ColumnInfo<BaseInjection, Boolean>(" ", (TableCellRenderer)booleanCellRenderer){
            final /* synthetic */ TableCellRenderer val$booleanCellRenderer;
            {
                this.val$booleanCellRenderer = tableCellRenderer;
                super(x0);
            }

            public Class getColumnClass() {
                return Boolean.class;
            }

            public Boolean valueOf(BaseInjection o) {
                return o.isEnabled();
            }

            public boolean isCellEditable(BaseInjection injection) {
                return true;
            }

            public void setValue(BaseInjection injection, Boolean value) {
                injection.setPlaceEnabled(null, value);
            }

            public TableCellRenderer getRenderer(BaseInjection injection) {
                return this.val$booleanCellRenderer;
            }
        }, new ColumnInfo<BaseInjection, BaseInjection>("Display Name"){

            public BaseInjection valueOf(BaseInjection injection) {
                return injection;
            }

            public Comparator<BaseInjection> getComparator() {
                return displayNameComparator;
            }

            public TableCellRenderer getRenderer(BaseInjection injection) {
                return displayNameCellRenderer;
            }
        }, new ColumnInfo<BaseInjection, BaseInjection>("Language"){

            public BaseInjection valueOf(BaseInjection injection) {
                return injection;
            }

            public Comparator<BaseInjection> getComparator() {
                return languageComparator;
            }

            public TableCellRenderer getRenderer(BaseInjection injection) {
                return languageCellRenderer;
            }
        }};
    }

    private static BooleanTableCellRenderer createBooleanCellRenderer() {
        return new BooleanTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return InjectionsSettingsUI.setLabelColors(super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column), table, isSelected, row);
            }
        };
    }

    private static TableCellRenderer createLanguageCellRenderer() {
        return new TableCellRenderer(){
            final JLabel myLabel = new JLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                BaseInjection injection = (BaseInjection)value;
                if (injection == null) {
                    return this.myLabel;
                }
                Language language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId());
                FileType fileType = language == null ? null : language.getAssociatedFileType();
                this.myLabel.setIcon(fileType == null ? null : fileType.getIcon());
                this.myLabel.setText(language == null ? injection.getInjectedLanguageId() : language.getDisplayName());
                InjectionsSettingsUI.setLabelColors(this.myLabel, table, isSelected, row);
                return this.myLabel;
            }
        };
    }

    private TableCellRenderer createDisplayNameCellRenderer() {
        return new TableCellRenderer(){
            final SimpleColoredComponent myLabel = new SimpleColoredComponent();
            final SimpleColoredText myText = new SimpleColoredText();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.myLabel.clear();
                BaseInjection injection = (BaseInjection)value;
                if (injection == null) {
                    return this.myLabel;
                }
                SimpleTextAttributes grayAttrs = isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
                this.myText.append(injection.getSupportId() + ": ", grayAttrs);
                ((LanguageInjectionSupport)InjectionsSettingsUI.this.mySupports.get(injection.getSupportId())).setupPresentation(injection, this.myText, isSelected);
                this.myText.appendToComponent(this.myLabel);
                this.myText.clear();
                InjectionsSettingsUI.setLabelColors((Component)this.myLabel, table, isSelected, row);
                return this.myLabel;
            }
        };
    }

    private static Component setLabelColors(Component label, JTable table, boolean isSelected, int row) {
        if (label instanceof JComponent) {
            ((JComponent)label).setOpaque(true);
        }
        label.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        label.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        return label;
    }

    private void doImportAction(DataContext dataContext) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, false, true, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || "xml".equals(file.getExtension()) || file.getFileType() == StdFileTypes.ARCHIVE);
            }

            public boolean isFileSelectable(VirtualFile file) {
                return file.getFileType() == StdFileTypes.XML;
            }
        };
        descriptor.setDescription("Please select the configuration file (usually named IntelliLang.xml) to import.");
        descriptor.setTitle("Import Configuration");
        descriptor.putUserData(LangDataKeys.MODULE_CONTEXT, LangDataKeys.MODULE.getData(dataContext));
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, this.myProject);
        SplitterProportionsDataImpl splitterData = new SplitterProportionsDataImpl();
        splitterData.externalizeFromDimensionService("IntelliLang.ImportSettingsKey.SplitterProportions");
        VirtualFile[] files = chooser.choose(null, this.myProject);
        if (files.length != 1) {
            return;
        }
        try {
            Configuration cfg = Configuration.load(files[0].getInputStream());
            if (cfg == null) {
                Messages.showWarningDialog((Project)this.myProject, (String)"The selected file does not contain any importable configuration.", (String)"Nothing to Import");
                return;
            }
            HashMap currentMap = ContainerUtil.classify(this.myInjections.iterator(), (Convertor)new Convertor<BaseInjection, String>(){

                public String convert(BaseInjection o) {
                    return o.getSupportId();
                }
            });
            ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>();
            ArrayList<BaseInjection> newInjections = new ArrayList<BaseInjection>();
            for (String supportId : InjectorUtils.getActiveInjectionSupportIds()) {
                Set currentInjections = (Set)currentMap.get(supportId);
                List<BaseInjection> importingInjections = cfg.getInjections(supportId);
                if (currentInjections == null) {
                    newInjections.addAll(importingInjections);
                    continue;
                }
                Configuration.importInjections(currentInjections, importingInjections, originalInjections, newInjections);
            }
            this.myInjections.removeAll(originalInjections);
            this.myInjections.addAll(newInjections);
            for (BaseInjection injection : newInjections) {
                injection.initializePlaces(true);
            }
            this.myInjectionsTable.getListTableModel().setItems(this.myInjections);
            int n = newInjections.size();
            if (n > 1) {
                Messages.showInfoMessage((Project)this.myProject, (String)(n + " entries have been successfully imported"), (String)"Import Successful");
            } else if (n == 1) {
                Messages.showInfoMessage((Project)this.myProject, (String)"One entry has been successfully imported", (String)"Import Successful");
            } else {
                Messages.showInfoMessage((Project)this.myProject, (String)"No new entries have been imported", (String)"Import");
            }
        }
        catch (Exception e1) {
            Configuration.LOG.error("Unable to load Settings", (Throwable)e1);
            String msg = e1.getLocalizedMessage();
            Messages.showErrorDialog((Project)this.myProject, (String)(msg != null && msg.length() > 0 ? msg : e1.toString()), (String)"Could not load Settings");
        }
    }

    private class InjectionsTable
    extends TableView<BaseInjection> {
        private InjectionsTable(List<BaseInjection> injections) {
            super(new ListTableModel(InjectionsSettingsUI.this.createInjectionColumnInfos(), injections, 1));
            this.setAutoResizeMode(3);
            this.getColumnModel().getColumn(2).setCellRenderer(InjectionsSettingsUI.createLanguageCellRenderer());
            this.getColumnModel().getColumn(1).setCellRenderer(InjectionsSettingsUI.this.createDisplayNameCellRenderer());
            this.getColumnModel().getColumn(0).setResizable(false);
            this.setShowGrid(false);
            this.setShowVerticalLines(false);
            this.setGridColor(this.getForeground());
            this.getColumnModel().getColumn(0).setMaxWidth(new JCheckBox().getPreferredSize().width);
            final int[] preffered = new int[]{0};
            ContainerUtil.process((Iterable)InjectionsSettingsUI.this.myInjections, (Processor)new Processor<BaseInjection>(){

                public boolean process(BaseInjection injection) {
                    String languageId = injection.getInjectedLanguageId();
                    if (preffered[0] < languageId.length()) {
                        preffered[0] = languageId.length();
                    }
                    return true;
                }
            });
            final int[] max = new int[]{0};
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    int row = InjectionsTable.this.rowAtPoint(e.getPoint());
                    if (row < 0) {
                        return;
                    }
                    if (InjectionsTable.this.columnAtPoint(e.getPoint()) <= 0) {
                        return;
                    }
                    InjectionsSettingsUI.this.myInjectionsTable.getSelectionModel().setSelectionInterval(row, row);
                    InjectionsSettingsUI.this.performEditAction(new AnActionEvent((InputEvent)e, DataManager.getInstance().getDataContext((Component)((Object)InjectionsTable.this)), "unknown", new Presentation(""), ActionManager.getInstance(), 0));
                }
            });
            ContainerUtil.process((Object[])InjectedLanguage.getAvailableLanguageIDs(), (Processor)new Processor<String>(){

                public boolean process(String languageId) {
                    if (max[0] < languageId.length()) {
                        max[0] = languageId.length();
                    }
                    return true;
                }
            });
            this.getColumnModel().getColumn(2).setResizable(false);
            Icon icon = StdFileTypes.PLAIN_TEXT.getIcon();
            int preferred = new JLabel((String)StringUtil.repeatSymbol((char)'m', (int)preffered[0]), (Icon)icon, (int)2).getPreferredSize().width;
            this.getColumnModel().getColumn(2).setMinWidth(preferred);
            this.getColumnModel().getColumn(2).setPreferredWidth(preferred);
            this.getColumnModel().getColumn(2).setMaxWidth(new JLabel((String)StringUtil.repeatSymbol((char)'m', (int)max[0]), (Icon)icon, (int)2).getPreferredSize().width);
            new TableViewSpeedSearch(this){

                protected String getElementText(Object element) {
                    BaseInjection injection = (BaseInjection)element;
                    return injection.getSupportId() + " " + injection.getInjectedLanguageId() + " " + injection.getDisplayName();
                }
            };
        }
    }
}

