/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyFileTypeLoader;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerBase;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.util.GroovyUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovyCompiler
extends GroovyCompilerBase {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.compiler.GroovyCompiler");
    private static final String AST_TRANSFORM_FILE_NAME = "org.codehaus.groovy.transform.ASTTransformation";

    public GroovyCompiler(Project project) {
        super(project);
    }

    @NotNull
    public String getDescription() {
        if ("groovy compiler" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/compiler/GroovyCompiler.getDescription must not return null");
        }
        return "groovy compiler";
    }

    @Override
    protected void compileFiles(CompileContext context, Module module, List<VirtualFile> toCompile, TranslatingCompiler.OutputSink sink, boolean tests) {
        LinkedHashSet<VirtualFile> allToCompile = new LinkedHashSet<VirtualFile>(toCompile);
        if (!"false".equals(System.getProperty("compile.groovy.dependencies", "true"))) {
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setText("Enumerating Groovy classes...");
            Set<VirtualFile> groovyFiles = this.enumerateGroovyFiles(module);
            if (toCompile.size() < groovyFiles.size()) {
                context.getProgressIndicator().checkCanceled();
                context.getProgressIndicator().setText("Processing Groovy dependencies...");
                this.addIntermediateGroovyClasses(allToCompile, groovyFiles);
            }
        }
        context.getProgressIndicator().checkCanceled();
        context.getProgressIndicator().setText("Groovy compiler in operation...");
        this.runGroovycCompiler(context, module, new ArrayList<VirtualFile>(allToCompile), false, GroovyCompiler.getMainOutput(context, module, tests), sink, tests);
    }

    private void addIntermediateGroovyClasses(Set<VirtualFile> allToCompile, final Set<VirtualFile> groovyFiles) {
        THashSet initialFiles = new THashSet(allToCompile);
        THashSet visited = new THashSet();
        for (VirtualFile aClass : initialFiles) {
            if (!visited.add((Object)aClass)) continue;
            GroovyCompiler.goForIntermediateFiles(aClass, allToCompile, new FactoryMap<VirtualFile, Set<VirtualFile>>(){

                protected Set<VirtualFile> create(final VirtualFile key) {
                    return (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<VirtualFile>>(){

                        public Set<VirtualFile> compute() {
                            return GroovyCompiler.this.calcCodeReferenceDependencies(key, groovyFiles);
                        }
                    });
                }
            }, (Set<VirtualFile>)visited);
        }
    }

    private Set<VirtualFile> enumerateGroovyFiles(Module module) {
        THashSet moduleClasses = new THashSet();
        ModuleRootManager.getInstance((Module)module).getFileIndex().iterateContent(new ContentIterator((Set)moduleClasses){
            final /* synthetic */ Set val$moduleClasses;
            {
                this.val$moduleClasses = set;
            }

            public boolean processFile(final VirtualFile vfile) {
                if (!vfile.isDirectory() && ((Object)((Object)GroovyFileType.GROOVY_FILE_TYPE)).equals(vfile.getFileType())) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            if (PsiManager.getInstance((Project)GroovyCompiler.this.myProject).findFile(vfile) instanceof GroovyFile) {
                                val$moduleClasses.add(vfile);
                            }
                        }
                    });
                }
                return true;
            }
        });
        return moduleClasses;
    }

    private static void goForIntermediateFiles(VirtualFile from, Set<VirtualFile> dirty, FactoryMap<VirtualFile, Set<VirtualFile>> deps, Set<VirtualFile> visited) {
        Set set = (Set)deps.get((Object)from);
        for (VirtualFile psiClass : set) {
            if (visited.add(psiClass)) {
                GroovyCompiler.goForIntermediateFiles(psiClass, dirty, deps, visited);
            }
            if (!dirty.contains(psiClass)) continue;
            dirty.add(from);
        }
    }

    private Set<VirtualFile> calcCodeReferenceDependencies(VirtualFile vfile, final Set<VirtualFile> moduleFiles) {
        PsiFile psi = PsiManager.getInstance((Project)this.myProject).findFile(vfile);
        if (!(psi instanceof GroovyFile)) {
            return Collections.emptySet();
        }
        THashSet deps = new THashSet();
        psi.acceptChildren(new PsiElementVisitor((Set)deps){
            final /* synthetic */ Set val$deps;
            {
                this.val$deps = set2;
            }

            public void visitElement(PsiElement element) {
                if (element instanceof GrCodeReferenceElement) {
                    GrCodeReferenceElement referenceElement = (GrCodeReferenceElement)element;
                    try {
                        VirtualFile targetFile;
                        PsiElement target = referenceElement.resolve();
                        if ((target instanceof GrTypeDefinition || target instanceof GroovyScriptClass) && moduleFiles.contains(targetFile = target.getContainingFile().getViewProvider().getVirtualFile())) {
                            this.val$deps.add(targetFile);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                    catch (AssertionError e) {
                        LOG.error((Throwable)((Object)e));
                    }
                }
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
        return deps;
    }

    public boolean validateConfiguration(CompileScope compileScope) {
        VirtualFile[] files = compileScope.getFiles((FileType)GroovyFileType.GROOVY_FILE_TYPE, true);
        if (files.length == 0) {
            return true;
        }
        Set<String> scriptExtensions = GroovyFileTypeLoader.getCustomGroovyScriptExtensions();
        HashSet<Module> modules = new HashSet<Module>();
        for (VirtualFile file : files) {
            ProjectRootManager rootManager;
            Module module;
            if (scriptExtensions.contains(file.getExtension()) || (module = (rootManager = ProjectRootManager.getInstance((Project)this.myProject)).getFileIndex().getModuleForFile(file)) == null) continue;
            modules.add(module);
        }
        HashSet<Module> nojdkModules = new HashSet<Module>();
        for (Module module : modules) {
            if (!GroovyUtils.isAcceptableModuleType(module.getModuleType())) continue;
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) {
                nojdkModules.add(module);
                continue;
            }
            if (LibrariesUtil.hasGroovySdk(module) || GroovyConfigUtils.getInstance().tryToSetUpGroovyFacetOntheFly(module)) continue;
            Messages.showErrorDialog((Project)this.myProject, (String)GroovyBundle.message("cannot.compile.groovy.files.no.facet", module.getName()), (String)GroovyBundle.message("cannot.compile", new Object[0]));
            ModulesConfigurator.showDialog((Project)module.getProject(), (String)module.getName(), (String)ClasspathEditor.NAME, (boolean)false);
            return false;
        }
        if (!nojdkModules.isEmpty()) {
            Module[] noJdkArray = nojdkModules.toArray(new Module[nojdkModules.size()]);
            if (noJdkArray.length == 1) {
                Messages.showErrorDialog((Project)this.myProject, (String)GroovyBundle.message("cannot.compile.groovy.files.no.sdk", noJdkArray[0].getName()), (String)GroovyBundle.message("cannot.compile", new Object[0]));
            } else {
                StringBuffer modulesList = new StringBuffer();
                for (int i = 0; i < noJdkArray.length; ++i) {
                    if (i > 0) {
                        modulesList.append(", ");
                    }
                    modulesList.append(noJdkArray[i].getName());
                }
                Messages.showErrorDialog((Project)this.myProject, (String)GroovyBundle.message("cannot.compile.groovy.files.no.sdk.mult", modulesList.toString()), (String)GroovyBundle.message("cannot.compile", new Object[0]));
            }
            return false;
        }
        GroovyCompilerConfiguration configuration = GroovyCompilerConfiguration.getInstance(this.myProject);
        if (!configuration.transformsOk && this.needTransformCopying(compileScope)) {
            int result = Messages.showYesNoDialog((Project)this.myProject, (String)"You seem to have global Groovy AST transformations defined in your project,\nbut they won't be applied to your code because they are not marked as compiler resources.\nDo you want to add them to compiler resource list?\n(you can do it yourself later in Settings | Compiler | Resource patterns)", (String)"AST Transformations found", (Icon)GroovyIcons.GROOVY_ICON_32x32);
            if (result == 0) {
                CompilerConfiguration.getInstance((Project)this.myProject).addResourceFilePattern(AST_TRANSFORM_FILE_NAME);
            } else {
                configuration.transformsOk = true;
            }
        }
        return true;
    }

    private boolean needTransformCopying(CompileScope compileScope) {
        CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)this.myProject);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (VirtualFile file : FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)AST_TRANSFORM_FILE_NAME, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject))) {
            if (!compileScope.belongs(file.getUrl()) || !index.isInSource(file) || configuration.isResourceFile(file)) continue;
            return true;
        }
        return false;
    }
}

