/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.config.AbstractGroovyLibraryManager;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovyLibraryManager
extends AbstractGroovyLibraryManager {
    @Override
    public boolean managesLibrary(@NotNull Library library, LibrariesContainer container) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/GroovyLibraryManager.managesLibrary must not be null");
        }
        return LibrariesUtil.getGroovyLibraryHome(container.getLibraryFiles(library, OrderRootType.CLASSES)) != null;
    }

    @Override
    @Nls
    public String getLibraryVersion(@NotNull Library library, LibrariesContainer librariesContainer) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/GroovyLibraryManager.getLibraryVersion must not be null");
        }
        String home = LibrariesUtil.getGroovyLibraryHome(librariesContainer.getLibraryFiles(library, OrderRootType.CLASSES));
        if (home == null) {
            return "undefined";
        }
        return GroovyConfigUtils.getInstance().getSDKVersion(home);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = GroovyIcons.GROOVY_ICON_16x16;
        if (icon == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/GroovyLibraryManager.getIcon must not return null");
        }
        return icon;
    }

    @Override
    @NotNull
    public String getAddActionText() {
        if ("Create new Groovy SDK..." == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/GroovyLibraryManager.getAddActionText must not return null");
        }
        return "Create new Groovy SDK...";
    }

    @Override
    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/GroovyLibraryManager.isSDKHome must not be null");
        }
        return GroovyConfigUtils.getInstance().isSDKHome(file);
    }

    @Override
    protected void fillLibrary(String path, Library.ModifiableModel model) {
        File libDir;
        File[] jars;
        File srcRoot = new File(path + "/src/main");
        if (srcRoot.exists()) {
            model.addRoot(VfsUtil.getUrlForLibraryRoot((File)srcRoot), OrderRootType.SOURCES);
        }
        if ((jars = (libDir = new File(path + "/lib")).exists() ? libDir.listFiles() : new File(path + "/embeddable").listFiles()) != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                model.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }

    @Override
    @NotNull
    public String getSDKVersion(String path) {
        String string = GroovyConfigUtils.getInstance().getSDKVersion(path);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/GroovyLibraryManager.getSDKVersion must not return null");
        }
        return string;
    }

    @Override
    public Icon getDialogIcon() {
        return GroovyIcons.GROOVY_ICON_32x32;
    }

    @Override
    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        if ("Groovy" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/GroovyLibraryManager.getLibraryCategoryName must not return null");
        }
        return "Groovy";
    }
}

