/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.AbstractGroovyLibraryManager;
import org.jetbrains.plugins.groovy.config.LibraryManager;
import org.jetbrains.plugins.groovy.config.ui.ManagedLibrariesEditor;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class GroovyFacetEditor {
    @NonNls
    private static final String GROOVY_HOME = "GROOVY_HOME";
    private static final Comparator<Pair<Library, LibraryManager>> LIBRARY_COMPARATOR = new Comparator<Pair<Library, LibraryManager>>(){

        @Override
        public int compare(Pair<Library, LibraryManager> o1, Pair<Library, LibraryManager> o2) {
            String name1 = ((Library)o1.first).getName();
            String name2 = ((Library)o2.first).getName();
            if (name1 == null || name2 == null) {
                return 1;
            }
            return -name1.compareToIgnoreCase(name2);
        }
    };
    private TextFieldWithBrowseButton mySdkPath;
    private JPanel myPanel;
    private JComboBox myComboBox;
    private JRadioButton myExistingSdk;
    private JRadioButton myNewSdk;
    private JLabel myNewSdkLabel;
    private final Class<? extends LibraryManager> myAcceptableManager;

    public GroovyFacetEditor(@Nullable Project project) {
        this(project, LibraryManager.class, GROOVY_HOME);
    }

    public GroovyFacetEditor(@Nullable Project project, @NotNull Class<? extends LibraryManager> acceptableManager, String envHome) {
        if (acceptableManager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/config/ui/GroovyFacetEditor.<init> must not be null");
        }
        this.myAcceptableManager = acceptableManager;
        this.$$$setupUI$$$();
        Set<Pair<Library, LibraryManager>> libs = this.configureComboBox(project);
        this.configureSdkPathField(project);
        boolean hasVersions = !libs.isEmpty();
        this.myNewSdk.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean status = GroovyFacetEditor.this.myNewSdk.isSelected();
                GroovyFacetEditor.this.mySdkPath.setEnabled(status);
                GroovyFacetEditor.this.myComboBox.setEnabled(!status);
            }
        });
        if (hasVersions) {
            this.myExistingSdk.setSelected(true);
            this.mySdkPath.setEnabled(false);
            this.myNewSdkLabel.setVisible(false);
        } else {
            this.myExistingSdk.setVisible(false);
            this.myNewSdk.setVisible(false);
            this.myNewSdk.setSelected(true);
            this.myNewSdkLabel.setVisible(true);
            this.mySdkPath.setEnabled(true);
            this.myComboBox.setEnabled(false);
            this.myComboBox.setVisible(false);
        }
        String s = System.getenv(envHome);
        if (s != null && s.length() > 0) {
            this.mySdkPath.setText(s);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<Pair<Library, LibraryManager>> configureComboBox(Project project) {
        void var7_9;
        LibrariesContainer container = LibrariesContainerFactory.createContainer((Project)project);
        LibraryManager[] managers = (AbstractGroovyLibraryManager[])AbstractGroovyLibraryManager.EP_NAME.getExtensions();
        TreeSet<Pair<Library, LibraryManager>> libs = new TreeSet<Pair<Library, LibraryManager>>(LIBRARY_COMPARATOR);
        Library[] arr$ = container.getAllLibraries();
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_9 < len$) {
            Library library = arr$[var7_9];
            LibraryManager manager = ManagedLibrariesEditor.findManagerFor(library, managers, container);
            if (this.myAcceptableManager.isInstance(manager)) {
                libs.add((Pair<Library, LibraryManager>)Pair.create((Object)library, (Object)manager));
            }
            ++var7_9;
        }
        if (!libs.isEmpty()) {
            this.myComboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof Pair) {
                        Pair pair = (Pair)value;
                        this.setIcon(((LibraryManager)pair.second).getIcon());
                        this.setText(((Library)pair.first).getName());
                    }
                    return this;
                }
            });
            Pair maxValue = (Pair)libs.iterator().next();
            for (Pair pair : libs) {
                this.myComboBox.addItem(pair);
                String version = ((Library)pair.first).getName();
                FontMetrics fontMetrics = this.myComboBox.getFontMetrics(this.myComboBox.getFont());
                if (fontMetrics.stringWidth(version) <= fontMetrics.stringWidth(((Library)maxValue.getFirst()).getName())) continue;
                maxValue = pair;
            }
            this.myComboBox.setPrototypeDisplayValue(maxValue);
        } else {
            this.myComboBox.setEnabled(false);
            this.myComboBox.setVisible(false);
        }
        return libs;
    }

    @Nullable
    public Library getSelectedLibrary() {
        Object selectedItem = this.myComboBox.getSelectedItem();
        if (selectedItem != null && selectedItem instanceof Pair) {
            return (Library)((Pair)selectedItem).first;
        }
        return null;
    }

    @Nullable
    public String getNewSdkPath() {
        return this.mySdkPath.getText();
    }

    @Nullable
    public AbstractGroovyLibraryManager getChosenManager() {
        if (this.addNewSdk()) {
            VirtualFile file;
            String path = this.getNewSdkPath();
            if (path != null && (file = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)path))) != null && file.isDirectory()) {
                return GroovyFacetEditor.findManager(file);
            }
            return null;
        }
        Object selectedItem = this.myComboBox.getSelectedItem();
        if (selectedItem != null && selectedItem instanceof Pair) {
            return (AbstractGroovyLibraryManager)((Pair)selectedItem).second;
        }
        return null;
    }

    public boolean addNewSdk() {
        return !this.myNewSdk.isVisible() || this.myNewSdk.isSelected();
    }

    private void configureSdkPathField(final @Nullable Project project) {
        this.mySdkPath.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file) {
                        if (!super.isFileSelectable(file)) {
                            return false;
                        }
                        return GroovyFacetEditor.findManager(file) != null;
                    }
                };
                FileChooserDialog dialog = FileChooserFactory.getInstance().createFileChooser(descriptor, project);
                VirtualFile[] files = dialog.choose(null, project);
                if (files.length > 0) {
                    VirtualFile dir = files[0];
                    GroovyFacetEditor.this.mySdkPath.setText(FileUtil.toSystemDependentName((String)dir.getPath()));
                }
            }
        });
    }

    @Nullable
    private static AbstractGroovyLibraryManager findManager(VirtualFile dir) {
        AbstractGroovyLibraryManager[] managers;
        if (GroovyUtils.getFilesInDirectoryByPattern(dir.getPath() + "/lib", "groovy.*\\.jar").length == 0) {
            return null;
        }
        String name = dir.getName();
        for (AbstractGroovyLibraryManager manager : managers = (AbstractGroovyLibraryManager[])AbstractGroovyLibraryManager.EP_NAME.getExtensions()) {
            if (!manager.managesName(name) || !manager.isSDKHome(dir)) continue;
            return manager;
        }
        for (AbstractGroovyLibraryManager manager : managers) {
            if (!manager.isSDKHome(dir)) continue;
            return manager;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myComboBox = new JComboBox(){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(!GroovyFacetEditor.this.myNewSdk.isSelected() && enabled);
            }
        };
        this.mySdkPath = new TextFieldWithBrowseButton(){

            public void setEnabled(boolean enabled) {
                super.setEnabled(GroovyFacetEditor.this.addNewSdk() && enabled);
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = this.myComboBox;
        jPanel2.add((Component)jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myExistingSdk = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Existing SDK:");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNewSdk = jRadioButton = new JRadioButton();
        jRadioButton.setText("New SDK");
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.mySdkPath;
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 2, 1, 2, 8, 0, 7, 0, null, new Dimension(200, -1), null));
        this.myNewSdkLabel = jLabel = new JLabel();
        jLabel.setText("Installation path:");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

