/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GroovyCompletionUtil {
    private static final TokenSet SEPARATORS = TokenSet.create((IElementType[])new IElementType[]{GroovyElementTypes.mNLS, GroovyElementTypes.mSEMI});

    public static boolean endsWithExpression(PsiElement statement) {
        while (statement != null && !(statement instanceof GrExpression)) {
            statement = statement.getLastChild();
        }
        return statement != null;
    }

    @Nullable
    public static PsiElement nearestLeftSibling(PsiElement elem) {
        for (elem = elem.getPrevSibling(); elem != null && (elem instanceof PsiWhiteSpace || elem instanceof PsiComment || GroovyTokenTypes.mNLS.equals(elem.getNode().getElementType())); elem = elem.getPrevSibling()) {
        }
        return elem;
    }

    public static boolean isIncomplete(PsiElement element) {
        while (element != null) {
            PsiElement child = element.getLastChild();
            if (child instanceof PsiErrorElement) {
                return true;
            }
            element = child;
        }
        return false;
    }

    public static boolean isNewStatement(PsiElement element, boolean canBeAfterBrace) {
        PsiElement previousLeaf = GroovyCompletionUtil.getLeafByOffset(element.getTextRange().getStartOffset() - 1, element);
        if ((previousLeaf = PsiImplUtil.realPrevious(previousLeaf)) != null && canBeAfterBrace && GroovyElementTypes.mLCURLY.equals(previousLeaf.getNode().getElementType())) {
            return true;
        }
        return previousLeaf == null || SEPARATORS.contains(previousLeaf.getNode().getElementType());
    }

    public static PsiElement getLeafByOffset(int offset, PsiElement element) {
        if (offset < 0) {
            return null;
        }
        PsiFile candidate = element.getContainingFile();
        while (candidate.getNode().getChildren(null).length > 0) {
            candidate = candidate.findElementAt(offset);
        }
        return candidate;
    }

    public static boolean isFirstElementAfterModifiersInVariableDeclaration(PsiElement element, boolean acceptParameter) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrVariable)) {
            return false;
        }
        if (acceptParameter && parent instanceof GrParameter) {
            return ((GrParameter)parent).getTypeElementGroovy() == null;
        }
        PsiElement parent1 = parent.getParent();
        if (!(parent1 instanceof GrVariableDeclaration)) {
            return false;
        }
        GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)parent1;
        if (variableDeclaration.getTypeElementGroovy() != null) {
            return false;
        }
        return variableDeclaration.getVariables()[0] == parent;
    }

    public static boolean canBeModifier(PsiElement element) {
        PsiElement next;
        for (next = element.getNextSibling(); next != null && (next instanceof PsiWhiteSpace || next instanceof PsiComment); next = next.getNextSibling()) {
        }
        return next == null || SEPARATORS.contains(next.getNode().getElementType());
    }

    public static boolean asSimpleVariable(PsiElement context) {
        return GroovyCompletionUtil.isInTypeDefinitionBody(context) && GroovyCompletionUtil.isNewStatement(context, true);
    }

    public static boolean isInTypeDefinitionBody(PsiElement context) {
        return context.getParent() instanceof GrCodeReferenceElement && context.getParent().getParent() instanceof GrClassTypeElement && context.getParent().getParent().getParent() instanceof GrTypeDefinitionBody || context.getParent() instanceof GrTypeDefinitionBody;
    }

    public static boolean asVariableInBlock(PsiElement context) {
        if (context.getParent() instanceof GrReferenceExpression && (context.getParent().getParent() instanceof GrOpenBlock || context.getParent().getParent() instanceof GrClosableBlock) && GroovyCompletionUtil.isNewStatement(context, true)) {
            return true;
        }
        if (context.getParent() instanceof GrReferenceExpression && context.getParent().getParent() instanceof GrApplicationStatement && (context.getParent().getParent().getParent() instanceof GrOpenBlock || context.getParent().getParent().getParent() instanceof GrClosableBlock) && GroovyCompletionUtil.isNewStatement(context, true)) {
            return true;
        }
        return context.getParent() instanceof GrTypeDefinitionBody && GroovyCompletionUtil.isNewStatement(context, true);
    }

    public static boolean inMemberDeclaration(PsiElement context) {
        PsiElement parent;
        if (context.getParent() instanceof GrReferenceElement && context.getParent().getParent() instanceof GrTypeElement && ((parent = context.getParent().getParent().getParent()) instanceof GrMethod || parent instanceof GrVariableDeclaration)) {
            return parent.getParent() instanceof GrTypeDefinitionBody || parent.getParent() instanceof GroovyFile;
        }
        return false;
    }

    public static boolean asTypedMethod(PsiElement context) {
        return context.getParent() instanceof GrReferenceElement && context.getParent().getParent() instanceof GrTypeElement && context.getParent().getParent().getParent() instanceof GrMethod && context.getParent().getParent().getParent().getParent() instanceof GrTypeDefinitionBody && context.getTextRange().getStartOffset() == context.getParent().getParent().getParent().getParent().getTextRange().getStartOffset();
    }

    public static Object[] getCompletionVariants(GroovyResolveResult[] candidates) {
        Object[] result = new Object[candidates.length];
        for (int i = 0; i < result.length; ++i) {
            String importedName;
            PsiElement element = candidates[i].getElement();
            GroovyPsiElement context = candidates[i].getCurrentFileResolveContext();
            result[i] = context instanceof GrImportStatement && (importedName = ((GrImportStatement)context).getImportedName()) != null && element != null ? LookupElementBuilder.create((Object)element, (String)importedName).setPresentableText(importedName) : element;
        }
        return result;
    }

    public static LookupElement setTailTypeForConstructor(PsiClass clazz, LookupElement lookupElement) {
        return LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (InsertHandler)ParenthesesInsertHandler.getInstance((boolean)GroovyCompletionUtil.hasConstructorParameters(clazz)));
    }

    public static boolean hasConstructorParameters(PsiClass clazz) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = clazz.getConstructors()) {
            if (constructor.getParameterList().getParametersCount() <= 0) continue;
            return true;
        }
        return false;
    }
}

