/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovyCommentBreakerEnterProcessor;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrForBodyFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrIfConditionFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrLiteralFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrMethodBodyFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrMethodCallFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrMethodParametersFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrMissingIfStatement;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrWhileBodyFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrWhileConditionFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.processors.GroovyPlainEnterProcessor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GroovySmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor");
    private static final GrFixer[] ourFixers;
    private static final EnterProcessor[] ourEnterProcessors;
    private int myFirstErrorOffset = Integer.MAX_VALUE;
    private static final int MAX_ATTEMPTS = 20;
    private static final Key<Long> SMART_ENTER_TIMESTAMP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor.process must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor.process must not be null");
        }
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor.process must not be null");
        }
        Document document = editor.getDocument();
        String textForRollback = document.getText();
        try {
            editor.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.process(project, editor, psiFile, 0);
        }
        catch (TooManyAttemptsException e) {
            document.replaceString(0, document.getTextLength(), (CharSequence)textForRollback);
        }
        finally {
            editor.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    private void process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int attempt) throws TooManyAttemptsException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor.process must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor.process must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor.process must not be null");
        }
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        try {
            this.commit(editor);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            PsiElement atCaret = this.getStatementAtCaret(editor, file);
            if (atCaret == null) {
                if (!new GroovyCommentBreakerEnterProcessor().doEnter(editor, (PsiElement)file, false)) {
                    GroovySmartEnterProcessor.plainEnter(editor);
                }
                return;
            }
            ArrayList<PsiElement> queue = new ArrayList<PsiElement>();
            GroovySmartEnterProcessor.collectAllElements(atCaret, queue, true);
            queue.add(atCaret);
            for (PsiElement psiElement : queue) {
                for (GrFixer fixer : ourFixers) {
                    fixer.apply(editor, this, psiElement);
                    if (LookupManager.getInstance((Project)project).getActiveLookup() != null) {
                        return;
                    }
                    if (!GroovySmartEnterProcessor.isUncommited((Project)project) && psiElement.isValid()) continue;
                    this.moveCaretInsideBracesIfAny(editor, file);
                    this.process(project, editor, file, attempt + 1);
                    return;
                }
            }
            this.doEnter(atCaret, editor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        PsiElement parent = atCaret.getParent();
        if (parent instanceof GrCodeBlock) {
            GrCodeBlock block = (GrCodeBlock)parent;
            if (block.getStatements().length > 0 && block.getStatements()[0] == atCaret) {
                atCaret = block;
            }
        } else if (parent instanceof GrForStatement) {
            atCaret = parent;
        }
        super.reformat(atCaret);
    }

    private void doEnter(PsiElement atCaret, Editor editor) throws IncorrectOperationException {
        PsiFile psiFile = atCaret.getContainingFile();
        RangeMarker rangeMarker = this.createRangeMarker((PsiElement)atCaret);
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            this.reformat((PsiElement)atCaret);
            return;
        }
        this.reformat((PsiElement)atCaret);
        this.commit(editor);
        atCaret = GroovyRefactoringUtil.findElementInRange((GroovyFileBase)psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), atCaret.getClass());
        for (EnterProcessor processor : ourEnterProcessors) {
            if (atCaret == null) break;
            if (!processor.doEnter(editor, atCaret, GroovySmartEnterProcessor.isModified(editor))) continue;
            return;
        }
        if (!GroovySmartEnterProcessor.isModified(editor)) {
            GroovySmartEnterProcessor.plainEnter(editor);
        } else if (this.myFirstErrorOffset == Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(rangeMarker.getEndOffset());
        } else {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
        }
    }

    private static void collectAllElements(PsiElement atCaret, List<PsiElement> res, boolean recurse) {
        PsiElement[] children;
        res.add(0, atCaret);
        if (GroovySmartEnterProcessor.doNotStepInto(atCaret)) {
            if (!recurse) {
                return;
            }
            recurse = false;
        }
        PsiElement parent = atCaret.getParent();
        if (atCaret instanceof GrClosableBlock && parent instanceof GrStringInjection && parent.getParent() instanceof GrString) {
            res.add(parent.getParent());
        }
        if (parent instanceof GrArgumentList) {
            res.add(parent.getParent());
        }
        for (PsiElement child : children = GroovySmartEnterProcessor.getChildren(atCaret)) {
            if (atCaret instanceof GrStatement && child instanceof GrStatement) continue;
            GroovySmartEnterProcessor.collectAllElements(child, res, recurse);
        }
    }

    private static boolean doNotStepInto(PsiElement element) {
        return element instanceof PsiClass || element instanceof GrCodeBlock || element instanceof GrStatement || element instanceof GrMethod;
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        PsiElement statementAtCaret;
        PsiElement atCaret = super.getStatementAtCaret(editor, psiFile);
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        if (atCaret == null) {
            return null;
        }
        GrCodeBlock codeBlock = (GrCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)atCaret, GrCodeBlock.class, (boolean)false, (Class[])new Class[]{GrControlStatement.class});
        if (codeBlock != null) {
            for (GrStatement statement : codeBlock.getStatements()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)atCaret, (boolean)true)) continue;
                return statement;
            }
        }
        if ((statementAtCaret = PsiTreeUtil.getParentOfType((PsiElement)atCaret, (Class[])new Class[]{GrStatement.class, GrCodeBlock.class, PsiMember.class, GrDocComment.class})) instanceof GrBlockStatement) {
            return null;
        }
        if (statementAtCaret == null) {
            return null;
        }
        GrControlStatement controlStatement = (GrControlStatement)PsiTreeUtil.getParentOfType((PsiElement)statementAtCaret, GrControlStatement.class, (boolean)false);
        if (controlStatement != null && !PsiTreeUtil.hasErrorElements((PsiElement)statementAtCaret)) {
            return controlStatement;
        }
        return statementAtCaret instanceof GrStatement || statementAtCaret instanceof GrMember ? statementAtCaret : null;
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor.moveCaretInsideBracesIfAny must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor.moveCaretInsideBracesIfAny must not be null");
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{}".length()), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{\n}".length()), (CharSequence)"{\n}")) {
            this.commit(editor);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)file.getProject());
            boolean old = settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
            PsiElement elt = PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(caretOffset - 1), GrCodeBlock.class);
            this.reformat(elt);
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = old;
            editor.getCaretModel().moveToOffset(caretOffset - 1);
        }
    }

    public void registerUnresolvedError(int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    protected static void plainEnter(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor.plainEnter must not be null");
        }
        GroovySmartEnterProcessor.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
    }

    protected static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    protected static boolean isModified(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor.isModified must not be null");
        }
        Long timestamp = (Long)editor.getUserData(SMART_ENTER_TIMESTAMP);
        return editor.getDocument().getModificationStamp() != timestamp.longValue();
    }

    private static PsiElement[] getChildren(PsiElement element) {
        PsiElement psiChild = element.getFirstChild();
        if (psiChild == null) {
            return new PsiElement[0];
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (psiChild != null) {
            result.add(psiChild);
            psiChild = psiChild.getNextSibling();
        }
        return result.toArray(new PsiElement[result.size()]);
    }

    static {
        ArrayList<GrFixer> fixers = new ArrayList<GrFixer>();
        fixers.add(new GrMissingIfStatement());
        fixers.add(new GrIfConditionFixer());
        fixers.add(new GrLiteralFixer());
        fixers.add(new GrMethodCallFixer());
        fixers.add(new GrMethodBodyFixer());
        fixers.add(new GrMethodParametersFixer());
        fixers.add(new GrWhileConditionFixer());
        fixers.add(new GrWhileBodyFixer());
        fixers.add(new GrForBodyFixer());
        ourFixers = fixers.toArray(new GrFixer[fixers.size()]);
        ArrayList<GroovyPlainEnterProcessor> processors = new ArrayList<GroovyPlainEnterProcessor>();
        processors.add(new GroovyPlainEnterProcessor());
        ourEnterProcessors = processors.toArray(new EnterProcessor[processors.size()]);
        SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");
    }

    public static class TooManyAttemptsException
    extends Exception {
    }
}

