/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.ArgumentList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.PrimaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.RegexConstructorExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.StringConstructorExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class PathExpression
implements GroovyElementTypes {
    private static final TokenSet DOTS = TokenSet.create((IElementType[])new IElementType[]{mSPREAD_DOT, mOPTIONAL_DOT, mMEMBER_POINTER, mDOT});
    private static final TokenSet PATH_ELEMENT_START = TokenSet.create((IElementType[])new IElementType[]{mSPREAD_DOT, mOPTIONAL_DOT, mMEMBER_POINTER, mLBRACK, mLPAREN, mLCURLY, mDOT});

    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        GroovyElementType qualifierType = PrimaryExpression.parse(builder, parser);
        if (qualifierType != WRONGWAY) {
            if (PathExpression.isPathElementStart(builder)) {
                PsiBuilder.Marker newMarker = marker.precede();
                marker.drop();
                if (mLCURLY.equals(builder.getTokenType())) {
                    PsiBuilder.Marker argsMarker = builder.mark();
                    argsMarker.done((IElementType)ARGUMENTS);
                }
                PathExpression.pathElementParse(builder, newMarker, parser, qualifierType);
            } else {
                marker.drop();
            }
            return true;
        }
        marker.drop();
        return false;
    }

    private static GroovyElementType pathElementParse(PsiBuilder builder, PsiBuilder.Marker marker, GroovyParser parser, GroovyElementType qualifierType) {
        if (DOTS.contains(builder.getTokenType()) || ParserUtils.lookAhead(builder, mNLS, mDOT)) {
            if (ParserUtils.lookAhead(builder, mNLS, mDOT)) {
                ParserUtils.getToken(builder, mNLS);
            }
            ParserUtils.getToken(builder, DOTS);
            ParserUtils.getToken(builder, mNLS);
            TypeArguments.parse(builder);
            GroovyElementType res = kNEW.equals(builder.getTokenType()) ? PrimaryExpression.newExprParse(builder, parser, marker) : (kTHIS.equals(builder.getTokenType()) || kSUPER.equals(builder.getTokenType()) ? PathExpression.parseThisSuperExpression(builder, marker, qualifierType) : PathExpression.namePartParse(builder, parser));
            if (!((Object)((Object)res)).equals((Object)WRONGWAY)) {
                PsiBuilder.Marker newMarker = marker.precede();
                marker.done((IElementType)res);
                if (mLCURLY.equals(builder.getTokenType())) {
                    PsiBuilder.Marker argsMarker = builder.mark();
                    argsMarker.done((IElementType)ARGUMENTS);
                }
                PathExpression.pathElementParse(builder, newMarker, parser, res);
            } else {
                builder.error(GroovyBundle.message("path.selector.expected", new Object[0]));
                marker.drop();
            }
        } else if (mLPAREN.equals(builder.getTokenType())) {
            PrimaryExpression.methodCallArgsParse(builder, parser);
            if (mLCURLY.equals(builder.getTokenType()) || ParserUtils.lookAhead(builder, mNLS, mLCURLY)) {
                ParserUtils.getToken(builder, mNLS);
                PathExpression.pathElementParse(builder, marker, parser, qualifierType);
            } else {
                PsiBuilder.Marker newMarker = marker.precede();
                marker.done((IElementType)PATH_METHOD_CALL);
                PathExpression.pathElementParse(builder, newMarker, parser, qualifierType);
            }
        } else if (mLCURLY.equals(builder.getTokenType())) {
            PathExpression.appendedBlockParse(builder, parser);
            if (mLCURLY.equals(builder.getTokenType())) {
                PathExpression.pathElementParse(builder, marker, parser, qualifierType);
            } else {
                PsiBuilder.Marker newMarker = marker.precede();
                marker.done((IElementType)PATH_METHOD_CALL);
                PathExpression.pathElementParse(builder, newMarker, parser, PATH_METHOD_CALL);
            }
        } else if (mLBRACK.equals(builder.getTokenType()) && !ParserUtils.lookAhead(builder, mLBRACK, mCOLON) && !ParserUtils.lookAhead(builder, mLBRACK, mNLS, mCOLON)) {
            PathExpression.indexPropertyArgsParse(builder, parser);
            PsiBuilder.Marker newMarker = marker.precede();
            marker.done((IElementType)PATH_INDEX_PROPERTY);
            if (mLCURLY.equals(builder.getTokenType())) {
                PsiBuilder.Marker argsMarker = builder.mark();
                argsMarker.done((IElementType)ARGUMENTS);
            }
            PathExpression.pathElementParse(builder, newMarker, parser, PATH_INDEX_PROPERTY);
        } else {
            marker.drop();
        }
        return PATH_EXPRESSION;
    }

    private static GroovyElementType parseThisSuperExpression(PsiBuilder builder, PsiBuilder.Marker marker, GroovyElementType qualifierType) {
        if (qualifierType != REFERENCE_EXPRESSION) {
            return WRONGWAY;
        }
        IElementType tokenType = builder.getTokenType();
        builder.advanceLexer();
        GroovyElementType type = kTHIS.equals(tokenType) ? THIS_REFERENCE_EXPRESSION : SUPER_REFERENCE_EXPRESSION;
        return type;
    }

    private static GroovyElementType namePartParse(PsiBuilder builder, GroovyParser parser) {
        ParserUtils.getToken(builder, mAT);
        if (ParserUtils.getToken(builder, mIDENT) || ParserUtils.getToken(builder, mSTRING_LITERAL) || ParserUtils.getToken(builder, mGSTRING_LITERAL)) {
            return REFERENCE_EXPRESSION;
        }
        IElementType tokenType = builder.getTokenType();
        if (mREGEX_LITERAL.equals(tokenType)) {
            ParserUtils.eatElement(builder, PATH_PROPERTY);
            return PATH_PROPERTY_REFERENCE;
        }
        if (mGSTRING_BEGIN.equals(tokenType)) {
            StringConstructorExpression.parse(builder, parser);
            return PATH_PROPERTY_REFERENCE;
        }
        if (mREGEX_BEGIN.equals(tokenType)) {
            RegexConstructorExpression.parse(builder, parser);
            return PATH_PROPERTY_REFERENCE;
        }
        if (mLCURLY.equals(tokenType)) {
            OpenOrClosableBlock.parseOpenBlock(builder, parser);
            return PATH_PROPERTY_REFERENCE;
        }
        if (mLPAREN.equals(tokenType)) {
            PrimaryExpression.parenthesizedExprParse(builder, parser);
            return PATH_PROPERTY_REFERENCE;
        }
        if (TokenSets.KEYWORD_REFERENCE_NAMES.contains(builder.getTokenType())) {
            builder.advanceLexer();
            return REFERENCE_EXPRESSION;
        }
        return WRONGWAY;
    }

    private static GroovyElementType indexPropertyArgsParse(PsiBuilder builder, GroovyParser parser) {
        assert (mLBRACK.equals(builder.getTokenType()));
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, mLBRACK);
        ParserUtils.getToken(builder, mNLS);
        ArgumentList.parseArgumentList(builder, mRBRACK, parser);
        ParserUtils.getToken(builder, mNLS);
        ParserUtils.getToken(builder, mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
        marker.done((IElementType)ARGUMENTS);
        return PATH_INDEX_PROPERTY;
    }

    private static GroovyElementType appendedBlockParse(PsiBuilder builder, GroovyParser parser) {
        return OpenOrClosableBlock.parseClosableBlock(builder, parser);
    }

    private static boolean isPathElementStart(PsiBuilder builder) {
        return PATH_ELEMENT_START.contains(builder.getTokenType()) || ParserUtils.lookAhead(builder, mNLS, mDOT) || ParserUtils.lookAhead(builder, mNLS, mLCURLY);
    }
}

