/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.toplevel;

import com.intellij.lang.PsiBuilder;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.Separators;
import org.jetbrains.plugins.groovy.lang.parser.parsing.toplevel.packaging.PackageDefinition;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class CompilationUnit
implements GroovyElementTypes {
    public static void parse(PsiBuilder builder, GroovyParser parser) {
        ParserUtils.getToken(builder, mSH_COMMENT);
        ParserUtils.getToken(builder, mNLS);
        if (!PackageDefinition.parse(builder, parser)) {
            parser.parseStatementWithImports(builder);
        }
        CompilationUnit.cleanAfterError(builder);
        while (Separators.parse(builder)) {
            parser.parseStatementWithImports(builder);
            CompilationUnit.cleanAfterError(builder);
        }
    }

    private static void cleanAfterError(PsiBuilder builder) {
        int i = 0;
        PsiBuilder.Marker em = builder.mark();
        while (!(builder.eof() || mNLS.equals(builder.getTokenType()) || mSEMI.equals(builder.getTokenType()))) {
            builder.advanceLexer();
            ++i;
        }
        if (i > 0) {
            em.error(GroovyBundle.message("separator.expected", new Object[0]));
        } else {
            em.drop();
        }
    }
}

