/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyInlineMethodUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineMethodConflictSolver;

public class GroovyMethodInliner
implements InlineHandler.Inliner {
    private final GrMethod myMethod;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.inline.GroovyMethodInliner");

    public GroovyMethodInliner(GrMethod method) {
        this.myMethod = method;
    }

    @Nullable
    public Map<PsiElement, String> getConflicts(PsiReference reference, PsiElement referenced) {
        PsiElement element = reference.getElement();
        assert (element instanceof GrExpression && element.getParent() instanceof GrCallExpression);
        GrCallExpression call = (GrCallExpression)element.getParent();
        Collection<GroovyInlineMethodUtil.ReferenceExpressionInfo> infos = GroovyInlineMethodUtil.collectReferenceInfo(this.myMethod);
        return GroovyMethodInliner.collectConflicts(call, infos);
    }

    private static Map<PsiElement, String> collectConflicts(GrCallExpression call, Collection<GroovyInlineMethodUtil.ReferenceExpressionInfo> infos) {
        HashMap<PsiElement, String> conflicts = new HashMap<PsiElement, String>();
        for (GroovyInlineMethodUtil.ReferenceExpressionInfo info : infos) {
            String className;
            if (PsiUtil.isAccessible(call, info.declaration)) continue;
            if (info.declaration instanceof PsiMethod) {
                className = info.containingClass.getName();
                String signature = GroovyRefactoringUtil.getMethodSignature((PsiMethod)info.declaration);
                String name = CommonRefactoringUtil.htmlEmphasize((String)(className + "." + signature));
                conflicts.put((PsiElement)info.declaration, GroovyRefactoringBundle.message("method.is.not.accessible.form.context.0", name));
                continue;
            }
            if (!(info.declaration instanceof PsiField)) continue;
            className = info.containingClass.getName();
            String name = CommonRefactoringUtil.htmlEmphasize((String)(className + "." + info.getPresentation()));
            conflicts.put((PsiElement)info.declaration, GroovyRefactoringBundle.message("field.is.not.accessible.form.context.0", name));
        }
        return conflicts;
    }

    public void inlineUsage(UsageInfo usage, PsiElement referenced) {
        PsiElement element = usage.getElement();
        assert (element instanceof GrExpression && element.getParent() instanceof GrCallExpression);
        GrCallExpression call = (GrCallExpression)element.getParent();
        RangeMarker marker = GroovyMethodInliner.inlineReferenceImpl(call, this.myMethod, GroovyMethodInliner.isOnExpressionOrReturnPlace(call), GroovyInlineMethodUtil.isTailMethodCall(call));
        if (marker != null) {
            Project project = referenced.getProject();
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            Editor editor = manager.getSelectedTextEditor();
            TextRange range = new TextRange(marker.getStartOffset(), marker.getEndOffset());
            GroovyRefactoringUtil.highlightOccurrencesByRanges(project, editor, new TextRange[]{range});
            WindowManager.getInstance().getStatusBar(project).setInfo(GroovyRefactoringBundle.message("press.escape.to.remove.the.highlighting", new Object[0]));
            if (editor != null) {
                editor.getCaretModel().moveToOffset(marker.getEndOffset());
            }
        }
    }

    static RangeMarker inlineReferenceImpl(GrCallExpression call, GrMethod method, boolean replaceCall, boolean isTailMethodCall) {
        try {
            GrExpression element;
            GrMethod newMethod;
            GrExpression result;
            GrExpression invoked;
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(call.getProject());
            Project project = call.getProject();
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            Editor editor = manager.getSelectedTextEditor();
            GrVariableDeclaration qualifierDeclaration = null;
            GrReferenceExpression innerQualifier = null;
            if (call instanceof GrMethodCallExpression && ((GrMethodCallExpression)call).getInvokedExpression() != null && (invoked = ((GrMethodCallExpression)call).getInvokedExpression()) instanceof GrReferenceExpression && ((GrReferenceExpression)invoked).getQualifierExpression() != null) {
                GrExpression qualifier = ((GrReferenceExpression)invoked).getQualifierExpression();
                if (!GroovyInlineMethodUtil.hasNoSideEffects(qualifier)) {
                    String qualName = GroovyMethodInliner.generateQualifierName(call, method, project, qualifier);
                    while (qualifier instanceof GrParenthesizedExpression) {
                        qualifier = ((GrParenthesizedExpression)qualifier).getOperand();
                    }
                    qualifierDeclaration = factory.createVariableDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, qualifier, null, qualName);
                    innerQualifier = (GrReferenceExpression)factory.createExpressionFromText(qualName);
                } else {
                    innerQualifier = (GrReferenceExpression)qualifier;
                }
            }
            if ((result = GroovyMethodInliner.getAloneResultExpression(newMethod = GroovyMethodInliner.prepareNewMethod(call, method, innerQualifier))) != null) {
                GrExpression expression = call.replaceWithExpression(result, false);
                TextRange range = expression.getTextRange();
                return editor != null ? new PersistentRangeMarker((DocumentEx)editor.getDocument(), range.getStartOffset(), range.getEndOffset()) : null;
            }
            String resultName = InlineMethodConflictSolver.suggestNewName("result", newMethod, call, new String[0]);
            Collection<GrReturnStatement> returnStatements = GroovyRefactoringUtil.findReturnStatements(newMethod);
            boolean hasTailExpr = GroovyRefactoringUtil.hasTailReturnExpression(method);
            int returnCount = returnStatements.size();
            PsiType methodType = method.getReturnType();
            GrOpenBlock body = newMethod.getBlock();
            assert (body != null);
            GrStatement[] statements = body.getStatements();
            GrExpression replaced = null;
            if (replaceCall && (!isTailMethodCall || hasTailExpr)) {
                GrExpression resultExpr;
                if (PsiType.VOID.equals(methodType)) {
                    resultExpr = factory.createExpressionFromText("null");
                } else if (returnCount == 1) {
                    resultExpr = factory.createExpressionFromText(returnStatements.iterator().next().getReturnValue().getText());
                } else if (returnCount > 1) {
                    resultExpr = factory.createExpressionFromText(resultName);
                } else if (hasTailExpr) {
                    GrExpression expr = (GrExpression)statements[statements.length - 1];
                    resultExpr = factory.createExpressionFromText(expr.getText());
                } else {
                    resultExpr = factory.createExpressionFromText("null");
                }
                replaced = call.replaceWithExpression(resultExpr, false);
            }
            GrExpression enclosingExpr = GroovyMethodInliner.changeEnclosingStatement(replaced != null ? replaced : call);
            GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)enclosingExpr, GrVariableDeclarationOwner.class);
            assert (owner != null);
            for (element = enclosingExpr; element != null && element.getParent() != owner; element = element.getParent()) {
            }
            assert (element != null && element instanceof GrStatement);
            GrStatement anchor = element;
            if (!replaceCall) assert (anchor == enclosingExpr);
            if (qualifierDeclaration != null) {
                owner.addVariableDeclarationBefore(qualifierDeclaration, anchor);
            }
            if (returnCount > 1 && PsiType.VOID != methodType && !isTailMethodCall) {
                PsiType type = methodType != null && methodType.equalsToText("java.lang.Object") ? null : methodType;
                GrVariableDeclaration resultDecl = factory.createVariableDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, null, type, resultName);
                GrStatement statement = ((GrStatementOwner)((Object)owner)).addStatementBefore(resultDecl, anchor);
                PsiUtil.shortenReferences(statement);
                for (GrReturnStatement returnStatement : returnStatements) {
                    GrExpression value = returnStatement.getReturnValue();
                    if (value != null) {
                        GrExpression assignment = factory.createExpressionFromText(resultName + " = " + value.getText());
                        returnStatement.replaceWithStatement(assignment);
                        continue;
                    }
                    returnStatement.replaceWithStatement(factory.createExpressionFromText(resultName + " = null"));
                }
            }
            if (!isTailMethodCall && (PsiType.VOID.equals(methodType) || returnCount == 1)) {
                for (GrReturnStatement returnStatement : returnStatements) {
                    returnStatement.removeStatement();
                }
            }
            for (GrStatement statement : statements = body.getStatements()) {
                if (statements.length > 0 && statement == statements[statements.length - 1] && hasTailExpr) continue;
                ((GrStatementOwner)((Object)owner)).addStatementBefore(statement, anchor);
            }
            if (replaceCall && (!isTailMethodCall || hasTailExpr)) {
                assert (replaced != null);
                TextRange range = replaced.getTextRange();
                PersistentRangeMarker marker = editor != null ? new PersistentRangeMarker((DocumentEx)editor.getDocument(), range.getStartOffset(), range.getEndOffset()) : null;
                GroovyMethodInliner.reformatOwner(owner);
                return marker;
            }
            GrStatement stmt = isTailMethodCall && enclosingExpr.getParent() instanceof GrReturnStatement ? (GrReturnStatement)enclosingExpr.getParent() : enclosingExpr;
            stmt.removeStatement();
            GroovyMethodInliner.reformatOwner(owner);
            return null;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static String generateQualifierName(GrCallExpression call, GrMethod method, final Project project, GrExpression qualifier) {
        String[] possibleNames = GroovyNameSuggestionUtil.suggestVariableNames(qualifier, new NameValidator(){

            @Override
            public String validateName(String name, boolean increaseNumber) {
                return name;
            }

            @Override
            public Project getProject() {
                return project;
            }
        });
        String qualName = possibleNames[0];
        qualName = InlineMethodConflictSolver.suggestNewName(qualName, method, call, new String[0]);
        return qualName;
    }

    private static void reformatOwner(GrVariableDeclarationOwner owner) throws IncorrectOperationException {
        if (owner == null) {
            return;
        }
        PsiFile file = owner.getContainingFile();
        Project project = file.getProject();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(file);
        if (document != null) {
            manager.doPostponedOperationsAndUnblockDocument(document);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, owner.getTextRange());
        }
    }

    private static GrExpression changeEnclosingStatement(GrExpression expr) throws IncorrectOperationException {
        PsiElement parent = expr.getParent();
        GrExpression child = expr;
        while (!(parent instanceof GrLoopStatement || parent instanceof GrIfStatement || parent instanceof GrVariableDeclarationOwner || parent == null)) {
            parent = parent.getParent();
            child = child.getParent();
        }
        if (parent instanceof GrWhileStatement && child == ((GrWhileStatement)parent).getCondition() || parent instanceof GrIfStatement && child == ((GrIfStatement)parent).getCondition()) {
            parent = parent.getParent();
        }
        assert (parent != null);
        if (parent instanceof GrVariableDeclarationOwner) {
            return expr;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expr.getProject());
        GrExpression tempStmt = expr;
        while (parent != tempStmt.getParent()) {
            tempStmt = tempStmt.getParent();
        }
        GrStatement toAdd = (GrStatement)tempStmt.copy();
        GrBlockStatement blockStatement = factory.createBlockStatement(new GrStatement[0]);
        if (parent instanceof GrLoopStatement) {
            ((GrLoopStatement)parent).replaceBody(blockStatement);
        } else {
            GrIfStatement ifStatement = (GrIfStatement)parent;
            if (tempStmt == ifStatement.getThenBranch()) {
                ifStatement.replaceThenBranch(blockStatement);
            } else if (tempStmt == ifStatement.getElseBranch()) {
                ifStatement.replaceElseBranch(blockStatement);
            }
        }
        GrStatement statement = blockStatement.getBlock().addStatementBefore(toAdd, null);
        expr = statement instanceof GrReturnStatement ? ((GrReturnStatement)statement).getReturnValue() : (GrExpression)statement;
        return expr;
    }

    private static GrMethod prepareNewMethod(GrCallExpression call, GrMethod method, GrReferenceExpression qualifier) throws IncorrectOperationException {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(method.getProject());
        GrMethod newMethod = factory.createMethodFromText(method.getText());
        Collection<GroovyInlineMethodUtil.ReferenceExpressionInfo> infos = GroovyInlineMethodUtil.collectReferenceInfo(method);
        if (qualifier != null) {
            GroovyInlineMethodUtil.addQualifiersToInnerReferences(newMethod, infos, qualifier);
        }
        ArrayList<PsiNamedElement> innerDefinitions = new ArrayList<PsiNamedElement>();
        GroovyMethodInliner.collectInnerDefinitions(newMethod.getBlock(), innerDefinitions);
        for (PsiNamedElement namedElement : innerDefinitions) {
            String newName;
            String name = namedElement.getName();
            if (name == null || (newName = qualifier != null ? InlineMethodConflictSolver.suggestNewName(name, method, call, qualifier.getName()) : InlineMethodConflictSolver.suggestNewName(name, method, call, new String[0])).equals(namedElement.getName())) continue;
            Collection refs = ReferencesSearch.search((PsiElement)namedElement, (SearchScope)GlobalSearchScope.projectScope((Project)namedElement.getProject()), (boolean)false).findAll();
            for (PsiReference ref : refs) {
                PsiElement element = ref.getElement();
                if (!(element instanceof GrReferenceExpression)) continue;
                GrExpression newExpr = factory.createExpressionFromText(newName);
                ((GrReferenceExpression)element).replaceWithExpression(newExpr, false);
            }
            namedElement.setName(newName);
        }
        GroovyInlineMethodUtil.replaceParametersWithArguments(call, newMethod);
        return newMethod;
    }

    private static void collectInnerDefinitions(PsiElement element, ArrayList<PsiNamedElement> defintions) {
        if (element == null) {
            return;
        }
        for (PsiElement child : element.getChildren()) {
            if (child instanceof GrVariable && !(child instanceof GrParameter)) {
                defintions.add((GrVariable)child);
            }
            if (child instanceof GrClosableBlock) continue;
            GroovyMethodInliner.collectInnerDefinitions(child, defintions);
        }
    }

    @Nullable
    static GrExpression getAloneResultExpression(GrMethod method) {
        GrOpenBlock body = method.getBlock();
        assert (body != null);
        GrStatement[] statements = body.getStatements();
        if (statements.length == 1) {
            if (statements[0] instanceof GrExpression) {
                return (GrExpression)statements[0];
            }
            if (statements[0] instanceof GrReturnStatement) {
                GrExpression value = ((GrReturnStatement)statements[0]).getReturnValue();
                if (value == null && method.getReturnType() != PsiType.VOID) {
                    return GroovyPsiElementFactory.getInstance(method.getProject()).createExpressionFromText("null");
                }
                return value;
            }
        }
        return null;
    }

    private static boolean isOnExpressionOrReturnPlace(GrCallExpression call) {
        PsiElement parent = call.getParent();
        if (!(parent instanceof GrVariableDeclarationOwner)) {
            return true;
        }
        GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)parent;
        if (owner instanceof GrClosableBlock || owner instanceof GrOpenBlock && owner.getParent() instanceof GrMethod) {
            GrStatement[] statements = ((GrCodeBlock)owner).getStatements();
            assert (statements.length > 0);
            GrStatement last = statements[statements.length - 1];
            if (last == call) {
                return true;
            }
            if (last instanceof GrReturnStatement && call == ((GrReturnStatement)last).getReturnValue()) {
                return true;
            }
        }
        return false;
    }
}

