/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameJavaVariableProcessor;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class RenameGroovyPropertyProcessor
extends RenameJavaVariableProcessor {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element) {
        ArrayList<PsiReference> arrayList;
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        if (element instanceof GrField) {
            GrAccessorMethod[] getters;
            GrField field = (GrField)element;
            PsiMethod setter = GroovyPropertyUtils.findSetterForField(field);
            GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
            if (setter != null && setter instanceof GrAccessorMethod) {
                refs.addAll(MethodReferencesSearch.search((PsiMethod)setter, (SearchScope)projectScope, (boolean)true).findAll());
            }
            for (GrAccessorMethod getter : getters = field.getGetters()) {
                refs.addAll(MethodReferencesSearch.search((PsiMethod)getter, (SearchScope)projectScope, (boolean)true).findAll());
            }
            refs.addAll(ReferencesSearch.search((PsiElement)field, (SearchScope)projectScope, (boolean)true).findAll());
            arrayList = refs;
            if (arrayList == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/rename/RenameGroovyPropertyProcessor.findReferences must not return null");
            return arrayList;
        }
        arrayList = super.findReferences(element);
        if (arrayList != null) return arrayList;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/rename/RenameGroovyPropertyProcessor.findReferences must not return null");
    }

    public void renameElement(PsiElement psiElement, String newName, UsageInfo[] usages, RefactoringElementListener listener) throws IncorrectOperationException {
        GrField field = (GrField)psiElement;
        PsiMethod getter = GroovyPropertyUtils.findGetterForField(field);
        PsiMethod setter = GroovyPropertyUtils.findSetterForField(field);
        String newGetterName = (getter != null && getter.getName().startsWith("is") ? "is" : "get") + StringUtil.capitalize((String)newName);
        String newSetterName = "set" + StringUtil.capitalize((String)newName);
        for (UsageInfo usage : usages) {
            PsiReference ref;
            PsiElement element = usage.getElement();
            if (element == null || (ref = element.getReference()) == null) continue;
            PsiElement resolved = ref.resolve();
            if (resolved instanceof GrAccessorMethod) {
                GrAccessorMethod method = (GrAccessorMethod)resolved;
                if (method == getter) {
                    ref.handleElementRename(newGetterName);
                    continue;
                }
                if (method == setter) {
                    ref.handleElementRename(newSetterName);
                    continue;
                }
                ref.handleElementRename(newName);
                continue;
            }
            ref.handleElementRename(newName);
        }
        field.setName(newName);
        listener.elementRenamed((PsiElement)field);
    }

    public boolean canProcessElement(PsiElement element) {
        return element instanceof GrField && ((GrField)element).isProperty();
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        GrField field = (GrField)element;
        PsiMethod getter = GroovyPropertyUtils.findGetterForField(field);
        PsiMethod setter = GroovyPropertyUtils.findSetterForField(field);
        if ((getter != null && !(getter instanceof GrAccessorMethod) || setter != null && !(setter instanceof GrAccessorMethod)) && RenameGroovyPropertyProcessor.askToRenameAccesors(getter, setter, newName, element.getProject())) {
            if (getter != null && !(getter instanceof GrAccessorMethod)) {
                String name = getter.getName();
                allRenames.put((PsiElement)getter, name.startsWith("is") ? "is" + StringUtil.capitalize((String)newName) : "get" + StringUtil.capitalize((String)newName));
            }
            if (setter != null && !(setter instanceof GrAccessorMethod)) {
                allRenames.put((PsiElement)setter, "set" + StringUtil.capitalize((String)newName));
            }
        }
    }

    private static boolean askToRenameAccesors(PsiMethod getter, PsiMethod setter, String newName, Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        String text = RefactoringMessageUtil.getGetterSetterMessage((String)newName, (String)RefactoringBundle.message((String)"rename.title"), (PsiMethod)getter, (PsiMethod)setter);
        return Messages.showYesNoDialog((Project)project, (String)text, (String)RefactoringBundle.message((String)"rename.title"), (Icon)Messages.getQuestionIcon()) == 0;
    }
}

