/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class GroovyScriptRunner {
    public abstract boolean isValidModule(@NotNull Module var1);

    public abstract boolean ensureRunnerConfigured(@Nullable Module var1, String var2, Project var3) throws ExecutionException;

    public abstract void configureCommandLine(JavaParameters var1, @Nullable Module var2, boolean var3, VirtualFile var4, GroovyScriptRunConfiguration var5) throws CantRunException;

    protected static String getConfPath(String groovyHomePath) {
        String confpath = FileUtil.toSystemDependentName((String)(groovyHomePath + "/conf/groovy-starter.conf"));
        if (new File(confpath).exists()) {
            return confpath;
        }
        try {
            String jarPath = PathUtil.getJarPathForClass(GroovyScriptRunner.class);
            if (new File(jarPath).isFile()) {
                return new File(jarPath, "../groovy-starter.conf").getCanonicalPath();
            }
            return new File(jarPath, "conf/groovy-starter.conf").getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void setGroovyHome(JavaParameters params, String groovyHome) {
        params.getVMParametersList().add("-Dgroovy.home=" + groovyHome);
        if (groovyHome.contains("grails")) {
            params.getVMParametersList().add("-Dgrails.home=" + groovyHome);
        }
        if (groovyHome.contains("griffon")) {
            params.getVMParametersList().add("-Dgriffon.home=" + groovyHome);
        }
    }

    protected static void setToolsJar(JavaParameters params) {
        String toolsPath;
        Sdk jdk = params.getJdk();
        if (jdk != null && jdk.getSdkType() instanceof JavaSdkType && (toolsPath = ((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk)) != null) {
            params.getVMParametersList().add("-Dtools.jar=" + toolsPath);
        }
    }

    @Nullable
    protected static VirtualFile findGroovyJar(@NotNull Module module) {
        VirtualFile[] files;
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/runner/GroovyScriptRunner.findGroovyJar must not be null");
        }
        for (VirtualFile root : files = ModuleRootManager.getInstance((Module)module).getFiles(OrderRootType.CLASSES)) {
            if (!root.getName().matches("groovy-(\\d.*)\\.jar") && !root.getName().matches("groovy-all-(.*)\\.jar")) continue;
            return root;
        }
        for (VirtualFile file : files) {
            if (!file.getName().contains("groovy") || !"jar".equals(file.getExtension())) continue;
            return file;
        }
        return null;
    }

    protected static void addClasspathFromRootModel(@Nullable Module module, boolean isTests, JavaParameters params) throws CantRunException {
        if (module == null) {
            return;
        }
        JavaParameters tmp = new JavaParameters();
        tmp.configureByModule(module, isTests ? 6 : 2);
        if (tmp.getClassPath().getVirtualFiles().isEmpty()) {
            return;
        }
        boolean embeddable = LibrariesUtil.isEmbeddableDistribution(ModuleRootManager.getInstance((Module)module).getFiles(OrderRootType.CLASSES));
        if (embeddable) {
            params.getProgramParametersList().add("--classpath");
            params.getProgramParametersList().add(tmp.getClassPath().getPathsString());
            return;
        }
        LinkedHashSet pathList = new LinkedHashSet(tmp.getClassPath().getPathList());
        for (Library library : GroovyConfigUtils.getInstance().getSDKLibrariesByModule(module)) {
            for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                pathList.remove(file.getPresentableUrl());
            }
        }
        if (pathList.isEmpty()) {
            return;
        }
        params.getProgramParametersList().add("--classpath");
        params.getProgramParametersList().add(StringUtil.join(pathList, (String)File.pathSeparator));
    }
}

