/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MavenConstantListConverter
extends ResolvingConverter<String> {
    private boolean myStrict;

    protected MavenConstantListConverter() {
        this(true);
    }

    protected MavenConstantListConverter(boolean strict) {
        this.myStrict = strict;
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (!this.myStrict) {
            return s;
        }
        return this.getValues(context).contains(s) ? s : null;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        List<String> list = this.getValues(context);
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenConstantListConverter.getVariants must not return null");
        }
        return list;
    }

    protected abstract List<String> getValues(ConvertContext var1);

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return "<html>Specified value is not acceptable here.<br>Acceptable values: " + StringUtil.join(this.getValues(context), (String)", ") + "</html>";
    }
}

