/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;

public class ChooseFileIntentionAction
implements IntentionAction {
    private FileChooserFactory myTestFileChooserFactory;

    public void setTestFileChooserFactory(FileChooserFactory factory) {
        this.myTestFileChooserFactory = factory;
    }

    @NotNull
    public String getFamilyName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction.getFamilyName must not return null");
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = MavenDomBundle.message("intention.choose.file", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction.getText must not return null");
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction.isAvailable must not be null");
        }
        if (!MavenDomUtil.isMavenFile(file)) {
            return false;
        }
        MavenDomDependency dep = this.getDependency(file, editor);
        return dep != null && "system".equals(dep.getScope().getStringValue());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction.invoke must not be null");
        }
        final MavenDomDependency dep = this.getDependency(file, editor);
        PsiFile currentValue = (PsiFile)dep.getSystemPath().getValue();
        FileChooserDialog dialog = this.getFileChooserFactory().createFileChooser(new FileChooserDescriptor(true, false, true, true, false, false), project);
        VirtualFile[] files = dialog.choose(currentValue == null ? null : currentValue.getVirtualFile(), project);
        if (files.length == 0) {
            return;
        }
        final PsiFile selectedFile = PsiManager.getInstance((Project)project).findFile(files[0]);
        if (selectedFile == null) {
            return;
        }
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                dep.getSystemPath().setValue((Object)selectedFile);
            }
        }.execute();
    }

    private FileChooserFactory getFileChooserFactory() {
        if (this.myTestFileChooserFactory != null) {
            return this.myTestFileChooserFactory;
        }
        return FileChooserFactory.getInstance();
    }

    private MavenDomDependency getDependency(PsiFile file, Editor editor) {
        PsiElement el = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset());
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)el, XmlTag.class, (boolean)false);
        if (tag == null) {
            return null;
        }
        DomElement dom = DomManager.getDomManager((Project)el.getProject()).getDomElement(tag);
        if (dom == null) {
            return null;
        }
        return (MavenDomDependency)dom.getParentOfType(MavenDomDependency.class, false);
    }
}

