/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.embedder.MavenEmbedderFactory;
import org.jetbrains.idea.maven.embedder.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;

public class MavenExternalParameters {
    public static final String MAVEN_LAUNCHER_CLASS = "org.codehaus.classworlds.Launcher";
    @NonNls
    private static final String JAVA_HOME = "JAVA_HOME";
    @NonNls
    private static final String MAVEN_OPTS = "MAVEN_OPTS";

    public static JavaParameters createJavaParameters(MavenRunnerParameters parameters, MavenGeneralSettings coreSettings, MavenRunnerSettings runnerSettings) throws ExecutionException {
        JavaParameters params = new JavaParameters();
        params.setWorkingDirectory(parameters.getWorkingDirFile());
        params.setJdk(MavenExternalParameters.getJdk(runnerSettings.getJreName()));
        String mavenHome = MavenExternalParameters.resolveMavenHome(coreSettings);
        for (String parameter : MavenExternalParameters.createVMParameters(new ArrayList<String>(), mavenHome, runnerSettings)) {
            params.getVMParametersList().add(parameter);
        }
        for (String path : MavenExternalParameters.getMavenClasspathEntries(mavenHome)) {
            params.getClassPath().add(path);
        }
        params.setMainClass(MAVEN_LAUNCHER_CLASS);
        for (String parameter : MavenExternalParameters.createMavenParameters(new ArrayList<String>(), coreSettings, runnerSettings, parameters)) {
            if (StringUtil.isEmpty((String)parameter)) continue;
            params.getProgramParametersList().add(parameter);
        }
        return params;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Sdk getJdk(String name) throws ExecutionException {
        Sdk sdk;
        if (name.equals("#JAVA_INTERNAL")) {
            sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            if (sdk == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/execution/MavenExternalParameters.getJdk must not return null");
            return sdk;
        }
        if (name.equals("#JAVA_HOME")) {
            String javaHome = System.getenv(JAVA_HOME);
            if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
                throw new ExecutionException(RunnerBundle.message("maven.java.home.undefined", new Object[0]));
            }
            Sdk jdk = JavaSdk.getInstance().createJdk("", javaHome);
            if (jdk == null) {
                throw new ExecutionException(RunnerBundle.message("maven.java.home.invalid", javaHome));
            }
            sdk = jdk;
            if (sdk == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/execution/MavenExternalParameters.getJdk must not return null");
            return sdk;
        }
        Sdk[] arr$ = ProjectJdkTable.getInstance().getAllJdks();
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            if (i$ >= len$) {
                throw new ExecutionException(RunnerBundle.message("maven.java.not.found", name));
            }
            Sdk projectJdk = arr$[i$];
            if (projectJdk.getName().equals(name)) {
                sdk = projectJdk;
                if (sdk != null) return sdk;
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/execution/MavenExternalParameters.getJdk must not return null");
            }
            ++i$;
        }
    }

    public static List<String> createVMParameters(List<String> list, String mavenHome, MavenRunnerSettings runnerSettings) {
        MavenExternalParameters.addParameters(list, runnerSettings.getVmOptions());
        MavenExternalParameters.addParameters(list, StringUtil.notNullize((String)System.getenv(MAVEN_OPTS)));
        MavenExternalParameters.addProperty(list, "classworlds.conf", MavenEmbedderFactory.getMavenConfFile(new File(mavenHome)).getPath());
        MavenExternalParameters.addProperty(list, "maven.home", mavenHome);
        return list;
    }

    private static List<String> createMavenParameters(List<String> list, MavenGeneralSettings coreSettings, MavenRunnerSettings runnerSettings, MavenRunnerParameters parameters) {
        MavenExternalParameters.encodeCoreAndRunnerSettings(coreSettings, runnerSettings, list);
        if (runnerSettings.isSkipTests()) {
            MavenExternalParameters.addProperty(list, "skipTests", "true");
        }
        for (Map.Entry<String, String> entry : runnerSettings.getMavenProperties().entrySet()) {
            MavenExternalParameters.addProperty(list, entry.getKey(), entry.getValue());
        }
        if (parameters.getPomFilePath() != null) {
            MavenExternalParameters.addOption(list, "f", parameters.getPomFilePath());
        }
        for (String goal : parameters.getGoals()) {
            list.add(goal);
        }
        MavenExternalParameters.addOption(list, "P", MavenExternalParameters.encodeProfiles(parameters.getProfiles()));
        return list;
    }

    private static void addOption(List<String> cmdList, @NonNls String key, @NonNls String value) {
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            cmdList.add("-" + key);
            cmdList.add(value);
        }
    }

    private static void addParameters(List<String> cmdList, String parameters) {
        if (!StringUtil.isEmptyOrSpaces((String)parameters)) {
            StringTokenizer tokenizer = new StringTokenizer(parameters);
            while (tokenizer.hasMoreTokens()) {
                cmdList.add(tokenizer.nextToken());
            }
        }
    }

    private static void addProperty(List<String> cmdList, @NonNls String key, @NonNls String value) {
        cmdList.add(MessageFormat.format("-D{0}={1}", key, value));
    }

    private static String resolveMavenHome(@NotNull MavenGeneralSettings coreSettings) throws ExecutionException {
        if (coreSettings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/execution/MavenExternalParameters.resolveMavenHome must not be null");
        }
        File file = MavenEmbedderFactory.resolveMavenHomeDirectory(coreSettings.getMavenHome());
        if (file == null) {
            throw new ExecutionException(RunnerBundle.message("external.maven.home.no.default", new Object[0]));
        }
        if (!file.exists()) {
            throw new ExecutionException(RunnerBundle.message("external.maven.home.does.not.exist", file.getPath()));
        }
        if (!MavenEmbedderFactory.isValidMavenHome(file)) {
            throw new ExecutionException(RunnerBundle.message("external.maven.home.invalid", file.getPath()));
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private static List<String> getMavenClasspathEntries(String mavenHome) {
        File mavenHomeBootAsFile = new File(new File(mavenHome, "core"), "boot");
        if (!mavenHomeBootAsFile.exists()) {
            mavenHomeBootAsFile = new File(mavenHome, "boot");
        }
        ArrayList<String> classpathEntries = new ArrayList<String>();
        if (mavenHomeBootAsFile.exists() && mavenHomeBootAsFile.isDirectory()) {
            for (File file : mavenHomeBootAsFile.listFiles()) {
                if (!file.getName().contains("classworlds")) continue;
                classpathEntries.add(file.getAbsolutePath());
            }
        }
        return classpathEntries;
    }

    private static void encodeCoreAndRunnerSettings(MavenGeneralSettings coreSettings, MavenRunnerSettings runnerSettings, @NonNls List<String> cmdList) {
        if (coreSettings.isWorkOffline()) {
            cmdList.add("--offline");
        }
        if (!coreSettings.isUsePluginRegistry()) {
            cmdList.add("--no-plugin-registry");
        }
        if (coreSettings.getLoggingLevel() == MavenExecutionOptions.LoggingLevel.DEBUG) {
            cmdList.add("--debug");
        }
        if (coreSettings.isNonRecursive()) {
            cmdList.add("--non-recursive");
        }
        if (coreSettings.isPrintErrorStackTraces()) {
            cmdList.add("--errors");
        }
        cmdList.add(coreSettings.getFailureBehavior().getCommandLineOption());
        cmdList.add(coreSettings.getPluginUpdatePolicy().getCommandLineOption());
        cmdList.add(coreSettings.getChecksumPolicy().getCommandLineOption());
        cmdList.add(coreSettings.getSnapshotUpdatePolicy().getCommandLineOption());
        MavenExternalParameters.addOption(cmdList, "s", coreSettings.getMavenSettingsFile());
    }

    private static String encodeProfiles(Collection<String> profiles) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String profile : profiles) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(profile);
        }
        return stringBuilder.toString();
    }
}

