/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.NullNode;
import com.intellij.ui.treeStructure.SimpleNode;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.idea.maven.navigator.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.SelectFromMavenProjectsDialog;
import org.jetbrains.idea.maven.project.MavenProject;

public class SelectMavenProjectDialog
extends SelectFromMavenProjectsDialog {
    private MavenProject myResult;

    public SelectMavenProjectDialog(Project project, final MavenProject current) {
        super(project, "Select Maven Project", MavenProjectsStructure.ProjectNode.class, new SelectFromMavenProjectsDialog.NodeSelector(){

            @Override
            public boolean shouldSelect(SimpleNode node) {
                if (node instanceof MavenProjectsStructure.ProjectNode) {
                    return ((MavenProjectsStructure.ProjectNode)node).getMavenProject() == current;
                }
                return false;
            }
        });
        this.init();
    }

    protected Action[] createActions() {
        AbstractAction selectNoneAction = new AbstractAction("&None"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectMavenProjectDialog.this.doOKAction();
                SelectMavenProjectDialog.this.myResult = null;
            }
        };
        return new Action[]{selectNoneAction, this.getOKAction(), this.getCancelAction()};
    }

    protected void doOKAction() {
        SimpleNode node = this.getSelectedNode();
        if (node instanceof NullNode) {
            node = null;
        }
        if (node != null && !(node instanceof MavenProjectsStructure.ProjectNode)) {
            ((MavenProjectsStructure.MavenSimpleNode)node).findParent(MavenProjectsStructure.ProjectNode.class);
        }
        this.myResult = node != null ? ((MavenProjectsStructure.ProjectNode)node).getMavenProject() : null;
        super.doOKAction();
    }

    public MavenProject getResult() {
        return this.myResult;
    }
}

