/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IdeaLicenseHelper {
    @NonNls
    private static final String LICENSE_PATH_PREFERRED = "idea80.key";
    @NonNls
    private static final String LICENSE_PATH_70 = "idea70.key";
    @NonNls
    private static final String LICENSE_PATH_60 = "idea60.key";
    @NonNls
    private static final String LICENSE_PATH_50 = "idea50.key";
    @NonNls
    private static final String LICENSE_PATH_40 = "idea40.key";
    @NonNls
    private static final String LICENSE_PATH_SYSTEM = "idea.license";
    @NonNls
    private static final String CONFIG_DIR_NAME = "config";
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.devkit.run.IdeaLicenseHelper");

    @Nullable
    public static File isIDEALicenseInSandbox(@NonNls String configPath, @NonNls String systemPath, @NonNls String binPath) {
        File config = new File(configPath, LICENSE_PATH_PREFERRED);
        if (config.exists()) {
            return config;
        }
        File idea70 = new File(configPath, LICENSE_PATH_70);
        if (idea70.exists()) {
            return idea70;
        }
        File idea60 = new File(configPath, LICENSE_PATH_60);
        if (idea60.exists()) {
            return idea60;
        }
        File idea5 = new File(configPath, LICENSE_PATH_50);
        if (idea5.exists()) {
            return idea5;
        }
        File idea4 = new File(configPath, LICENSE_PATH_40);
        if (idea4.exists()) {
            return idea4;
        }
        File system = new File(systemPath, LICENSE_PATH_SYSTEM);
        if (system.exists()) {
            return system;
        }
        File bin = new File(binPath, LICENSE_PATH_SYSTEM);
        if (bin.exists()) {
            return bin;
        }
        return null;
    }

    public static void copyIDEALicencse(String sandboxHome, Sdk jdk) {
        File ideaLicense;
        if (IdeaLicenseHelper.isIDEALicenseInSandbox(sandboxHome + File.separator + CONFIG_DIR_NAME, sandboxHome + File.separator + "system", jdk.getHomePath() + File.separator + "bin") == null && (ideaLicense = IdeaLicenseHelper.isIDEALicenseInSandbox(PathManager.getConfigPath(), PathManager.getSystemPath(), PathManager.getBinPath())) != null) {
            try {
                FileUtil.copy((File)ideaLicense, (File)new File(new File(sandboxHome, CONFIG_DIR_NAME), LICENSE_PATH_PREFERRED));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

