/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalInspectionTool
extends InspectionProfileEntry {
    private static final Logger LOG = Logger.getInstance((String)("#" + LocalInspectionTool.class.getName()));

    @Pattern(value="[a-zA-Z_0-9.]+")
    @NonNls
    @NotNull
    public String getID() {
        String id = this.getShortName();
        if (!StringUtil.isJavaIdentifier((String)id)) {
            LOG.error("Inspection ID must satisfy [a-zA-Z_0-9.]+ pattern. Inspection: " + this.getClass() + "; Id: '" + id + "'");
        }
        String string = id;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/LocalInspectionTool.getID must not return null");
        }
        return string;
    }

    @NonNls
    @Nullable
    public String getAlternativeID() {
        return null;
    }

    public boolean runForWholeFile() {
        return false;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/LocalInspectionTool.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/LocalInspectionTool.checkFile must not be null");
        }
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/LocalInspectionTool.buildVisitor must not be null");
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            @Override
            public void visitFile(PsiFile file) {
                this.addDescriptors(LocalInspectionTool.this.checkFile(file, holder.getManager(), isOnTheFly));
            }

            private void addDescriptors(ProblemDescriptor[] descriptors) {
                if (descriptors != null) {
                    for (ProblemDescriptor descriptor : descriptors) {
                        LOG.assertTrue(descriptor != null, (Object)LocalInspectionTool.this.getClass().getName());
                        holder.registerProblem(descriptor);
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/LocalInspectionTool.buildVisitor must not return null");
        }
        return psiElementVisitor;
    }

    @Nullable
    public PsiNamedElement getProblemElement(PsiElement psiElement) {
        return (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType(psiElement, PsiFile.class);
    }

    public void inspectionStarted(LocalInspectionToolSession session) {
    }

    public void inspectionFinished(LocalInspectionToolSession session) {
    }
}

