/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageFilter;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class CompositeLanguage
extends Language {
    private final List<LanguageFilter> myFilters = ContainerUtil.createEmptyCOWList();

    protected CompositeLanguage(String id) {
        super(id);
    }

    protected CompositeLanguage(String ID2, String ... mimeTypes) {
        super(ID2, mimeTypes);
    }

    public void registerLanguageExtension(LanguageFilter filter) {
        if (!this.myFilters.contains(filter)) {
            this.myFilters.add(filter);
        }
    }

    public boolean unregisterLanguageExtension(LanguageFilter filter) {
        return this.myFilters.remove(filter);
    }

    public Language[] getLanguageExtensionsForFile(PsiFile psi) {
        ArrayList<Language> extensions = new ArrayList<Language>(1);
        for (LanguageFilter filter : this.myFilters) {
            if (!filter.isRelevantForFile(psi)) continue;
            extensions.add(filter.getLanguage());
        }
        return extensions.toArray(new Language[extensions.size()]);
    }

    public LanguageFilter[] getLanguageExtensions() {
        return this.myFilters.toArray(new LanguageFilter[this.myFilters.size()]);
    }
}

