/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.RecursiveRootPolicy;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationOrderRootType
extends PersistentOrderRootType {
    public static OrderRootType getInstance() {
        return AnnotationOrderRootType.getOrderRootType(AnnotationOrderRootType.class);
    }

    private AnnotationOrderRootType() {
        super("ANNOTATIONS", "annotationsPath", "annotation-paths", null);
    }

    @Override
    public boolean skipWriteIfEmpty() {
        return true;
    }

    public static VirtualFile[] getFiles(OrderEntry entry) {
        ArrayList result = new ArrayList();
        RecursiveRootPolicy<List<VirtualFile>> policy = new RecursiveRootPolicy<List<VirtualFile>>(){

            @Override
            public List<VirtualFile> visitLibraryOrderEntry(LibraryOrderEntry orderEntry, List<VirtualFile> value) {
                Collections.addAll(value, orderEntry.getRootFiles(AnnotationOrderRootType.getInstance()));
                return value;
            }

            @Override
            public List<VirtualFile> visitJdkOrderEntry(JdkOrderEntry orderEntry, List<VirtualFile> value) {
                Collections.addAll(value, orderEntry.getRootFiles(AnnotationOrderRootType.getInstance()));
                return value;
            }

            @Override
            public List<VirtualFile> visitModuleSourceOrderEntry(ModuleSourceOrderEntry orderEntry, List<VirtualFile> value) {
                Collections.addAll(value, orderEntry.getRootModel().getRootPaths(AnnotationOrderRootType.getInstance()));
                return value;
            }
        };
        entry.accept(policy, result);
        return VfsUtil.toVirtualFileArray(result);
    }

    public static String[] getUrls(OrderEntry entry) {
        ArrayList result = new ArrayList();
        RecursiveRootPolicy<List<String>> policy = new RecursiveRootPolicy<List<String>>(){

            @Override
            public List<String> visitLibraryOrderEntry(LibraryOrderEntry orderEntry, List<String> value) {
                Collections.addAll(value, orderEntry.getRootUrls(AnnotationOrderRootType.getInstance()));
                return value;
            }

            @Override
            public List<String> visitJdkOrderEntry(JdkOrderEntry orderEntry, List<String> value) {
                Collections.addAll(value, orderEntry.getRootUrls(AnnotationOrderRootType.getInstance()));
                return value;
            }

            @Override
            public List<String> visitModuleSourceOrderEntry(ModuleSourceOrderEntry orderEntry, List<String> value) {
                Collections.addAll(value, orderEntry.getRootModel().getRootUrls(AnnotationOrderRootType.getInstance()));
                return value;
            }
        };
        entry.accept(policy, result);
        return ArrayUtil.toStringArray(result);
    }
}

