/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.util.Comparing;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class KeyedExtensionFactory<T, KeyT> {
    private final Class<T> myInterfaceClass;
    private final ExtensionPointName<KeyedFactoryEPBean> myEpName;

    public KeyedExtensionFactory(@NotNull Class<T> interfaceClass, @NonNls @NotNull String epName) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/KeyedExtensionFactory.<init> must not be null");
        }
        if (epName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/KeyedExtensionFactory.<init> must not be null");
        }
        this.myInterfaceClass = interfaceClass;
        this.myEpName = new ExtensionPointName(epName);
    }

    public T get() {
        final KeyedFactoryEPBean[] epBeans = (KeyedFactoryEPBean[])Extensions.getExtensions(this.myEpName);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object keyArg = args[0];
                String key = KeyedExtensionFactory.this.getKey(keyArg);
                Object result = KeyedExtensionFactory.this.getByKey(epBeans, key, method, args);
                if (result == null) {
                    result = KeyedExtensionFactory.this.getByKey(epBeans, null, method, args);
                }
                return result;
            }
        };
        return (T)Proxy.newProxyInstance(this.myInterfaceClass.getClassLoader(), new Class[]{this.myInterfaceClass}, handler);
    }

    public T getByKey(KeyT key) {
        KeyedFactoryEPBean[] epBeans;
        for (KeyedFactoryEPBean epBean : epBeans = (KeyedFactoryEPBean[])Extensions.getExtensions(this.myEpName)) {
            if (!Comparing.strEqual((String)this.getKey(key), (String)epBean.key)) continue;
            try {
                if (epBean.implementationClass == null) continue;
                return (T)epBean.instantiate(epBean.implementationClass, ApplicationManager.getApplication().getPicoContainer());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private T getByKey(KeyedFactoryEPBean[] epBeans, String key, Method method, Object[] args) {
        Object result = null;
        for (KeyedFactoryEPBean epBean : epBeans) {
            if (!Comparing.strEqual((String)epBean.key, (String)key, (boolean)true)) continue;
            try {
                if (epBean.implementationClass != null) {
                    result = epBean.instantiate(epBean.implementationClass, ApplicationManager.getApplication().getPicoContainer());
                } else {
                    Object factory = epBean.instantiate(epBean.factoryClass, ApplicationManager.getApplication().getPicoContainer());
                    result = method.invoke(factory, args);
                }
                if (result == null) continue;
                break;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (T)result;
    }

    public abstract String getKey(KeyT var1);
}

