/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.elements;

import com.intellij.compiler.ant.Generator;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.elements.RenameablePackagingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompositePackagingElement<S>
extends PackagingElement<S>
implements RenameablePackagingElement {
    private final List<PackagingElement<?>> myChildren = new ArrayList();
    private List<PackagingElement<?>> myUnmodifiableChildren;

    protected CompositePackagingElement(PackagingElementType type) {
        super(type);
    }

    public <T extends PackagingElement<?>> T addOrFindChild(@NotNull T child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/elements/CompositePackagingElement.addOrFindChild must not be null");
        }
        for (PackagingElement<?> element : this.myChildren) {
            if (!element.isEqualTo(child)) continue;
            if (element instanceof CompositePackagingElement) {
                List<PackagingElement<?>> children = ((CompositePackagingElement)child).getChildren();
                ((CompositePackagingElement)element).addOrFindChildren(children);
            }
            return (T)element;
        }
        this.myChildren.add(child);
        this.myUnmodifiableChildren = null;
        return child;
    }

    public List<? extends PackagingElement<?>> addOrFindChildren(Collection<? extends PackagingElement<?>> children) {
        ArrayList added = new ArrayList();
        for (PackagingElement<?> child : children) {
            added.add(this.addOrFindChild(child));
        }
        this.myUnmodifiableChildren = null;
        return added;
    }

    @Nullable
    public PackagingElement<?> moveChild(int index, int direction) {
        int target = index + direction;
        if (0 <= index && index < this.myChildren.size() && 0 <= target && target < this.myChildren.size()) {
            PackagingElement<?> element1 = this.myChildren.get(index);
            PackagingElement<?> element2 = this.myChildren.get(target);
            this.myChildren.set(index, element2);
            this.myChildren.set(target, element1);
            this.myUnmodifiableChildren = null;
            return element1;
        }
        return null;
    }

    public void removeChild(@NotNull PackagingElement<?> child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/elements/CompositePackagingElement.removeChild must not be null");
        }
        this.myChildren.remove(child);
        this.myUnmodifiableChildren = null;
    }

    public void removeChildren(@NotNull Collection<? extends PackagingElement<?>> children) {
        if (children == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/elements/CompositePackagingElement.removeChildren must not be null");
        }
        this.myChildren.removeAll(children);
        this.myUnmodifiableChildren = null;
    }

    @NotNull
    public List<PackagingElement<?>> getChildren() {
        if (this.myUnmodifiableChildren == null) {
            this.myUnmodifiableChildren = Collections.unmodifiableList(this.myChildren);
        }
        List<PackagingElement<?>> list = this.myUnmodifiableChildren;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/elements/CompositePackagingElement.getChildren must not return null");
        }
        return list;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    protected List<? extends Generator> computeChildrenGenerators(PackagingElementResolvingContext resolvingContext, AntCopyInstructionCreator copyInstructionCreator, ArtifactAntGenerationContext generationContext, ArtifactType artifactType) {
        ArrayList<Generator> generators = new ArrayList<Generator>();
        for (PackagingElement<?> child : this.myChildren) {
            generators.addAll(child.computeAntInstructions(resolvingContext, copyInstructionCreator, generationContext, artifactType));
        }
        return generators;
    }

    protected void computeChildrenInstructions(@NotNull IncrementalCompilerInstructionCreator creator, @NotNull PackagingElementResolvingContext resolvingContext, @NotNull ArtifactIncrementalCompilerContext compilerContext, ArtifactType artifactType) {
        if (creator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/elements/CompositePackagingElement.computeChildrenInstructions must not be null");
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/elements/CompositePackagingElement.computeChildrenInstructions must not be null");
        }
        if (compilerContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/elements/CompositePackagingElement.computeChildrenInstructions must not be null");
        }
        for (PackagingElement<?> child : this.myChildren) {
            child.computeIncrementalCompilerInstructions(creator, resolvingContext, compilerContext, artifactType);
        }
    }

    public void removeAllChildren() {
        this.myChildren.clear();
        this.myUnmodifiableChildren = null;
    }
}

