/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.AlertIcon;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public final class TabInfo
implements Queryable {
    public static final String ACTION_GROUP = "actionGroup";
    public static final String ICON = "icon";
    public static final String TAB_COLOR = "color";
    public static final String COMPONENT = "component";
    public static final String TEXT = "text";
    public static final String TAB_ACTION_GROUP = "tabActionGroup";
    public static final String ALERT_ICON = "alertIcon";
    public static final String ALERT_STATUS = "alertStatus";
    public static final String HIDDEN = "hidden";
    public static final String ENABLED = "enabled";
    private JComponent myComponent;
    private JComponent myPreferredFocusableComponent;
    private ActionGroup myGroup;
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    private Icon myIcon;
    private String myPlace;
    private Object myObject;
    private JComponent mySideComponent;
    private WeakReference<JComponent> myLastFocusOwner;
    private ActionGroup myTabLabelActions;
    private String myTabActionPlace;
    private AlertIcon myAlertIcon;
    private int myBlinkCount;
    private boolean myAlertRequested;
    private boolean myHidden;
    private JComponent myActionsContextComponent;
    private final SimpleColoredText myText = new SimpleColoredText();
    private String myTooltipText;
    private int myDefaultStyle = -1;
    private Color myDefaultForeground;
    private Color myDefaultWaveColor;
    private SimpleTextAttributes myDefaultAttributes;
    private static final AlertIcon DEFAULT_ALERT_ICON = new AlertIcon(IconLoader.getIcon((String)"/nodes/tabAlert.png"));
    private boolean myEnabled = true;
    private Color myTabColor = null;
    private Queryable myQueryable;

    public TabInfo(JComponent component) {
        this.myComponent = component;
        this.myPreferredFocusableComponent = component;
    }

    public PropertyChangeSupport getChangeSupport() {
        return this.myChangeSupport;
    }

    public TabInfo setText(String text) {
        this.clearText(false);
        this.append(text, this.getDefaultAttributes());
        return this;
    }

    private SimpleTextAttributes getDefaultAttributes() {
        if (this.myDefaultAttributes != null) {
            return this.myDefaultAttributes;
        }
        this.myDefaultAttributes = new SimpleTextAttributes(this.myDefaultStyle != -1 ? this.myDefaultStyle : 0, this.myDefaultForeground, this.myDefaultWaveColor);
        return this.myDefaultAttributes;
    }

    public TabInfo clearText(boolean invalidate) {
        String old = this.myText.toString();
        this.myText.clear();
        if (invalidate) {
            this.myChangeSupport.firePropertyChange(TEXT, old, this.myText.toString());
        }
        return this;
    }

    public TabInfo append(String fragment, SimpleTextAttributes attributes) {
        String old = this.myText.toString();
        this.myText.append(fragment, attributes);
        this.myChangeSupport.firePropertyChange(TEXT, old, this.myText.toString());
        return this;
    }

    public TabInfo setIcon(Icon icon) {
        Icon old = this.myIcon;
        this.myIcon = icon;
        this.myChangeSupport.firePropertyChange(ICON, old, icon);
        return this;
    }

    public TabInfo setComponent(Component c) {
        if (this.myComponent == c) {
            return this;
        }
        JComponent old = this.myComponent;
        this.myComponent = (JComponent)c;
        this.myChangeSupport.firePropertyChange(COMPONENT, old, this.myComponent);
        return this;
    }

    public ActionGroup getGroup() {
        return this.myGroup;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public String getText() {
        return this.myText.toString();
    }

    public SimpleColoredText getColoredText() {
        return this.myText;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getPlace() {
        return this.myPlace;
    }

    public TabInfo setSideComponent(JComponent comp) {
        this.mySideComponent = comp;
        return this;
    }

    public JComponent getSideComponent() {
        return this.mySideComponent;
    }

    public TabInfo setActions(ActionGroup group, String place) {
        ActionGroup old = this.myGroup;
        this.myGroup = group;
        this.myPlace = place;
        this.myChangeSupport.firePropertyChange(ACTION_GROUP, old, this.myGroup);
        return this;
    }

    public TabInfo setActionsContextComponent(JComponent c) {
        this.myActionsContextComponent = c;
        return this;
    }

    public JComponent getActionsContextComponent() {
        return this.myActionsContextComponent;
    }

    public TabInfo setObject(Object object) {
        this.myObject = object;
        return this;
    }

    public Object getObject() {
        return this.myObject;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myPreferredFocusableComponent != null ? this.myPreferredFocusableComponent : this.myComponent;
    }

    public TabInfo setPreferredFocusableComponent(JComponent component) {
        this.myPreferredFocusableComponent = component;
        return this;
    }

    public void setLastFocusOwner(JComponent owner) {
        this.myLastFocusOwner = new WeakReference<JComponent>(owner);
    }

    public ActionGroup getTabLabelActions() {
        return this.myTabLabelActions;
    }

    public String getTabActionPlace() {
        return this.myTabActionPlace;
    }

    public TabInfo setTabLabelActions(ActionGroup tabActions, String place) {
        ActionGroup old = this.myTabLabelActions;
        this.myTabLabelActions = tabActions;
        this.myTabActionPlace = place;
        this.myChangeSupport.firePropertyChange(TAB_ACTION_GROUP, old, this.myTabLabelActions);
        return this;
    }

    @Nullable
    public JComponent getLastFocusOwner() {
        return this.myLastFocusOwner != null ? (JComponent)this.myLastFocusOwner.get() : null;
    }

    public TabInfo setAlertIcon(AlertIcon alertIcon) {
        AlertIcon old = this.myAlertIcon;
        this.myAlertIcon = alertIcon;
        this.myChangeSupport.firePropertyChange(ALERT_ICON, old, this.myAlertIcon);
        return this;
    }

    public void fireAlert() {
        this.myAlertRequested = true;
        this.myChangeSupport.firePropertyChange(ALERT_STATUS, null, (Object)true);
    }

    public void stopAlerting() {
        this.myAlertRequested = false;
        this.myChangeSupport.firePropertyChange(ALERT_STATUS, null, (Object)false);
    }

    public int getBlinkCount() {
        return this.myBlinkCount;
    }

    public void setBlinkCount(int blinkCount) {
        this.myBlinkCount = blinkCount;
    }

    public String toString() {
        return this.getText();
    }

    public AlertIcon getAlertIcon() {
        return this.myAlertIcon == null ? DEFAULT_ALERT_ICON : this.myAlertIcon;
    }

    public void resetAlertRequest() {
        this.myAlertRequested = false;
    }

    public boolean isAlertRequested() {
        return this.myAlertRequested;
    }

    public void setHidden(boolean hidden) {
        boolean old = this.myHidden;
        this.myHidden = hidden;
        this.myChangeSupport.firePropertyChange(HIDDEN, old, this.myHidden);
    }

    public boolean isHidden() {
        return this.myHidden;
    }

    public void setEnabled(boolean enabled) {
        boolean old = this.myEnabled;
        this.myEnabled = enabled;
        this.myChangeSupport.firePropertyChange(ENABLED, old, this.myEnabled);
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public TabInfo setDefaultStyle(int style) {
        this.myDefaultStyle = style;
        this.myDefaultAttributes = null;
        this.update();
        return this;
    }

    public TabInfo setDefaultForeground(Color fg) {
        this.myDefaultForeground = fg;
        this.myDefaultAttributes = null;
        this.update();
        return this;
    }

    public Color getDefaultForeground() {
        return this.myDefaultForeground;
    }

    public TabInfo setDefaultWaveColor(Color waveColor) {
        this.myDefaultWaveColor = waveColor;
        this.myDefaultAttributes = null;
        this.update();
        return this;
    }

    private void update() {
        this.setText(this.getText());
    }

    public TabInfo setTooltipText(String text) {
        String old = this.myTooltipText;
        this.myTooltipText = text;
        this.myChangeSupport.firePropertyChange(TEXT, old, this.myTooltipText);
        return this;
    }

    public String getTooltipText() {
        return this.myTooltipText;
    }

    public TabInfo setTabColor(Color color) {
        Color old = this.myTabColor;
        this.myTabColor = color;
        this.myChangeSupport.firePropertyChange(TAB_COLOR, old, color);
        return this;
    }

    public Color getTabColor() {
        return this.myTabColor;
    }

    public TabInfo setTestableUi(Queryable queryable) {
        this.myQueryable = queryable;
        return this;
    }

    @Override
    public void putInfo(Map<String, String> info) {
        if (this.myQueryable != null) {
            this.myQueryable.putInfo(info);
        }
    }
}

