/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui.actions.generate;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateDomElementAction
extends CodeInsightAction {
    protected final GenerateDomElementProvider myProvider;

    public GenerateDomElementAction(@NotNull GenerateDomElementProvider generateProvider, @Nullable Icon icon) {
        if (generateProvider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ui/actions/generate/GenerateDomElementAction.<init> must not be null");
        }
        this.getTemplatePresentation().setDescription(generateProvider.getDescription());
        this.getTemplatePresentation().setText(generateProvider.getDescription());
        this.getTemplatePresentation().setIcon(icon);
        this.myProvider = generateProvider;
    }

    public GenerateDomElementAction(GenerateDomElementProvider generateProvider) {
        this(generateProvider, null);
    }

    @Override
    protected CodeInsightActionHandler getHandler() {
        return new CodeInsightActionHandler(){

            @Override
            public void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ui/actions/generate/GenerateDomElementAction$1.invoke must not be null");
                }
                if (editor == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/ui/actions/generate/GenerateDomElementAction$1.invoke must not be null");
                }
                if (file == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/xml/ui/actions/generate/GenerateDomElementAction$1.invoke must not be null");
                }
                final Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Object element = GenerateDomElementAction.this.myProvider.generate(project, editor, file);
                        GenerateDomElementAction.this.myProvider.navigate((DomElement)element);
                    }
                };
                if (GenerateDomElementAction.this.startInWriteAction()) {
                    new WriteCommandAction(project, new PsiFile[]{file}){

                        @Override
                        protected void run(Result result) throws Throwable {
                            runnable.run();
                        }
                    }.execute();
                } else {
                    runnable.run();
                }
            }

            @Override
            public boolean startInWriteAction() {
                return false;
            }
        };
    }

    protected boolean startInWriteAction() {
        return true;
    }

    @Override
    protected boolean isValidForFile(Project project, Editor editor, PsiFile file) {
        DomElement element = DomUtil.getContextElement(editor);
        return element != null && this.myProvider.isAvailableForElement(element);
    }
}

