/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.Random;
import javax.swing.tree.DefaultMutableTreeNode;

public class DynamicTreeNode
extends DefaultMutableTreeNode {
    protected static float nameCount;
    protected static String[] names;
    protected static Font[] fonts;
    protected static Random nameGen;
    protected static final int DefaultChildrenCount = 7;
    protected boolean hasLoaded;

    public DynamicTreeNode(Object object) {
        super(object);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getChildCount() {
        if (!this.hasLoaded) {
            this.loadChildren();
        }
        return super.getChildCount();
    }

    protected void loadChildren() {
        for (int i = 0; i < 7; ++i) {
            int n = (int)(nameGen.nextFloat() * nameCount);
            Font font = fonts != null ? fonts[n] : null;
            SampleData sampleData = i % 2 == 0 ? new SampleData(font, Color.red, names[n]) : new SampleData(font, Color.blue, names[n]);
            DynamicTreeNode dynamicTreeNode = new DynamicTreeNode(sampleData);
            this.insert(dynamicTreeNode, i);
        }
        this.hasLoaded = true;
    }

    static {
        String[] stringArray;
        try {
            stringArray = Toolkit.getDefaultToolkit().getFontList();
        }
        catch (Exception exception) {
            stringArray = null;
        }
        if (stringArray == null || stringArray.length == 0) {
            names = new String[]{"Mark Andrews", "Tom Ball", "Alan Chung", "Rob Davis", "Jeff Dinkins", "Amy Fowler", "James Gosling", "David Karlton", "Dave Kloba", "Dave Moore", "Hans Muller", "Rick Levenson", "Tim Prinzing", "Chester Rose", "Ray Ryan", "Georges Saab", "Scott Violet", "Kathy Walrath", "Arnaud Weber"};
        } else {
            int n = 12;
            names = stringArray;
            fonts = new Font[names.length];
            int n2 = names.length;
            for (int i = 0; i < n2; ++i) {
                try {
                    DynamicTreeNode.fonts[i] = new Font(stringArray[i], 0, n);
                }
                catch (Exception exception) {
                    DynamicTreeNode.fonts[i] = null;
                }
                n = (n + 2 - 12) % 12 + 12;
            }
        }
        nameCount = names.length;
        nameGen = new Random(System.currentTimeMillis());
    }
}

