/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingChooser;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

class PackageWriter
extends BandStructure {
    Package pkg;
    OutputStream finalOut;
    HashSet requiredEntries;
    HashMap backCountTable;
    int[][] attrCounts;
    int[] maxFlags;
    HashMap[] allLayouts;
    Attribute.Layout[] attrDefsWritten;
    private Code curCode;
    private Package.Class curClass;
    private ConstantPool.Entry[] curCPMap;
    int[] codeHist = new int[256];
    int[] ldcHist = new int[20];

    PackageWriter(Package package_, OutputStream outputStream) throws IOException {
        this.pkg = package_;
        this.finalOut = outputStream;
        this.initPackageMajver(package_.package_majver);
    }

    void write() throws IOException {
        boolean bl = false;
        try {
            if (this.verbose > 0) {
                Utils.log.info("Setting up constant pool...");
            }
            this.setup();
            if (this.verbose > 0) {
                Utils.log.info("Packing...");
            }
            this.writeConstantPool();
            this.writeFiles();
            this.writeAttrDefs();
            this.writeInnerClasses();
            this.writeClassesAndByteCodes();
            this.writeAttrCounts();
            if (this.verbose > 1) {
                this.printCodeHist();
            }
            if (this.verbose > 0) {
                Utils.log.info("Coding...");
            }
            this.all_bands.chooseBandCodings();
            this.writeFileHeader();
            this.writeAllBandsTo(this.finalOut);
            bl = true;
        }
        catch (Exception exception) {
            Utils.log.log(Level.WARNING, "Error on output: " + exception, exception);
            if (this.verbose > 0) {
                this.finalOut.close();
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("error packing", exception);
        }
    }

    void setup() {
        this.requiredEntries = new HashSet();
        this.setArchiveOptions();
        this.trimClassAttributes();
        this.collectAttributeLayouts();
        this.pkg.buildGlobalConstantPool(this.requiredEntries);
        this.setBandIndexes();
        this.makeNewAttributeBands();
        this.collectInnerClasses();
    }

    void setArchiveOptions() {
        Object object;
        int n;
        int n2 = this.pkg.default_modtime;
        int n3 = this.pkg.default_modtime;
        int n4 = -1;
        int n5 = 0;
        this.archiveOptions |= this.pkg.default_options;
        for (Package.File file : this.pkg.files) {
            n = file.modtime;
            int n6 = file.options;
            if (n2 == 0) {
                n2 = n3 = n;
            } else {
                if (n2 > n) {
                    n2 = n;
                }
                if (n3 < n) {
                    n3 = n;
                }
            }
            n4 &= n6;
            n5 |= n6;
        }
        if (this.pkg.default_modtime == 0) {
            this.pkg.default_modtime = n2;
        }
        if (n2 != 0 && n2 != n3) {
            this.archiveOptions |= 0x40;
        }
        if (!PackageWriter.testBit(this.archiveOptions, 32) && n4 != -1) {
            if (PackageWriter.testBit(n4, 1)) {
                this.archiveOptions |= 0x20;
                --n4;
                --n5;
            }
            this.pkg.default_options |= n4;
            if (n4 != n5 || n4 != this.pkg.default_options) {
                this.archiveOptions |= 0x80;
            }
        }
        HashMap hashMap = new HashMap();
        int n7 = 0;
        n = -1;
        for (Package.Class clazz : this.pkg.classes) {
            int n8;
            int n9 = clazz.getVersion();
            object = (int[])hashMap.get(new Integer(n9));
            if (object == null) {
                object = new int[1];
                hashMap.put(new Integer(n9), object);
            }
            if (n7 >= (n8 = (object[0] = object[0] + 1))) continue;
            n7 = n8;
            n = n9;
        }
        hashMap.clear();
        if (n == -1) {
            n = 0;
        }
        char c = (char)(n >>> 16);
        char c2 = (char)n;
        this.pkg.default_class_majver = (short)c;
        this.pkg.default_class_minver = (short)c2;
        String string = Package.versionStringOf(c, c2);
        if (this.verbose > 0) {
            Utils.log.info("Consensus version number in segment is " + string);
        }
        if (this.verbose > 0) {
            Utils.log.info("Highest version number in segment is " + Package.versionStringOf(this.pkg.getHighestClassVersion()));
        }
        object = this.pkg.classes.iterator();
        while (object.hasNext()) {
            Package.Class clazz = (Package.Class)object.next();
            if (clazz.getVersion() == n) continue;
            Attribute attribute = this.makeClassFileVersionAttr(clazz.minver, clazz.majver);
            if (this.verbose > 1) {
                Object object2 = clazz.getVersionString();
                String string2 = string;
                Utils.log.fine("Version " + (String)object2 + " of " + clazz + " doesn't match package version " + (String)string2);
            }
            clazz.addAttribute(attribute);
        }
        for (Package.File file : this.pkg.files) {
            long l = file.getFileLength();
            if (l == (long)((int)l)) continue;
            this.archiveOptions |= 0x100;
            if (this.verbose <= 0) break;
            Utils.log.info("Note: Huge resource file " + file.getFileName() + " forces 64-bit sizing");
            break;
        }
        int n10 = 0;
        int n11 = 0;
        for (Object object2 : this.pkg.classes) {
            for (Package.Class.Method method : ((Package.Class)object2).getMethods()) {
                if (method.code == null) continue;
                if (method.code.attributeSize() == 0) {
                    ++n11;
                    continue;
                }
                if (PackageWriter.shortCodeHeader(method.code) == 0) continue;
                n10 += 3;
            }
        }
        if (n10 > n11) {
            this.archiveOptions |= 4;
        }
        if (this.verbose > 0) {
            Utils.log.info("archiveOptions = 0b" + Integer.toBinaryString(this.archiveOptions));
        }
    }

    void writeFileHeader() throws IOException {
        this.pkg.checkVersion();
        this.writeArchiveMagic();
        this.writeArchiveHeader();
    }

    private void putMagicInt32(int n) throws IOException {
        int n2 = n;
        for (int i = 0; i < 4; ++i) {
            this.archive_magic.putByte(0xFF & n2 >>> 24);
            n2 <<= 8;
        }
    }

    void writeArchiveMagic() throws IOException {
        this.putMagicInt32(this.pkg.magic);
    }

    void writeArchiveHeader() throws IOException {
        boolean bl;
        boolean bl2;
        int n = 0;
        boolean bl3 = PackageWriter.testBit(this.archiveOptions, 1);
        if (!bl3) {
            bl3 |= this.band_headers.length() != 0;
            if (bl3 |= this.attrDefsWritten.length != 0) {
                this.archiveOptions |= 1;
            }
        }
        if (!bl3) {
            n += 2;
        }
        if (!(bl2 = PackageWriter.testBit(this.archiveOptions, 16))) {
            bl2 |= this.archiveNextCount > 0;
            if (bl2 |= this.pkg.default_modtime != 0) {
                this.archiveOptions |= 0x10;
            }
        }
        if (!bl2) {
            n += 5;
        }
        if (!(bl = PackageWriter.testBit(this.archiveOptions, 2)) && (bl |= this.pkg.cp.haveNumbers())) {
            this.archiveOptions |= 2;
        }
        if (!bl) {
            n += 4;
        }
        assert (this.pkg.package_majver > 0);
        this.archive_header_0.putInt(this.pkg.package_minver);
        this.archive_header_0.putInt(this.pkg.package_majver);
        if (this.verbose > 0) {
            Utils.log.info("Package Version for this segment:" + Package.versionStringOf(this.pkg.getPackageVersion()));
        }
        this.archive_header_0.putInt(this.archiveOptions);
        assert (this.archive_header_0.length() == 3);
        if (bl2) {
            assert (this.archive_header_S.length() == 0);
            this.archive_header_S.putInt(0);
            assert (this.archive_header_S.length() == 1);
            this.archive_header_S.putInt(0);
            assert (this.archive_header_S.length() == 2);
        }
        if (bl2) {
            this.archive_header_1.putInt(this.archiveNextCount);
            this.archive_header_1.putInt(this.pkg.default_modtime);
            this.archive_header_1.putInt(this.pkg.files.size());
        } else assert (this.pkg.files.size() == 0);
        if (bl3) {
            this.archive_header_1.putInt(this.band_headers.length());
            this.archive_header_1.putInt(this.attrDefsWritten.length);
        } else {
            assert (this.band_headers.length() == 0);
            assert (this.attrDefsWritten.length == 0);
        }
        this.writeConstantPoolCounts(bl);
        this.archive_header_1.putInt(this.pkg.getAllInnerClasses().size());
        this.archive_header_1.putInt(this.pkg.default_class_minver);
        this.archive_header_1.putInt(this.pkg.default_class_majver);
        this.archive_header_1.putInt(this.pkg.classes.size());
        assert (this.archive_header_0.length() + this.archive_header_S.length() + this.archive_header_1.length() == 26 - n);
        this.archiveSize0 = 0L;
        this.archiveSize1 = this.all_bands.outputSize();
        this.archiveSize0 += this.archive_magic.outputSize();
        this.archiveSize0 += this.archive_header_0.outputSize();
        this.archiveSize0 += this.archive_header_S.outputSize();
        this.archiveSize1 -= this.archiveSize0;
        if (bl2) {
            int n2 = (int)(this.archiveSize1 >>> 32);
            int n3 = (int)(this.archiveSize1 >>> 0);
            this.archive_header_S.patchValue(0, n2);
            this.archive_header_S.patchValue(1, n3);
            int n4 = UNSIGNED5.getLength(0);
            this.archiveSize0 += (long)(UNSIGNED5.getLength(n2) - n4);
            this.archiveSize0 += (long)(UNSIGNED5.getLength(n3) - n4);
        }
        if (this.verbose > 1) {
            Utils.log.fine("archive sizes: " + this.archiveSize0 + "+" + this.archiveSize1);
        }
        assert (this.all_bands.outputSize() == this.archiveSize0 + this.archiveSize1);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeConstantPoolCounts(boolean bl) throws IOException {
        int n = 0;
        while (true) {
            block8: {
                if (n >= ConstantPool.TAGS_IN_ORDER.length) {
                    return;
                }
                byte by = ConstantPool.TAGS_IN_ORDER[n];
                int n2 = this.pkg.cp.getIndexByTag(by).size();
                switch (by) {
                    case 1: {
                        if (n2 > 0) assert (this.pkg.cp.getIndexByTag(by).get(0) == ConstantPool.getUtf8Entry(""));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (bl) break;
                        assert (n2 == 0);
                        break block8;
                    }
                }
                this.archive_header_1.putInt(n2);
            }
            ++n;
        }
    }

    @Override
    protected ConstantPool.Index getCPIndex(byte by) {
        return this.pkg.cp.getIndexByTag(by);
    }

    void writeConstantPool() throws IOException {
        ConstantPool.IndexGroup indexGroup = this.pkg.cp;
        if (this.verbose > 0) {
            Utils.log.info("Writing CP");
        }
        block14: for (int i = 0; i < ConstantPool.TAGS_IN_ORDER.length; ++i) {
            byte by = ConstantPool.TAGS_IN_ORDER[i];
            ConstantPool.Index index = indexGroup.getIndexByTag(by);
            ConstantPool.Entry[] entryArray = index.cpMap;
            if (this.verbose > 0) {
                Utils.log.info("Writing " + entryArray.length + " " + ConstantPool.tagName(by) + " entries...");
            }
            if (this.optDumpBands) {
                PrintStream printStream = new PrintStream(PackageWriter.getDumpStream(index, ".idx"));
                PackageWriter.printArrayTo(printStream, entryArray, 0, entryArray.length);
                printStream.close();
            }
            switch (by) {
                case 1: {
                    this.writeUtf8Bands(entryArray);
                    continue block14;
                }
                case 3: {
                    ConstantPool.Entry entry;
                    for (int j = 0; j < entryArray.length; ++j) {
                        entry = (ConstantPool.NumberEntry)entryArray[j];
                        int n = (Integer)((ConstantPool.NumberEntry)entry).numberValue();
                        this.cp_Int.putInt(n);
                    }
                    continue block14;
                }
                case 4: {
                    ConstantPool.Entry entry;
                    for (int j = 0; j < entryArray.length; ++j) {
                        entry = (ConstantPool.NumberEntry)entryArray[j];
                        float f = ((Float)((ConstantPool.NumberEntry)entry).numberValue()).floatValue();
                        int n = Float.floatToIntBits(f);
                        this.cp_Float.putInt(n);
                    }
                    continue block14;
                }
                case 5: {
                    ConstantPool.Entry entry;
                    for (int j = 0; j < entryArray.length; ++j) {
                        entry = (ConstantPool.NumberEntry)entryArray[j];
                        long l = (Long)((ConstantPool.NumberEntry)entry).numberValue();
                        this.cp_Long_hi.putInt((int)(l >>> 32));
                        this.cp_Long_lo.putInt((int)(l >>> 0));
                    }
                    continue block14;
                }
                case 6: {
                    ConstantPool.Entry entry;
                    for (int j = 0; j < entryArray.length; ++j) {
                        entry = (ConstantPool.NumberEntry)entryArray[j];
                        double d = (Double)((ConstantPool.NumberEntry)entry).numberValue();
                        long l = Double.doubleToLongBits(d);
                        this.cp_Double_hi.putInt((int)(l >>> 32));
                        this.cp_Double_lo.putInt((int)(l >>> 0));
                    }
                    continue block14;
                }
                case 8: {
                    ConstantPool.Entry entry;
                    for (int j = 0; j < entryArray.length; ++j) {
                        entry = (ConstantPool.StringEntry)entryArray[j];
                        this.cp_String.putRef(((ConstantPool.StringEntry)entry).ref);
                    }
                    continue block14;
                }
                case 7: {
                    ConstantPool.Entry entry;
                    for (int j = 0; j < entryArray.length; ++j) {
                        entry = (ConstantPool.ClassEntry)entryArray[j];
                        this.cp_Class.putRef(((ConstantPool.ClassEntry)entry).ref);
                    }
                    continue block14;
                }
                case 13: {
                    this.writeSignatureBands(entryArray);
                    continue block14;
                }
                case 12: {
                    ConstantPool.Entry entry;
                    for (int j = 0; j < entryArray.length; ++j) {
                        entry = (ConstantPool.DescriptorEntry)entryArray[j];
                        this.cp_Descr_name.putRef(((ConstantPool.DescriptorEntry)entry).nameRef);
                        this.cp_Descr_type.putRef(((ConstantPool.DescriptorEntry)entry).typeRef);
                    }
                    continue block14;
                }
                case 9: {
                    this.writeMemberRefs(by, entryArray, this.cp_Field_class, this.cp_Field_desc);
                    continue block14;
                }
                case 10: {
                    this.writeMemberRefs(by, entryArray, this.cp_Method_class, this.cp_Method_desc);
                    continue block14;
                }
                case 11: {
                    this.writeMemberRefs(by, entryArray, this.cp_Imethod_class, this.cp_Imethod_desc);
                    continue block14;
                }
                default: {
                    assert (false);
                    continue block14;
                }
            }
        }
    }

    void writeUtf8Bands(ConstantPool.Entry[] entryArray) throws IOException {
        int n;
        int n2;
        if (entryArray.length == 0) {
            return;
        }
        assert (entryArray[0].stringValue().equals(""));
        char[][] cArrayArray = new char[entryArray.length][];
        for (int i = 0; i < cArrayArray.length; ++i) {
            cArrayArray[i] = entryArray[i].stringValue().toCharArray();
        }
        int[] nArray = new int[entryArray.length];
        char[] cArray = new char[]{};
        for (n2 = 0; n2 < cArrayArray.length; ++n2) {
            int n3;
            char[] cArray2 = cArrayArray[n2];
            n = Math.min(cArray2.length, cArray.length);
            for (n3 = 0; n3 < n && cArray2[n3] == cArray[n3]; ++n3) {
            }
            nArray[n2] = n3;
            if (n2 >= 2) {
                this.cp_Utf8_prefix.putInt(n3);
            } else assert (n3 == 0);
            cArray = cArray2;
        }
        for (n2 = 0; n2 < cArrayArray.length; ++n2) {
            int n4;
            int n5;
            char[] cArray3 = cArrayArray[n2];
            int n6 = nArray[n2];
            n = cArray3.length - nArray[n2];
            boolean bl = false;
            if (n == 0) {
                bl = n2 >= 1;
            } else if (this.optBigStrings && this.effort > 1 && n > 100) {
                n5 = 0;
                for (n4 = 0; n4 < n; ++n4) {
                    if (cArray3[n6 + n4] <= '\u007f') continue;
                    ++n5;
                }
                if (n5 > 100) {
                    bl = this.tryAlternateEncoding(n2, n5, cArray3, n6);
                }
            }
            if (n2 < 1) {
                assert (!bl);
                assert (n == 0);
                continue;
            }
            if (bl) {
                this.cp_Utf8_suffix.putInt(0);
                this.cp_Utf8_big_suffix.putInt(n);
                continue;
            }
            assert (n != 0);
            this.cp_Utf8_suffix.putInt(n);
            for (n5 = 0; n5 < n; ++n5) {
                n4 = cArray3[n6 + n5];
                this.cp_Utf8_chars.putInt(n4);
            }
        }
        if (this.verbose > 0) {
            n2 = this.cp_Utf8_chars.length();
            int n7 = this.cp_Utf8_big_chars.length();
            int n8 = n2 + n7;
            Utils.log.info("Utf8string #CHARS=" + n8 + " #PACKEDCHARS=" + n7);
        }
    }

    private boolean tryAlternateEncoding(int n, int n2, char[] cArray, int n3) {
        int n4 = cArray.length - n3;
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = cArray[n3 + i];
        }
        CodingChooser codingChooser = this.getCodingChooser();
        Coding coding = this.cp_Utf8_big_chars.regularCoding;
        String string = "(Utf8_big_" + n + ")";
        int[] nArray2 = new int[]{0, 0};
        if (this.verbose > 1 || codingChooser.verbose > 1) {
            Utils.log.fine("--- chooseCoding " + string);
        }
        CodingMethod codingMethod = codingChooser.choose(nArray, coding, nArray2);
        Coding coding2 = this.cp_Utf8_chars.regularCoding;
        if (this.verbose > 1) {
            Utils.log.fine("big string[" + n + "] len=" + n4 + " #wide=" + n2 + " size=" + nArray2[0] + "/z=" + nArray2[1] + " coding " + codingMethod);
        }
        if (codingMethod != coding2) {
            int n5 = nArray2[1];
            int[] nArray3 = codingChooser.computeSize(coding2, nArray);
            int n6 = nArray3[1];
            int n7 = Math.max(5, n6 / 1000);
            if (this.verbose > 1) {
                Utils.log.fine("big string[" + n + "] normalSize=" + nArray3[0] + "/z=" + nArray3[1] + " win=" + (n5 < n6 - n7));
            }
            if (n5 < n6 - n7) {
                BandStructure.IntBand intBand = this.cp_Utf8_big_chars.newIntBand(string);
                intBand.initializeValues(nArray);
                return true;
            }
        }
        return false;
    }

    void writeSignatureBands(ConstantPool.Entry[] entryArray) throws IOException {
        for (int i = 0; i < entryArray.length; ++i) {
            ConstantPool.SignatureEntry signatureEntry = (ConstantPool.SignatureEntry)entryArray[i];
            this.cp_Signature_form.putRef(signatureEntry.formRef);
            for (int j = 0; j < signatureEntry.classRefs.length; ++j) {
                this.cp_Signature_classes.putRef(signatureEntry.classRefs[j]);
            }
        }
    }

    void writeMemberRefs(byte by, ConstantPool.Entry[] entryArray, BandStructure.CPRefBand cPRefBand, BandStructure.CPRefBand cPRefBand2) throws IOException {
        for (int i = 0; i < entryArray.length; ++i) {
            ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)entryArray[i];
            cPRefBand.putRef(memberEntry.classRef);
            cPRefBand2.putRef(memberEntry.descRef);
        }
    }

    void writeFiles() throws IOException {
        int n = this.pkg.files.size();
        if (n == 0) {
            return;
        }
        int n2 = this.archiveOptions;
        boolean bl = PackageWriter.testBit(n2, 256);
        boolean bl2 = PackageWriter.testBit(n2, 64);
        boolean bl3 = PackageWriter.testBit(n2, 128);
        if (!bl3) {
            for (Package.File file : this.pkg.files) {
                if (!file.isClassStub()) continue;
                bl3 = true;
                this.archiveOptions = n2 |= 0x80;
                break;
            }
        }
        if (bl || bl2 || bl3 || !this.pkg.files.isEmpty()) {
            this.archiveOptions = n2 |= 0x10;
        }
        for (Package.File file : this.pkg.files) {
            this.file_name.putRef(file.name);
            long l = file.getFileLength();
            this.file_size_lo.putInt((int)l);
            if (bl) {
                this.file_size_hi.putInt((int)(l >>> 32));
            }
            if (bl2) {
                this.file_modtime.putInt(file.modtime - this.pkg.default_modtime);
            }
            if (bl3) {
                this.file_options.putInt(file.options);
            }
            file.writeTo(this.file_bits.collectorStream());
            if (this.verbose <= 1) continue;
            Utils.log.fine("Wrote " + l + " bytes of " + file.name.stringValue());
        }
        if (this.verbose > 0) {
            Utils.log.info("Wrote " + n + " resource files");
        }
    }

    void collectAttributeLayouts() {
        int n;
        this.maxFlags = new int[4];
        this.allLayouts = new HashMap[4];
        for (int i = 0; i < 4; ++i) {
            this.allLayouts[i] = new HashMap();
        }
        for (Package.Class clazz : this.pkg.classes) {
            this.visitAttributeLayoutsIn(0, clazz);
            for (Package.Class.Member member : clazz.getFields()) {
                this.visitAttributeLayoutsIn(1, member);
            }
            for (Package.Class.Member member : clazz.getMethods()) {
                this.visitAttributeLayoutsIn(2, member);
                if (((Package.Class.Method)member).code == null) continue;
                this.visitAttributeLayoutsIn(3, ((Package.Class.Method)member).code);
            }
        }
        for (n = 0; n < 4; ++n) {
            int n2 = this.allLayouts[n].size();
            boolean bl = this.haveFlagsHi(n);
            if (n2 >= 24) {
                int n3 = 1 << 9 + n;
                this.archiveOptions |= n3;
                bl = true;
                if (this.verbose > 0) {
                    Utils.log.info("Note: Many " + Attribute.contextName(n) + " attributes forces 63-bit flags");
                }
            }
            if (this.verbose > 1) {
                Utils.log.fine(Attribute.contextName(n) + ".maxFlags = 0x" + Integer.toHexString(this.maxFlags[n]));
                Utils.log.fine(Attribute.contextName(n) + ".#layouts = " + n2);
            }
            assert (this.haveFlagsHi(n) == bl);
        }
        this.initAttrIndexLimit();
        for (n = 0; n < 4; ++n) {
            assert ((this.attrFlagMask[n] & (long)this.maxFlags[n]) == 0L);
        }
        this.backCountTable = new HashMap();
        this.attrCounts = new int[4][];
        for (n = 0; n < 4; ++n) {
            long l = ((long)this.maxFlags[n] | this.attrFlagMask[n]) ^ 0xFFFFFFFFFFFFFFFFL;
            assert (this.attrIndexLimit[n] > 0);
            assert (this.attrIndexLimit[n] < 64);
            l &= (1L << this.attrIndexLimit[n]) - 1L;
            int n4 = 0;
            Map.Entry[] entryArray = new Map.Entry[this.allLayouts[n].size()];
            this.allLayouts[n].entrySet().toArray(entryArray);
            Arrays.sort(entryArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Map.Entry entry = (Map.Entry)object;
                    Map.Entry entry2 = (Map.Entry)object2;
                    int n = -(((int[])entry.getValue())[0] - ((int[])entry2.getValue())[0]);
                    if (n != 0) {
                        return n;
                    }
                    return ((Comparable)entry.getKey()).compareTo(entry2.getKey());
                }
            });
            this.attrCounts[n] = new int[this.attrIndexLimit[n] + entryArray.length];
            for (int i = 0; i < entryArray.length; ++i) {
                int n5;
                Map.Entry entry = entryArray[i];
                Attribute.Layout layout = (Attribute.Layout)entry.getKey();
                int n6 = ((int[])entry.getValue())[0];
                Integer n7 = (Integer)this.attrIndexTable.get(layout);
                if (n7 != null) {
                    n5 = n7;
                } else if (l != 0L) {
                    while ((l & 1L) == 0L) {
                        l >>>= 1;
                        ++n4;
                    }
                    --l;
                    n5 = this.setAttributeLayoutIndex(layout, n4);
                } else {
                    n5 = this.setAttributeLayoutIndex(layout, -1);
                }
                this.attrCounts[n][n5] = n6;
                Attribute.Layout.Element[] elementArray = layout.getCallables();
                int[] nArray = new int[elementArray.length];
                for (int j = 0; j < elementArray.length; ++j) {
                    assert (elementArray[j].kind == 10);
                    if (elementArray[j].flagTest((byte)8)) continue;
                    nArray[j] = -1;
                }
                this.backCountTable.put(layout, nArray);
                if (n7 != null) continue;
                ConstantPool.Utf8Entry utf8Entry = ConstantPool.getUtf8Entry(layout.name());
                String string = layout.layoutForPackageMajver(this.getPackageMajver());
                ConstantPool.Utf8Entry utf8Entry2 = ConstantPool.getUtf8Entry(string);
                this.requiredEntries.add(utf8Entry);
                this.requiredEntries.add(utf8Entry2);
                if (this.verbose <= 0) continue;
                if (n5 < this.attrIndexLimit[n]) {
                    Utils.log.info("Using free flag bit 1<<" + n5 + " for " + n6 + " occurrences of " + layout);
                    continue;
                }
                Utils.log.info("Using overflow index " + n5 + " for " + n6 + " occurrences of " + layout);
            }
        }
        this.maxFlags = null;
        this.allLayouts = null;
    }

    void visitAttributeLayoutsIn(int n, Attribute.Holder holder) {
        int n2 = n;
        this.maxFlags[n2] = this.maxFlags[n2] | holder.flags;
        for (Attribute attribute : holder.getAttributes()) {
            Attribute.Layout layout = attribute.layout();
            int[] nArray = (int[])this.allLayouts[n].get(layout);
            if (nArray == null) {
                nArray = new int[1];
                this.allLayouts[n].put(layout, nArray);
            }
            if (nArray[0] >= Integer.MAX_VALUE) continue;
            nArray[0] = nArray[0] + 1;
        }
    }

    void writeAttrDefs() throws IOException {
        int n;
        int n2;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (n2 = 0; n2 < 4; ++n2) {
            int n3 = this.attrDefs[n2].size();
            for (int i = 0; i < n3; ++i) {
                int n4 = n2;
                if (i < this.attrIndexLimit[n2]) {
                    assert ((n4 |= i + 1 << 2) < 256);
                    if (!PackageWriter.testBit(this.attrDefSeen[n2], 1L << i)) continue;
                }
                Attribute.Layout layout = (Attribute.Layout)this.attrDefs[n2].get(i);
                arrayList.add(new Object[]{new Integer(n4), layout});
                assert (new Integer(i).equals(this.attrIndexTable.get(layout)));
            }
        }
        n2 = arrayList.size();
        Object[][] objectArrayArray = new Object[n2][];
        arrayList.toArray((T[])objectArrayArray);
        Arrays.sort(objectArrayArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                int n = ((Comparable)objectArray[0]).compareTo(objectArray2[0]);
                if (n != 0) {
                    return n;
                }
                Object v = PackageWriter.this.attrIndexTable.get(objectArray[1]);
                Object v2 = PackageWriter.this.attrIndexTable.get(objectArray2[1]);
                assert (v != null);
                assert (v2 != null);
                return ((Comparable)v).compareTo(v2);
            }
        });
        this.attrDefsWritten = new Attribute.Layout[n2];
        PrintStream printStream = !this.optDumpBands ? null : new PrintStream(PackageWriter.getDumpStream(this.attr_definition_headers, ".def"));
        int[] nArray = new int[4];
        for (n = 0; n < 4; ++n) {
            nArray[n] = this.attrIndexLimit[n];
        }
        for (n = 0; n < objectArrayArray.length; ++n) {
            int n5;
            Attribute.Layout layout;
            int n6 = (Integer)objectArrayArray[n][0];
            this.attrDefsWritten[n] = layout = (Attribute.Layout)objectArrayArray[n][1];
            assert ((n6 & 3) == layout.ctype());
            this.attr_definition_headers.putByte(n6);
            this.attr_definition_name.putRef(ConstantPool.getUtf8Entry(layout.name()));
            String string = layout.layoutForPackageMajver(this.getPackageMajver());
            this.attr_definition_layout.putRef(ConstantPool.getUtf8Entry(string));
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (bl) {
                n5 = (n6 >> 2) - 1;
                if (n5 < 0) {
                    int n7 = layout.ctype();
                    int n8 = nArray[n7];
                    nArray[n7] = n8 + 1;
                    n5 = n8;
                }
                int n9 = (Integer)this.attrIndexTable.get(layout);
                assert (n5 == n9);
            }
            if (printStream == null) continue;
            n5 = (n6 >> 2) - 1;
            printStream.println(n5 + " " + layout);
        }
        if (printStream != null) {
            printStream.close();
        }
    }

    void writeAttrCounts() throws IOException {
        block0: for (int i = 0; i < 4; ++i) {
            BandStructure.MultiBand multiBand = this.attrBands[i];
            BandStructure.IntBand intBand = PackageWriter.getAttrBand(multiBand, 4);
            Attribute.Layout[] layoutArray = new Attribute.Layout[this.attrDefs[i].size()];
            this.attrDefs[i].toArray(layoutArray);
            boolean bl = true;
            while (true) {
                for (int j = 0; j < layoutArray.length; ++j) {
                    int n;
                    Attribute.Layout layout = layoutArray[j];
                    if (layout == null || bl != this.isPredefinedAttr(i, j) || (n = this.attrCounts[i][j]) == 0) continue;
                    int[] nArray = (int[])this.backCountTable.get(layout);
                    for (int k = 0; k < nArray.length; ++k) {
                        if (nArray[k] >= 0) {
                            int n2 = nArray[k];
                            nArray[k] = -1;
                            intBand.putInt(n2);
                            assert (layout.getCallables()[k].flagTest((byte)8));
                            continue;
                        }
                        assert (!layout.getCallables()[k].flagTest((byte)8));
                    }
                }
                if (!bl) continue block0;
                bl = false;
            }
        }
    }

    void trimClassAttributes() {
        for (Package.Class clazz : this.pkg.classes) {
            clazz.minimizeSourceFile();
        }
    }

    void collectInnerClasses() {
        HashMap<ConstantPool.ClassEntry, Package.InnerClass> hashMap = new HashMap<ConstantPool.ClassEntry, Package.InnerClass>();
        for (Object object : this.pkg.classes) {
            if (!((Package.Class)object).hasInnerClasses()) continue;
            for (Package.InnerClass innerClass : ((Package.Class)object).getInnerClasses()) {
                Package.InnerClass innerClass2 = hashMap.put(innerClass.thisClass, innerClass);
                if (innerClass2 == null || innerClass2.equals(innerClass) || !innerClass2.predictable) continue;
                hashMap.put(innerClass2.thisClass, innerClass2);
            }
        }
        Object[] objectArray = new Package.InnerClass[hashMap.size()];
        hashMap.values().toArray(objectArray);
        hashMap = null;
        Arrays.sort(objectArray);
        this.pkg.setAllInnerClasses(Arrays.asList(objectArray));
        for (Object object : this.pkg.classes) {
            ((Package.Class)object).minimizeLocalICs();
        }
    }

    void writeInnerClasses() throws IOException {
        for (Package.InnerClass innerClass : this.pkg.getAllInnerClasses()) {
            int n = innerClass.flags;
            assert ((n & 0x10000) == 0);
            if (!innerClass.predictable) {
                n |= 0x10000;
            }
            this.ic_this_class.putRef(innerClass.thisClass);
            this.ic_flags.putInt(n);
            if (innerClass.predictable) continue;
            this.ic_outer_class.putRef(innerClass.outerClass);
            this.ic_name.putRef(innerClass.name);
        }
    }

    void writeLocalInnerClasses(Package.Class clazz) throws IOException {
        List list = clazz.getInnerClasses();
        this.class_InnerClasses_N.putInt(list.size());
        for (Package.InnerClass innerClass : list) {
            this.class_InnerClasses_RC.putRef(innerClass.thisClass);
            if (innerClass.equals(this.pkg.getGlobalInnerClass(innerClass.thisClass))) {
                this.class_InnerClasses_F.putInt(0);
                continue;
            }
            int n = innerClass.flags;
            if (n == 0) {
                n = 65536;
            }
            this.class_InnerClasses_F.putInt(n);
            this.class_InnerClasses_outer_RCN.putRef(innerClass.outerClass);
            this.class_InnerClasses_name_RUN.putRef(innerClass.name);
        }
    }

    void writeClassesAndByteCodes() throws IOException {
        Package.Class[] classArray = new Package.Class[this.pkg.classes.size()];
        this.pkg.classes.toArray(classArray);
        if (this.verbose > 0) {
            Utils.log.info("  ...scanning " + classArray.length + " classes...");
        }
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            Package.Class clazz = classArray[i];
            if (this.verbose > 1) {
                Utils.log.fine("Scanning " + clazz);
            }
            ConstantPool.ClassEntry classEntry = clazz.thisClass;
            ConstantPool.ClassEntry classEntry2 = clazz.superClass;
            ConstantPool.ClassEntry[] classEntryArray = clazz.interfaces;
            assert (classEntry2 != classEntry);
            if (classEntry2 == null) {
                classEntry2 = classEntry;
            }
            this.class_this.putRef(classEntry);
            this.class_super.putRef(classEntry2);
            this.class_interface_count.putInt(clazz.interfaces.length);
            for (int j = 0; j < classEntryArray.length; ++j) {
                this.class_interface.putRef(classEntryArray[j]);
            }
            this.writeMembers(clazz);
            this.writeAttrs(0, clazz, clazz);
            if (this.verbose <= 0 || ++n % 1000 != 0) continue;
            Utils.log.info("Have scanned " + n + " classes...");
        }
    }

    void writeMembers(Package.Class clazz) throws IOException {
        Object object2;
        List list = clazz.getFields();
        this.class_field_count.putInt(list.size());
        for (Object object2 : list) {
            this.field_descr.putRef(((Package.Class.Member)object2).getDescriptor());
            this.writeAttrs(1, (Attribute.Holder)object2, clazz);
        }
        List list2 = clazz.getMethods();
        this.class_method_count.putInt(list2.size());
        object2 = list2.iterator();
        while (object2.hasNext()) {
            Package.Class.Method method = (Package.Class.Method)object2.next();
            this.method_descr.putRef(method.getDescriptor());
            this.writeAttrs(2, method, clazz);
            assert (method.code != null == (method.getAttribute(this.attrCodeEmpty) != null));
            if (method.code == null) continue;
            this.writeCodeHeader(method.code);
            this.writeByteCodes(method.code);
        }
    }

    void writeCodeHeader(Code code) throws IOException {
        boolean bl = PackageWriter.testBit(this.archiveOptions, 4);
        int n = code.attributeSize();
        int n2 = PackageWriter.shortCodeHeader(code);
        if (!bl && n > 0) {
            n2 = 0;
        }
        if (this.verbose > 2) {
            int n3 = code.getMethod().getArgumentSize();
            Utils.log.fine("Code sizes info " + code.max_stack + " " + code.max_locals + " " + code.getHandlerCount() + " " + n3 + " " + n + (n2 > 0 ? " SHORT=" + n2 : ""));
        }
        this.code_headers.putByte(n2);
        if (n2 == 0) {
            this.code_max_stack.putInt(code.getMaxStack());
            this.code_max_na_locals.putInt(code.getMaxNALocals());
            this.code_handler_count.putInt(code.getHandlerCount());
        } else {
            assert (bl || n == 0);
            assert (code.getHandlerCount() < this.shortCodeHeader_h_limit);
        }
        this.writeCodeHandlers(code);
        if (n2 == 0 || bl) {
            this.writeAttrs(3, code, code.thisClass());
        }
    }

    void writeCodeHandlers(Code code) throws IOException {
        int n = code.getHandlerCount();
        for (int i = 0; i < n; ++i) {
            this.code_handler_class_RCN.putRef(code.handler_class[i]);
            int n2 = code.encodeBCI(code.handler_start[i]);
            this.code_handler_start_P.putInt(n2);
            int n3 = code.encodeBCI(code.handler_end[i]) - n2;
            this.code_handler_end_PO.putInt(n3);
            n2 += n3;
            n3 = code.encodeBCI(code.handler_catch[i]) - n2;
            this.code_handler_catch_PO.putInt(n3);
        }
    }

    void writeAttrs(int n, final Attribute.Holder holder, Package.Class clazz) throws IOException {
        BandStructure.MultiBand multiBand = this.attrBands[n];
        BandStructure.IntBand intBand = PackageWriter.getAttrBand(multiBand, 0);
        BandStructure.IntBand intBand2 = PackageWriter.getAttrBand(multiBand, 1);
        boolean bl = this.haveFlagsHi(n);
        assert (this.attrIndexLimit[n] == (bl ? 63 : 32));
        if (holder.attributes == null) {
            intBand2.putInt(holder.flags);
            if (bl) {
                intBand.putInt(0);
            }
            return;
        }
        if (this.verbose > 3) {
            Utils.log.fine("Transmitting attrs for " + holder + " flags=" + Integer.toHexString(holder.flags));
        }
        long l = this.attrFlagMask[n];
        long l2 = 0L;
        int n2 = 0;
        Object object = holder.attributes.listIterator();
        while (object.hasNext()) {
            boolean bl2;
            BandStructure.Band[] bandArray;
            Attribute attribute = (Attribute)object.next();
            Attribute.Layout layout = attribute.layout();
            int n3 = (Integer)this.attrIndexTable.get(layout);
            assert (this.attrDefs[n].get(n3) == layout);
            if (this.verbose > 3) {
                Utils.log.fine("add attr @" + n3 + " " + attribute + " in " + holder);
            }
            if (n3 < this.attrIndexLimit[n] && PackageWriter.testBit(l, 1L << n3)) {
                if (this.verbose > 3) {
                    Utils.log.fine("Adding flag bit 1<<" + n3 + " in " + Long.toHexString(l));
                }
                assert (!PackageWriter.testBit((long)holder.flags, 1L << n3));
                l2 |= 1L << n3;
                l -= 1L << n3;
            } else {
                l2 |= 0x10000L;
                ++n2;
                if (this.verbose > 3) {
                    Utils.log.fine("Adding overflow attr #" + n2);
                }
                bandArray = PackageWriter.getAttrBand(multiBand, 3);
                bandArray.putInt(n3);
            }
            if (layout.bandCount == 0) {
                if (layout != this.attrInnerClassesEmpty) continue;
                this.writeLocalInnerClasses((Package.Class)holder);
                continue;
            }
            assert (attribute.fixups == null);
            bandArray = (BandStructure.Band[])this.attrBandTable.get(layout);
            assert (bandArray != null);
            assert (bandArray.length == layout.bandCount);
            final int[] nArray = (int[])this.backCountTable.get(layout);
            assert (nArray != null);
            assert (nArray.length == layout.getCallables().length);
            if (this.verbose > 2) {
                Utils.log.fine("writing " + attribute + " in " + holder);
            }
            boolean bl3 = bl2 = n == 1 && layout == this.attrConstantValue;
            if (bl2) {
                this.setConstantValueIndex((Package.Class.Field)holder);
            }
            attribute.parse(clazz, attribute.bytes(), 0, attribute.size(), new Attribute.ValueStream(){

                @Override
                public void putInt(int n, int n2) {
                    ((BandStructure.IntBand)bandArray[n]).putInt(n2);
                }

                @Override
                public void putRef(int n, ConstantPool.Entry entry) {
                    ((BandStructure.CPRefBand)bandArray[n]).putRef(entry);
                }

                @Override
                public int encodeBCI(int n) {
                    Code code = (Code)holder;
                    return code.encodeBCI(n);
                }

                @Override
                public void noteBackCall(int n) {
                    assert (nArray[n] >= 0);
                    int n2 = n;
                    nArray[n2] = nArray[n2] + 1;
                }
            });
            if (!bl2) continue;
            this.setConstantValueIndex(null);
        }
        if (n2 > 0) {
            object = PackageWriter.getAttrBand(multiBand, 2);
            ((BandStructure.IntBand)object).putInt(n2);
        }
        intBand2.putInt(holder.flags | (int)l2);
        if (bl) {
            intBand.putInt((int)(l2 >>> 32));
        } else assert (l2 >>> 32 == 0L);
        assert (((long)holder.flags & l2) == 0L) : holder + ".flags=" + Integer.toHexString(holder.flags) + "^" + Long.toHexString(l2);
    }

    private void beginCode(Code code) {
        assert (this.curCode == null);
        this.curCode = code;
        this.curClass = code.m.thisClass();
        this.curCPMap = code.getCPMap();
    }

    private void endCode() {
        this.curCode = null;
        this.curClass = null;
        this.curCPMap = null;
    }

    private int initOpVariant(Instruction instruction, ConstantPool.Entry entry) {
        if (instruction.getBC() != 183) {
            return -1;
        }
        ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
        if (memberEntry.descRef.nameRef.stringValue() != "<init>") {
            return -1;
        }
        ConstantPool.ClassEntry classEntry = memberEntry.classRef;
        if (classEntry == this.curClass.thisClass) {
            return 230;
        }
        if (classEntry == this.curClass.superClass) {
            return 231;
        }
        if (classEntry == entry) {
            return 232;
        }
        return -1;
    }

    private int selfOpVariant(Instruction instruction) {
        int n = instruction.getBC();
        if (n < 178 || n > 184) {
            return -1;
        }
        ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
        ConstantPool.ClassEntry classEntry = memberEntry.classRef;
        int n2 = 202 + (n - 178);
        if (classEntry == this.curClass.thisClass) {
            return n2;
        }
        if (classEntry == this.curClass.superClass) {
            return n2 + 14;
        }
        return -1;
    }

    void writeByteCodes(Code code) throws IOException {
        this.beginCode(code);
        ConstantPool.IndexGroup indexGroup = this.pkg.cp;
        boolean bl = false;
        ConstantPool.Entry entry = null;
        block42: for (Instruction instruction = code.instructionAt(0); instruction != null; instruction = instruction.next()) {
            Instruction instruction2;
            int n;
            if (this.verbose > 3) {
                Utils.log.fine(instruction.toString());
            }
            if (instruction.isNonstandard() && (!this.p200.getBoolean("com.sun.java.util.jar.pack.invokedynamic") || instruction.getBC() != 186)) {
                String string = code.getMethod() + " contains an unrecognized bytecode " + instruction + "; please use the pass-file option on this class.";
                Utils.log.warning(string);
                throw new IOException(string);
            }
            if (instruction.isWide()) {
                if (this.verbose > 1) {
                    Utils.log.fine("_wide opcode in " + code);
                    Utils.log.fine(instruction.toString());
                }
                this.bc_codes.putByte(196);
                this.codeHist[196] = this.codeHist[196] + 1;
            }
            if ((n = instruction.getBC()) == 42 && this.selfOpVariant(instruction2 = code.instructionAt(instruction.getNextPC())) >= 0) {
                bl = true;
                continue;
            }
            int n2 = this.initOpVariant(instruction, entry);
            if (n2 >= 0) {
                if (bl) {
                    this.bc_codes.putByte(42);
                    this.codeHist[42] = this.codeHist[42] + 1;
                    bl = false;
                }
                this.bc_codes.putByte(n2);
                int n3 = n2;
                this.codeHist[n3] = this.codeHist[n3] + 1;
                ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
                int n4 = indexGroup.getOverloadingIndex(memberEntry);
                this.bc_initref.putInt(n4);
                continue;
            }
            int n5 = this.selfOpVariant(instruction);
            if (n5 >= 0) {
                boolean bl2 = Instruction.isFieldOp(n);
                boolean bl3 = n5 >= 216;
                boolean bl4 = bl;
                bl = false;
                if (bl4) {
                    n5 += 7;
                }
                this.bc_codes.putByte(n5);
                int n6 = n5;
                this.codeHist[n6] = this.codeHist[n6] + 1;
                ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)instruction.getCPRef(this.curCPMap);
                BandStructure.CPRefBand cPRefBand = this.selfOpRefBand(n5);
                ConstantPool.Index index = indexGroup.getMemberIndex(memberEntry.tag, memberEntry.classRef);
                cPRefBand.putRef((ConstantPool.Entry)memberEntry, index);
                continue;
            }
            assert (!bl);
            int n7 = n;
            this.codeHist[n7] = this.codeHist[n7] + 1;
            switch (n) {
                case 170: 
                case 171: {
                    int n8;
                    this.bc_codes.putByte(n);
                    Instruction.Switch switch_ = (Instruction.Switch)instruction;
                    int n9 = switch_.getAlignedPC();
                    int n10 = switch_.getNextPC();
                    int n11 = switch_.getCaseCount();
                    this.bc_case_count.putInt(n11);
                    this.putLabel(this.bc_label, code, instruction.getPC(), switch_.getDefaultLabel());
                    for (n8 = 0; n8 < n11; ++n8) {
                        this.putLabel(this.bc_label, code, instruction.getPC(), switch_.getCaseLabel(n8));
                    }
                    if (n == 170) {
                        this.bc_case_value.putInt(switch_.getCaseValue(0));
                        continue block42;
                    }
                    for (n8 = 0; n8 < n11; ++n8) {
                        this.bc_case_value.putInt(switch_.getCaseValue(n8));
                    }
                    continue block42;
                }
                default: {
                    switch (n) {
                        case 186: {
                            instruction.setNonstandardLength(3);
                            int n12 = instruction.getShortAt(1);
                            ConstantPool.Entry entry2 = n12 == 0 ? null : this.curCPMap[n12];
                            this.bc_codes.putByte(254);
                            this.bc_escsize.putInt(1);
                            this.bc_escbyte.putByte(n);
                            this.bc_codes.putByte(253);
                            this.bc_escrefsize.putInt(2);
                            this.bc_escref.putRef(entry2);
                            continue block42;
                        }
                    }
                    int n13 = instruction.getBranchLabel();
                    if (n13 >= 0) {
                        this.bc_codes.putByte(n);
                        this.putLabel(this.bc_label, code, instruction.getPC(), n13);
                        continue block42;
                    }
                    ConstantPool.Entry entry3 = instruction.getCPRef(this.curCPMap);
                    if (entry3 != null) {
                        BandStructure.CPRefBand cPRefBand;
                        if (n == 187) {
                            entry = entry3;
                        }
                        if (n == 18) {
                            byte by = entry3.tag;
                            this.ldcHist[by] = this.ldcHist[by] + 1;
                        }
                        int n14 = n;
                        block6 : switch (instruction.getCPTag()) {
                            case 20: {
                                switch (entry3.tag) {
                                    case 3: {
                                        cPRefBand = this.bc_intref;
                                        switch (n) {
                                            case 18: {
                                                n14 = 234;
                                                break block6;
                                            }
                                            case 19: {
                                                n14 = 237;
                                                break block6;
                                            }
                                        }
                                        assert (false);
                                        break block6;
                                    }
                                    case 4: {
                                        cPRefBand = this.bc_floatref;
                                        switch (n) {
                                            case 18: {
                                                n14 = 235;
                                                break block6;
                                            }
                                            case 19: {
                                                n14 = 238;
                                                break block6;
                                            }
                                        }
                                        assert (false);
                                        break block6;
                                    }
                                    case 5: {
                                        cPRefBand = this.bc_longref;
                                        assert (n == 20);
                                        n14 = 20;
                                        break block6;
                                    }
                                    case 6: {
                                        cPRefBand = this.bc_doubleref;
                                        assert (n == 20);
                                        n14 = 239;
                                        break block6;
                                    }
                                    case 8: {
                                        cPRefBand = this.bc_stringref;
                                        switch (n) {
                                            case 18: {
                                                n14 = 18;
                                                break block6;
                                            }
                                            case 19: {
                                                n14 = 19;
                                                break block6;
                                            }
                                        }
                                        assert (false);
                                        break block6;
                                    }
                                    case 7: {
                                        cPRefBand = this.bc_classref;
                                        switch (n) {
                                            case 18: {
                                                n14 = 233;
                                                break block6;
                                            }
                                            case 19: {
                                                n14 = 236;
                                                break block6;
                                            }
                                        }
                                        assert (false);
                                        break block6;
                                    }
                                    default: {
                                        cPRefBand = null;
                                        assert (false);
                                        break block6;
                                    }
                                }
                            }
                            case 7: {
                                if (entry3 == this.curClass.thisClass) {
                                    entry3 = null;
                                }
                                cPRefBand = this.bc_classref;
                                break;
                            }
                            case 9: {
                                cPRefBand = this.bc_fieldref;
                                break;
                            }
                            case 10: {
                                cPRefBand = this.bc_methodref;
                                break;
                            }
                            case 11: {
                                cPRefBand = this.bc_imethodref;
                                break;
                            }
                            default: {
                                cPRefBand = null;
                                assert (false);
                                break;
                            }
                        }
                        this.bc_codes.putByte(n14);
                        cPRefBand.putRef(entry3);
                        if (n == 197) {
                            assert (instruction.getConstant() == code.getByte(instruction.getPC() + 3));
                            this.bc_byte.putByte(0xFF & instruction.getConstant());
                            continue block42;
                        }
                        if (n == 185) {
                            assert (instruction.getLength() == 5);
                            assert (instruction.getConstant() == 1 + ((ConstantPool.MemberEntry)entry3).descRef.typeRef.computeSize(true) << 8);
                            continue block42;
                        }
                        assert (instruction.getLength() == (n == 18 ? 2 : 3));
                        continue block42;
                    }
                    int n15 = instruction.getLocalSlot();
                    if (n15 >= 0) {
                        this.bc_codes.putByte(n);
                        this.bc_local.putInt(n15);
                        int n16 = instruction.getConstant();
                        if (n == 132) {
                            if (!instruction.isWide()) {
                                this.bc_byte.putByte(0xFF & n16);
                                continue block42;
                            }
                            this.bc_short.putInt(0xFFFF & n16);
                            continue block42;
                        }
                        assert (n16 == 0);
                        continue block42;
                    }
                    this.bc_codes.putByte(n);
                    int n17 = instruction.getPC() + 1;
                    int n18 = instruction.getNextPC();
                    if (n17 >= n18) continue block42;
                    switch (n) {
                        case 17: {
                            this.bc_short.putInt(0xFFFF & instruction.getConstant());
                            continue block42;
                        }
                        case 16: {
                            this.bc_byte.putByte(0xFF & instruction.getConstant());
                            continue block42;
                        }
                        case 188: {
                            this.bc_byte.putByte(0xFF & instruction.getConstant());
                            continue block42;
                        }
                    }
                    assert (false);
                    continue block42;
                }
            }
        }
        this.bc_codes.putByte(255);
        ++this.bc_codes.elementCountForDebug;
        this.codeHist[255] = this.codeHist[255] + 1;
        this.endCode();
    }

    void printCodeHist() {
        int n;
        assert (this.verbose > 0);
        Object[] objectArray = new String[this.codeHist.length];
        int n2 = 0;
        for (n = 0; n < this.codeHist.length; ++n) {
            n2 += this.codeHist[n];
        }
        for (n = 0; n < this.codeHist.length; ++n) {
            if (this.codeHist[n] == 0) {
                objectArray[n] = "";
                continue;
            }
            String string = Instruction.byteName(n);
            String string2 = "" + this.codeHist[n];
            string2 = "         ".substring(string2.length()) + string2;
            String string3 = "" + this.codeHist[n] * 10000 / n2;
            while (string3.length() < 4) {
                string3 = "0" + string3;
            }
            string3 = string3.substring(0, string3.length() - 2) + "." + string3.substring(string3.length() - 2);
            objectArray[n] = string2 + "  " + string3 + "%  " + string;
        }
        Arrays.sort(objectArray);
        System.out.println("Bytecode histogram [" + n2 + "]");
        n = objectArray.length;
        while (--n >= 0) {
            if (objectArray[n] == "") continue;
            System.out.println((String)objectArray[n]);
        }
        for (n = 0; n < this.ldcHist.length; ++n) {
            int n3 = this.ldcHist[n];
            if (n3 == 0) continue;
            System.out.println("ldc " + ConstantPool.tagName(n) + " " + n3);
        }
    }
}

