/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.Introspector;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.BooleanValueExp;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryParser;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class AttributeValueExp
implements ValueExp {
    private static final long serialVersionUID = -7768025046539163385L;
    private String attr;
    private transient int dotIndex;

    @Deprecated
    public AttributeValueExp() {
    }

    public AttributeValueExp(String string) {
        this.attr = string;
        this.setDotIndex();
    }

    private void setDotIndex() {
        if (this.attr != null) {
            this.dotIndex = this.attr.indexOf(46);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.setDotIndex();
    }

    public String getAttributeName() {
        return this.attr;
    }

    @Override
    public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        Object object = this.getAttribute(objectName);
        if (object instanceof Number) {
            return new NumericValueExp((Number)object);
        }
        if (object instanceof String) {
            return new StringValueExp((String)object);
        }
        if (object instanceof Boolean) {
            return new BooleanValueExp((Boolean)object);
        }
        throw new BadAttributeValueExpException(object);
    }

    public String toString() {
        return QueryParser.quoteId(this.attr);
    }

    @Override
    @Deprecated
    public void setMBeanServer(MBeanServer mBeanServer) {
    }

    protected Object getAttribute(ObjectName objectName) {
        try {
            MBeanServer mBeanServer = QueryEval.getMBeanServer();
            try {
                return mBeanServer.getAttribute(objectName, this.attr);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (this.dotIndex < 0) {
                    throw attributeNotFoundException;
                }
                String string = this.attr.substring(0, this.dotIndex);
                Object object = mBeanServer.getAttribute(objectName, string);
                return this.extractElement(object, this.attr.substring(this.dotIndex + 1));
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Object extractElement(Object object, String string) throws AttributeNotFoundException {
        while (true) {
            int n;
            String string2 = (n = string.indexOf(46)) < 0 ? string : string.substring(0, n);
            object = Introspector.elementFromComplex(object, string2);
            if (n < 0) {
                return object;
            }
            string = string.substring(n + 1);
        }
    }
}

