/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.Painter;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import javax.swing.plaf.nimbus.State;
import javax.swing.plaf.nimbus.SynthPainterImpl;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public final class NimbusStyle
extends SynthStyle {
    public static final String LARGE_KEY = "large";
    public static final String SMALL_KEY = "small";
    public static final String MINI_KEY = "mini";
    public static final double LARGE_SCALE = 1.15;
    public static final double SMALL_SCALE = 0.857;
    public static final double MINI_SCALE = 0.714;
    private static final Object NULL = Character.valueOf('\u0000');
    private static final Color DEFAULT_COLOR = new ColorUIResource(Color.BLACK);
    private static final Comparator<RuntimeState> STATE_COMPARATOR = new Comparator<RuntimeState>(){

        @Override
        public int compare(RuntimeState runtimeState, RuntimeState runtimeState2) {
            return runtimeState.state - runtimeState2.state;
        }
    };
    private String prefix;
    private SynthPainter painter;
    private Values values;
    private CacheKey tmpKey = new CacheKey("", 0);
    private JComponent component;

    NimbusStyle(String string, JComponent jComponent) {
        this.component = jComponent;
        this.prefix = string;
        this.painter = new SynthPainterImpl(this);
    }

    @Override
    public void installDefaults(SynthContext synthContext) {
        this.validate();
        super.installDefaults(synthContext);
    }

    /*
     * Could not resolve type clashes
     */
    private void validate() {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (this.values != null) {
            return;
        }
        this.values = new Values();
        String[] stringArray = ((NimbusLookAndFeel)UIManager.getLookAndFeel()).getDefaultsForPrefix(this.prefix);
        if (this.component != null && (object6 = this.component.getClientProperty("Nimbus.Overrides")) instanceof UIDefaults) {
            object5 = this.component.getClientProperty("Nimbus.Overrides.InheritDefaults");
            boolean bl = object5 instanceof Boolean ? (Boolean)object5 : true;
            object4 = (UIDefaults)object6;
            object3 = new TreeMap();
            for (Object object22 : ((Hashtable)object4).keySet()) {
                if (!(object22 instanceof String) || !((String)(object = (String)object22)).startsWith(this.prefix)) continue;
                ((TreeMap)object3).put(object, ((UIDefaults)object4).get(object));
            }
            if (bl) {
                stringArray.putAll(object3);
            } else {
                stringArray = object3;
            }
        }
        object6 = new ArrayList();
        object5 = new HashMap();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        object4 = (String)stringArray.get(this.prefix + ".States");
        if (object4 != null) {
            int n;
            object3 = ((String)object4).split(",");
            for (n = 0; n < ((String[])object3).length; ++n) {
                object3[n] = object3[n].trim();
                if (!State.isStandardStateName(object3[n])) {
                    object22 = this.prefix + "." + (String)object3[n];
                    object = (State)stringArray.get(object22);
                    if (object == null) continue;
                    object6.add(object);
                    continue;
                }
                object6.add(State.getStandardState(object3[n]));
            }
            if (object6.size() > 0) {
                this.values.stateTypes = object6.toArray(new State[object6.size()]);
            }
            n = 1;
            object22 = object6.iterator();
            while (object22.hasNext()) {
                object = (State)object22.next();
                object5.put(((State)object).getName(), n);
                n <<= 1;
            }
        } else {
            object6.add(State.Enabled);
            object6.add(State.MouseOver);
            object6.add(State.Pressed);
            object6.add(State.Disabled);
            object6.add(State.Focused);
            object6.add(State.Selected);
            object6.add(State.Default);
            object5.put("Enabled", 1);
            object5.put("MouseOver", 2);
            object5.put("Pressed", 4);
            object5.put("Disabled", 8);
            object5.put("Focused", 256);
            object5.put("Selected", 512);
            object5.put("Default", 1024);
        }
        for (String string : stringArray.keySet()) {
            String[] stringArray2;
            object22 = string.substring(this.prefix.length());
            if (((String)object22).indexOf(34) != -1 || ((String)object22).indexOf(58) != -1) continue;
            object22 = ((String)object22).substring(1);
            object = null;
            Object object7 = null;
            int n = ((String)object22).indexOf(93);
            if (n < 0) {
                object7 = object22;
            } else {
                object = ((String)object22).substring(0, n);
                object7 = ((String)object22).substring(n + 2);
            }
            if (object == null) {
                if ("contentMargins".equals(object7)) {
                    this.values.contentMargins = (Insets)stringArray.get(string);
                    continue;
                }
                if ("States".equals(object7)) continue;
                this.values.defaults.put(object7, stringArray.get(string));
                continue;
            }
            boolean bl = false;
            int n2 = 0;
            for (String string2 : stringArray2 = ((String)object).split("\\+")) {
                if (object5.containsKey(string2)) {
                    n2 |= ((Integer)object5.get(string2)).intValue();
                    continue;
                }
                bl = true;
                break;
            }
            if (bl) continue;
            Object object8 = null;
            for (RuntimeState runtimeState : arrayList) {
                if (runtimeState.state != n2) continue;
                object8 = runtimeState;
                break;
            }
            if (object8 == null) {
                object8 = new RuntimeState(n2, (String)object);
                arrayList.add((String[])object8);
            }
            if ("backgroundPainter".equals(object7)) {
                object8.backgroundPainter = this.getPainter((Map<String, Object>)stringArray, string);
                continue;
            }
            if ("foregroundPainter".equals(object7)) {
                object8.foregroundPainter = this.getPainter((Map<String, Object>)stringArray, string);
                continue;
            }
            if ("borderPainter".equals(object7)) {
                object8.borderPainter = this.getPainter((Map<String, Object>)stringArray, string);
                continue;
            }
            object8.defaults.put(object7, stringArray.get(string));
        }
        Collections.sort(arrayList, STATE_COMPARATOR);
        this.values.states = arrayList.toArray(new RuntimeState[arrayList.size()]);
    }

    private Painter getPainter(Map<String, Object> map, String string) {
        Object object = map.get(string);
        if (object instanceof UIDefaults.LazyValue) {
            object = ((UIDefaults.LazyValue)object).createValue(UIManager.getDefaults());
        }
        return object instanceof Painter ? (Painter)object : null;
    }

    @Override
    public Insets getInsets(SynthContext synthContext, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Values values = this.getValues(synthContext);
        if (values.contentMargins == null) {
            insets.right = 0;
            insets.left = 0;
            insets.top = 0;
            insets.bottom = 0;
            return insets;
        }
        insets.bottom = values.contentMargins.bottom;
        insets.top = values.contentMargins.top;
        insets.left = values.contentMargins.left;
        insets.right = values.contentMargins.right;
        String string = (String)synthContext.getComponent().getClientProperty("JComponent.sizeVariant");
        if (string != null) {
            if (LARGE_KEY.equals(string)) {
                insets.bottom = (int)((double)insets.bottom * 1.15);
                insets.top = (int)((double)insets.top * 1.15);
                insets.left = (int)((double)insets.left * 1.15);
                insets.right = (int)((double)insets.right * 1.15);
            } else if (SMALL_KEY.equals(string)) {
                insets.bottom = (int)((double)insets.bottom * 0.857);
                insets.top = (int)((double)insets.top * 0.857);
                insets.left = (int)((double)insets.left * 0.857);
                insets.right = (int)((double)insets.right * 0.857);
            } else if (MINI_KEY.equals(string)) {
                insets.bottom = (int)((double)insets.bottom * 0.714);
                insets.top = (int)((double)insets.top * 0.714);
                insets.left = (int)((double)insets.left * 0.714);
                insets.right = (int)((double)insets.right * 0.714);
            }
        }
        return insets;
    }

    @Override
    protected Color getColorForState(SynthContext synthContext, ColorType colorType) {
        String string = null;
        if (colorType == ColorType.BACKGROUND) {
            string = "background";
        } else if (colorType == ColorType.FOREGROUND) {
            string = "textForeground";
        } else if (colorType == ColorType.TEXT_BACKGROUND) {
            string = "textBackground";
        } else if (colorType == ColorType.TEXT_FOREGROUND) {
            string = "textForeground";
        } else if (colorType == ColorType.FOCUS) {
            string = "focus";
        } else if (colorType != null) {
            string = colorType.toString();
        } else {
            return DEFAULT_COLOR;
        }
        Color color = (Color)this.get(synthContext, string);
        if (color == null) {
            color = DEFAULT_COLOR;
        }
        return color;
    }

    @Override
    protected Font getFontForState(SynthContext synthContext) {
        String string;
        Font font = (Font)this.get(synthContext, "font");
        if (font == null) {
            font = UIManager.getFont("defaultFont");
        }
        if ((string = (String)synthContext.getComponent().getClientProperty("JComponent.sizeVariant")) != null) {
            if (LARGE_KEY.equals(string)) {
                font = font.deriveFont(Math.round((double)font.getSize2D() * 1.15));
            } else if (SMALL_KEY.equals(string)) {
                font = font.deriveFont(Math.round((double)font.getSize2D() * 0.857));
            } else if (MINI_KEY.equals(string)) {
                font = font.deriveFont(Math.round((double)font.getSize2D() * 0.714));
            }
        }
        return font;
    }

    @Override
    public SynthPainter getPainter(SynthContext synthContext) {
        return this.painter;
    }

    @Override
    public boolean isOpaque(SynthContext synthContext) {
        if ("Table.cellRenderer".equals(synthContext.getComponent().getName())) {
            return true;
        }
        Boolean bl = (Boolean)this.get(synthContext, "opaque");
        return bl == null ? false : bl;
    }

    @Override
    public Object get(SynthContext synthContext, Object object) {
        boolean bl;
        Values values = this.getValues(synthContext);
        String string = object.toString();
        String string2 = string.substring(string.indexOf(".") + 1);
        Object object2 = null;
        int n = this.getExtendedState(synthContext, values);
        this.tmpKey.init(string2, n);
        object2 = values.cache.get(this.tmpKey);
        boolean bl2 = bl = object2 != null;
        if (!bl) {
            RuntimeState runtimeState = null;
            int[] nArray = new int[]{-1};
            while (object2 == null && (runtimeState = this.getNextState(values.states, nArray, n)) != null) {
                object2 = runtimeState.defaults.get(string2);
            }
            if (object2 == null && values.defaults != null) {
                object2 = values.defaults.get(string2);
            }
            if (object2 == null) {
                object2 = UIManager.get(string);
            }
            if (object2 == null && string2.equals("focusInputMap")) {
                object2 = super.get(synthContext, string);
            }
            values.cache.put(new CacheKey(string2, n), object2 == null ? NULL : object2);
        }
        return object2 == NULL ? null : object2;
    }

    public Painter getBackgroundPainter(SynthContext synthContext) {
        Values values = this.getValues(synthContext);
        int n = this.getExtendedState(synthContext, values);
        Painter painter = null;
        this.tmpKey.init("backgroundPainter$$instance", n);
        painter = (Painter)values.cache.get(this.tmpKey);
        if (painter != null) {
            return painter;
        }
        RuntimeState runtimeState = null;
        int[] nArray = new int[]{-1};
        while ((runtimeState = this.getNextState(values.states, nArray, n)) != null) {
            if (runtimeState.backgroundPainter == null) continue;
            painter = runtimeState.backgroundPainter;
            break;
        }
        if (painter == null) {
            painter = (Painter)this.get(synthContext, "backgroundPainter");
        }
        if (painter != null) {
            values.cache.put(new CacheKey("backgroundPainter$$instance", n), painter);
        }
        return painter;
    }

    public Painter getForegroundPainter(SynthContext synthContext) {
        Values values = this.getValues(synthContext);
        int n = this.getExtendedState(synthContext, values);
        Painter painter = null;
        this.tmpKey.init("foregroundPainter$$instance", n);
        painter = (Painter)values.cache.get(this.tmpKey);
        if (painter != null) {
            return painter;
        }
        RuntimeState runtimeState = null;
        int[] nArray = new int[]{-1};
        while ((runtimeState = this.getNextState(values.states, nArray, n)) != null) {
            if (runtimeState.foregroundPainter == null) continue;
            painter = runtimeState.foregroundPainter;
            break;
        }
        if (painter == null) {
            painter = (Painter)this.get(synthContext, "foregroundPainter");
        }
        if (painter != null) {
            values.cache.put(new CacheKey("foregroundPainter$$instance", n), painter);
        }
        return painter;
    }

    public Painter getBorderPainter(SynthContext synthContext) {
        Values values = this.getValues(synthContext);
        int n = this.getExtendedState(synthContext, values);
        Painter painter = null;
        this.tmpKey.init("borderPainter$$instance", n);
        painter = (Painter)values.cache.get(this.tmpKey);
        if (painter != null) {
            return painter;
        }
        RuntimeState runtimeState = null;
        int[] nArray = new int[]{-1};
        while ((runtimeState = this.getNextState(values.states, nArray, n)) != null) {
            if (runtimeState.borderPainter == null) continue;
            painter = runtimeState.borderPainter;
            break;
        }
        if (painter == null) {
            painter = (Painter)this.get(synthContext, "borderPainter");
        }
        if (painter != null) {
            values.cache.put(new CacheKey("borderPainter$$instance", n), painter);
        }
        return painter;
    }

    private Values getValues(SynthContext synthContext) {
        this.validate();
        return this.values;
    }

    private boolean contains(String[] stringArray, String string) {
        assert (string != null);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private int getExtendedState(SynthContext synthContext, Values values) {
        JComponent jComponent = synthContext.getComponent();
        int n = 0;
        int n2 = 1;
        Object object = jComponent.getClientProperty("Nimbus.State");
        if (object != null) {
            String string = object.toString();
            String[] stringArray = string.split("\\+");
            if (values.stateTypes == null) {
                for (String string2 : stringArray) {
                    State.StandardState standardState = State.getStandardState(string2);
                    if (standardState == null) continue;
                    n |= standardState.getState();
                }
            } else {
                for (State state : values.stateTypes) {
                    if (this.contains(stringArray, state.getName())) {
                        n |= n2;
                    }
                    n2 <<= 1;
                }
            }
        } else {
            if (values.stateTypes == null) {
                return synthContext.getComponentState();
            }
            int n3 = synthContext.getComponentState();
            for (State state : values.stateTypes) {
                if (state.isInState(jComponent, n3)) {
                    n |= n2;
                }
                n2 <<= 1;
            }
        }
        return n;
    }

    private RuntimeState getNextState(RuntimeState[] runtimeStateArray, int[] nArray, int n) {
        if (runtimeStateArray != null && runtimeStateArray.length > 0) {
            int n2 = 0;
            int n3 = -1;
            int n4 = -1;
            if (n == 0) {
                for (int i = runtimeStateArray.length - 1; i >= 0; --i) {
                    if (runtimeStateArray[i].state != 0) continue;
                    nArray[0] = i;
                    return runtimeStateArray[i];
                }
                nArray[0] = -1;
                return null;
            }
            int n5 = nArray == null || nArray[0] == -1 ? runtimeStateArray.length : nArray[0];
            for (int i = n5 - 1; i >= 0; --i) {
                int n6 = runtimeStateArray[i].state;
                if (n6 == 0) {
                    if (n4 != -1) continue;
                    n4 = i;
                    continue;
                }
                if ((n & n6) != n6) continue;
                int n7 = n6;
                n7 -= (0xAAAAAAAA & n7) >>> 1;
                n7 = (n7 & 0x33333333) + (n7 >>> 2 & 0x33333333);
                n7 = n7 + (n7 >>> 4) & 0xF0F0F0F;
                n7 += n7 >>> 8;
                n7 += n7 >>> 16;
                if ((n7 &= 0xFF) <= n2) continue;
                n3 = i;
                n2 = n7;
            }
            if (n3 != -1) {
                nArray[0] = n3;
                return runtimeStateArray[n3];
            }
            if (n4 != -1) {
                nArray[0] = n4;
                return runtimeStateArray[n4];
            }
        }
        nArray[0] = -1;
        return null;
    }

    private static final class CacheKey {
        private String key;
        private int xstate;

        CacheKey(Object object, int n) {
            this.init(object, n);
        }

        void init(Object object, int n) {
            this.key = object.toString();
            this.xstate = n;
        }

        public boolean equals(Object object) {
            CacheKey cacheKey = (CacheKey)object;
            if (object == null) {
                return false;
            }
            if (this.xstate != cacheKey.xstate) {
                return false;
            }
            return this.key.equals(cacheKey.key);
        }

        public int hashCode() {
            int n = 3;
            n = 29 * n + this.key.hashCode();
            n = 29 * n + this.xstate;
            return n;
        }
    }

    private static final class Values {
        State[] stateTypes = null;
        RuntimeState[] states = null;
        Insets contentMargins;
        UIDefaults defaults = new UIDefaults(10, 0.7f);
        Map<CacheKey, Object> cache = new HashMap<CacheKey, Object>();

        private Values() {
        }
    }

    private final class RuntimeState
    implements Cloneable {
        int state;
        Painter backgroundPainter;
        Painter foregroundPainter;
        Painter borderPainter;
        String stateName;
        UIDefaults defaults = new UIDefaults(10, 0.7f);

        private RuntimeState(int n, String string) {
            this.state = n;
            this.stateName = string;
        }

        public String toString() {
            return this.stateName;
        }

        public RuntimeState clone() {
            RuntimeState runtimeState = new RuntimeState(this.state, this.stateName);
            runtimeState.backgroundPainter = this.backgroundPainter;
            runtimeState.foregroundPainter = this.foregroundPainter;
            runtimeState.borderPainter = this.borderPainter;
            runtimeState.defaults.putAll(this.defaults);
            return runtimeState;
        }
    }
}

